/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.guava;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.guava.Cancelled;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\rH\u0016J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001e\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0017\u0010\u001c\u001a\u00028\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060!j\u0002`\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\rH\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0016J\b\u0010(\u001a\u00020)H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\t \n*\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lkotlinx/coroutines/guava/JobListenableFuture;", "T", "Lcom/google/common/util/concurrent/ListenableFuture;", "jobToCancel", "Lkotlinx/coroutines/Job;", "<init>", "(Lkotlinx/coroutines/Job;)V", "auxFuture", "Lcom/google/common/util/concurrent/SettableFuture;", "", "kotlin.jvm.PlatformType", "Lcom/google/common/util/concurrent/SettableFuture;", "auxFutureIsFailed", "", "complete", "result", "(Ljava/lang/Object;)Z", "completeExceptionallyOrCancel", "t", "", "isCancelled", "get", "()Ljava/lang/Object;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", "getInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", "addListener", "", "listener", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "executor", "Ljava/util/concurrent/Executor;", "isDone", "cancel", "mayInterruptIfRunning", "toString", "", "kotlinx-coroutines-guava"})
@SourceDebugExtension(value={"SMAP\nListenableFuture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListenableFuture.kt\nkotlinx/coroutines/guava/JobListenableFuture\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n1#2:507\n*E\n"})
final class JobListenableFuture<T>
implements ListenableFuture<T> {
    @NotNull
    private final Job jobToCancel;
    private final SettableFuture<Object> auxFuture;
    private boolean auxFutureIsFailed;

    public JobListenableFuture(@NotNull Job jobToCancel) {
        this.jobToCancel = jobToCancel;
        this.auxFuture = SettableFuture.create();
    }

    public final boolean complete(T result) {
        return this.auxFuture.set(result);
    }

    public final boolean completeExceptionallyOrCancel(@NotNull Throwable t) {
        boolean bl;
        if (t instanceof CancellationException) {
            bl = this.auxFuture.set((Object)new Cancelled((CancellationException)t));
        } else {
            boolean bl2;
            boolean it = bl2 = this.auxFuture.setException(t);
            boolean bl3 = false;
            if (it) {
                this.auxFutureIsFailed = true;
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isCancelled() {
        boolean bl;
        if (this.auxFuture.isCancelled()) return true;
        if (!this.isDone()) return false;
        if (this.auxFutureIsFailed) return false;
        try {
            bl = Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture)) instanceof Cancelled;
        }
        catch (CancellationException e) {
            return true;
        }
        catch (ExecutionException e) {
            this.auxFutureIsFailed = true;
            return false;
        }
        if (!bl) return false;
        return true;
    }

    public T get() {
        return this.getInternal(this.auxFuture.get());
    }

    public T get(long timeout, @NotNull TimeUnit unit) {
        return this.getInternal(this.auxFuture.get(timeout, unit));
    }

    private final T getInternal(Object result) {
        if (result instanceof Cancelled) {
            throw new CancellationException().initCause(((Cancelled)result).exception);
        }
        return (T)result;
    }

    public void addListener(@NotNull Runnable listener2, @NotNull Executor executor) {
        this.auxFuture.addListener(listener2, executor);
    }

    public boolean isDone() {
        return this.auxFuture.isDone();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean bl;
        if (this.auxFuture.cancel(mayInterruptIfRunning)) {
            Job.DefaultImpls.cancel$default((Job)this.jobToCancel, null, (int)1, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append(super.toString());
        $this$toString_u24lambda_u241.append("[status=");
        if (this.isDone()) {
            try {
                Object result = Uninterruptibles.getUninterruptibly((Future)((Future)this.auxFuture));
                StringBuilder stringBuilder2 = result instanceof Cancelled ? $this$toString_u24lambda_u241.append("CANCELLED, cause=[" + ((Cancelled)result).exception + ']') : $this$toString_u24lambda_u241.append("SUCCESS, result=[" + result + ']');
            }
            catch (CancellationException e) {
                StringBuilder stringBuilder3 = $this$toString_u24lambda_u241.append("CANCELLED");
            }
            catch (ExecutionException e) {
                StringBuilder stringBuilder4 = $this$toString_u24lambda_u241.append("FAILURE, cause=[" + e.getCause() + ']');
            }
            catch (Throwable t) {
                StringBuilder stringBuilder5 = $this$toString_u24lambda_u241.append("UNKNOWN, cause=[" + t.getClass() + " thrown from get()]");
            }
        } else {
            $this$toString_u24lambda_u241.append("PENDING, delegate=[" + this.auxFuture + ']');
        }
        $this$toString_u24lambda_u241.append(']');
        return stringBuilder.toString();
    }
}

