/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.api.settings.DependencyResolutionManagementModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginManagementModel;
import com.android.tools.idea.gradle.dsl.api.settings.PluginsBlockModel;
import com.android.tools.idea.gradle.dsl.model.GradleFileModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleModelFactory;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelBuilder;
import com.android.tools.idea.gradle.dsl.model.ext.GradlePropertyModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.DependencyResolutionManagementModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.PluginManagementModelImpl;
import com.android.tools.idea.gradle.dsl.model.settings.PluginsBlockModelImpl;
import com.android.tools.idea.gradle.dsl.parser.ExternalNameInfo;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.dsl.parser.include.IncludeDslElement;
import com.android.tools.idea.gradle.dsl.parser.plugins.PluginsDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.DependencyResolutionManagementDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.PluginManagementDslElement;
import com.android.tools.idea.gradle.dsl.parser.settings.ProjectPropertiesDslElement;
import com.android.tools.idea.gradle.dsl.utils.BuildScriptUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleSettingsModelImpl
extends GradleFileModelImpl
implements GradleSettingsModel {
    @NotNull
    protected GradleSettingsFile myGradleSettingsFile;
    private final ModulePathsCache myModulePathsCache;

    public GradleSettingsModelImpl(@NotNull GradleSettingsFile parsedModel) {
        if (parsedModel == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(0);
        }
        super(parsedModel);
        this.myModulePathsCache = new ModulePathsCache();
        this.myGradleSettingsFile = parsedModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Set<String> modulePaths() {
        long committedCount = this.myGradleDslFile.getLastCommittedModificationCount();
        long modificationCount = this.myGradleDslFile.getModificationCount();
        IncludeDslElement includePaths = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE);
        ModulePathsCache modulePathsCache = this.myModulePathsCache;
        synchronized (modulePathsCache) {
            if (this.myModulePathsCache.committedCount == modificationCount) {
                LinkedHashSet<String> linkedHashSet = this.myModulePathsCache.paths;
                // MONITOREXIT @DISABLED, blocks:[3, 9] lbl8 : MonitorExitStatement: MONITOREXIT : var6_4
                if (linkedHashSet == null) {
                    GradleSettingsModelImpl.$$$reportNull$$$0(1);
                }
                return linkedHashSet;
            }
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(":");
        if (includePaths != null) {
            for (GradleDslSimpleExpression includePath : includePaths.getModules()) {
                String value = includePath.getValue(String.class);
                if (value == null) continue;
                result.add(GradleSettingsModelImpl.standardiseModulePath(value));
            }
        }
        ModulePathsCache modulePathsCache2 = this.myModulePathsCache;
        synchronized (modulePathsCache2) {
            this.myModulePathsCache.paths = result;
            this.myModulePathsCache.committedCount = committedCount;
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    @Override
    public void addModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(3);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        IncludeDslElement includeDslElement = this.myGradleDslFile.ensurePropertyElement(IncludeDslElement.INCLUDE);
        GradleDslLiteral literal = new GradleDslLiteral(includeDslElement, GradleNameElement.create(IncludeDslElement.INCLUDE.name));
        literal.setValue(modulePath);
        includeDslElement.setNewElement(literal);
    }

    @Override
    public void removeModulePath(@NotNull String modulePath) {
        IncludeDslElement includeDslElement;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(4);
        }
        if ((includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE)) != null) {
            if (!modulePath.startsWith(":")) {
                includeDslElement.removeModule(":" + modulePath);
            }
            includeDslElement.removeModule(modulePath);
        }
    }

    @Override
    public void replaceModulePath(@NotNull String oldModulePath, @NotNull String newModulePath) {
        IncludeDslElement includeDslElement;
        if (oldModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(5);
        }
        if (newModulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(6);
        }
        if ((includeDslElement = this.myGradleDslFile.getPropertyElement(IncludeDslElement.INCLUDE)) != null) {
            if (!((String)newModulePath).startsWith(":")) {
                newModulePath = ":" + (String)newModulePath;
            }
            if (!oldModulePath.startsWith(":")) {
                includeDslElement.replaceModulePath(":" + oldModulePath, newModulePath);
            }
            includeDslElement.replaceModulePath(oldModulePath, newModulePath);
        }
    }

    @Override
    @Nullable
    public File moduleDirectory(String modulePath) {
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        if (!this.modulePaths().contains(modulePath)) {
            return null;
        }
        return this.moduleDirectoryNoCheck(modulePath, new HashMap<String, File>());
    }

    @Override
    public void setModuleDirectory(@NotNull String modulePath, @NotNull File moduleDir) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(7);
        }
        if (moduleDir == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(8);
        }
        String projectKey = "project('" + modulePath + "')";
        String projectDirPropertyName = projectKey + ".projectDir";
        GradleNameElement projectKeyName = GradleNameElement.fake(projectKey);
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.ensureNamedPropertyElement(ProjectPropertiesDslElement.PROJECT_PROPERTIES, projectKeyName);
        GradleDslMethodCall currentElement = projectProperties.getPropertyElement("projectDir", GradleDslMethodCall.class);
        if (currentElement != null) {
            projectProperties.removeProperty(currentElement);
        }
        GradleNameElement gradleNameElement = GradleNameElement.fake(projectDirPropertyName);
        GradleDslMethodCall methodCall = new GradleDslMethodCall((GradleDslElement)this.myGradleDslFile, gradleNameElement, "file");
        methodCall.setExternalSyntax(ExternalNameInfo.ExternalNameSyntax.ASSIGNMENT);
        projectProperties.setNewElement(methodCall);
        String dirPath = moduleDir.getAbsolutePath();
        File rootDir = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (VfsUtilCore.isAncestor((File)rootDir, (File)moduleDir, (boolean)false)) {
            GradleDslLiteral rootDirArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            GradlePropertyModelImpl elementModel = GradlePropertyModelBuilder.create(rootDirArg).build();
            rootDirArg.setValue(ReferenceTo.createReferenceFromText("rootDir", elementModel));
            methodCall.addNewArgument(rootDirArg);
            methodCall.setMethodName("File");
            methodCall.setIsConstructor(true);
            dirPath = rootDir.toURI().relativize(moduleDir.toURI()).getPath();
        }
        if (dirPath != null && !dirPath.isEmpty()) {
            GradleDslLiteral extraArg = new GradleDslLiteral(methodCall, GradleNameElement.empty());
            extraArg.setValue(dirPath);
            methodCall.addNewArgument(extraArg);
        }
    }

    @Nullable
    private File moduleDirectoryNoCheck(String modulePath, Map<String, File> processedModulePath) {
        File parentDir;
        File projectDir;
        if (processedModulePath.containsKey(modulePath)) {
            return processedModulePath.get(modulePath);
        }
        File rootDirPath = VfsUtilCore.virtualToIoFile((VirtualFile)this.myGradleDslFile.getFile().getParent());
        if (modulePath.equals(":")) {
            processedModulePath.put(modulePath, rootDirPath);
            return rootDirPath;
        }
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null && (projectDir = projectProperties.projectDir()) != null) {
            processedModulePath.put(modulePath, projectDir);
            return projectDir;
        }
        if (modulePath.lastIndexOf(58) == 0) {
            parentDir = rootDirPath;
        } else {
            String parentModule = GradleSettingsModelImpl.parentModuleNoCheck(modulePath);
            if (parentModule == null) {
                processedModulePath.put(modulePath, null);
                return null;
            }
            parentDir = this.moduleDirectoryNoCheck(parentModule, processedModulePath);
        }
        String moduleName = modulePath.substring(modulePath.lastIndexOf(58) + 1);
        File result = new File(parentDir, moduleName);
        processedModulePath.put(modulePath, result);
        return result;
    }

    @Override
    @Nullable
    public String moduleWithDirectory(@NotNull File moduleDir) {
        if (moduleDir == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(9);
        }
        HashMap<String, File> processedModulePath = new HashMap<String, File>();
        for (String modulePath : this.modulePaths()) {
            if (!FileUtil.filesEqual((File)moduleDir, (File)this.moduleDirectoryNoCheck(modulePath, processedModulePath))) continue;
            return modulePath;
        }
        return null;
    }

    @Override
    @Nullable
    public GradleBuildModel moduleModel(@NotNull String modulePath) {
        File buildFilePath;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(10);
        }
        if ((buildFilePath = this.buildFile(modulePath)) == null) {
            return null;
        }
        VirtualFile buildFile = VfsUtil.findFileByIoFile((File)buildFilePath, (boolean)false);
        if (buildFile == null) {
            return null;
        }
        GradleBuildFile dslFile = this.myGradleDslFile.getContext().getOrCreateBuildFile(buildFile, modulePath.substring(modulePath.lastIndexOf(58) + 1), false);
        return GradleModelFactory.createGradleBuildModel(dslFile);
    }

    @Override
    @Nullable
    public String parentModule(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(11);
        }
        modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath);
        Set<String> allModulePaths = this.modulePaths();
        if (!allModulePaths.contains(modulePath)) {
            return null;
        }
        String currentPath = modulePath;
        do {
            if (!allModulePaths.contains(currentPath = GradleSettingsModelImpl.parentModuleNoCheck(currentPath))) continue;
            return currentPath;
        } while (currentPath != null && !currentPath.equals(":"));
        return null;
    }

    @Nullable
    private static String parentModuleNoCheck(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(12);
        }
        if ((modulePath = GradleSettingsModelImpl.standardiseModulePath(modulePath)).equals(":")) {
            return null;
        }
        int lastPathElementIndex = modulePath.lastIndexOf(58);
        return lastPathElementIndex == 0 ? ":" : modulePath.substring(0, lastPathElementIndex);
    }

    @Override
    @Nullable
    public GradleBuildModel getParentModuleModel(@NotNull String modulePath) {
        String parentModule;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(13);
        }
        if ((parentModule = this.parentModule(modulePath)) == null) {
            return null;
        }
        return this.moduleModel(parentModule);
    }

    @Override
    @Nullable
    public File buildFile(@NotNull String modulePath) {
        File moduleDirectory;
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(14);
        }
        if ((moduleDirectory = this.moduleDirectory(modulePath)) == null) {
            return null;
        }
        String buildFileName = null;
        String projectKey = "project('" + modulePath + "')";
        ProjectPropertiesDslElement projectProperties = this.myGradleDslFile.getPropertyElement(projectKey, ProjectPropertiesDslElement.class);
        if (projectProperties != null) {
            buildFileName = projectProperties.getLiteral("buildFileName", String.class);
        }
        if (buildFileName == null) {
            return BuildScriptUtil.findGradleBuildFile(moduleDirectory);
        }
        return new File(moduleDirectory, buildFileName);
    }

    private static String standardiseModulePath(@NotNull String modulePath) {
        if (modulePath == null) {
            GradleSettingsModelImpl.$$$reportNull$$$0(15);
        }
        return modulePath.startsWith(":") ? modulePath : ":" + modulePath;
    }

    @Override
    @NotNull
    public DependencyResolutionManagementModel dependencyResolutionManagement() {
        DependencyResolutionManagementDslElement dependencyResolutionManagementElement = this.myGradleDslFile.ensurePropertyElement(DependencyResolutionManagementDslElement.DEPENDENCY_RESOLUTION_MANAGEMENT);
        return new DependencyResolutionManagementModelImpl(dependencyResolutionManagementElement);
    }

    @Override
    @NotNull
    public PluginManagementModel pluginManagement() {
        PluginManagementDslElement pluginManagementDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginManagementDslElement.PLUGIN_MANAGEMENT_DSL_ELEMENT, 0);
        return new PluginManagementModelImpl(pluginManagementDslElement);
    }

    @Override
    @NotNull
    public PluginsBlockModel plugins() {
        PluginManagementDslElement pluginManagementDslElement = this.myGradleDslFile.getPropertyElement(PluginManagementDslElement.PLUGIN_MANAGEMENT_DSL_ELEMENT);
        Integer at = pluginManagementDslElement == null ? 0 : 1;
        PluginsDslElement pluginsDslElement = this.myGradleDslFile.ensurePropertyElementAt(PluginsDslElement.PLUGINS, at);
        return new PluginsBlockModelImpl(pluginsDslElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldModulePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newModulePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/GradleSettingsModelImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "modulePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addModulePath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeModulePath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceModulePath";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setModuleDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moduleModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parentModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parentModuleNoCheck";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParentModuleModel";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "standardiseModulePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class ModulePathsCache {
        long committedCount = -1L;
        @NotNull
        LinkedHashSet<String> paths = new LinkedHashSet();

        ModulePathsCache() {
            this.paths.add(":");
        }
    }
}

