/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationScript.providers;

import com.intellij.configurationScript.BeanConstructorKt;
import com.intellij.configurationScript.ConfigurationFileManager;
import com.intellij.configurationScript.providers.ConfigurationScriptProjectStoreFactory;
import com.intellij.configurationScript.providers.MyProjectStore;
import com.intellij.configurationScript.providers.ReadOnlyStorage;
import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ProjectWithModuleStoreImpl;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerBase;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.XmlSerializerKt;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StoredProperty;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ReflectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J,\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014JD\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001f\u001a\u00020\u001aH\u0014J*\u0010 \u001a\u00020\u000e2\b\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020$H\u0014J\u001e\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(H\u0016R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/configurationScript/providers/MyProjectStore;", "Lcom/intellij/configurationStore/ProjectWithModuleStoreImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isConfigurationFileListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "storages", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "", "Lcom/intellij/configurationScript/providers/ReadOnlyStorage;", "configurationFileChanged", "", "unloadComponent", "component", "getReadOnlyStorage", "Lcom/intellij/openapi/components/StateStorage;", "componentClass", "stateClass", "configurationSchemaKey", "", "doCreateStateGetter", "Lcom/intellij/configurationStore/StateGetter;", "reloadData", "", "storage", "info", "Lcom/intellij/configurationStore/ComponentInfo;", "componentName", "useLoadedStateAsExisting", "setStateToSaveSessionProducer", "state", "effectiveComponentName", "sessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "reload", "", "changedStorages", "", "intellij.configurationScript"})
@SourceDebugExtension(value={"SMAP\nConfigurationScriptProjectStoreFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationScriptProjectStoreFactory.kt\ncom/intellij/configurationScript/providers/MyProjectStore\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n14#2:172\n*S KotlinDebug\n*F\n+ 1 ConfigurationScriptProjectStoreFactory.kt\ncom/intellij/configurationScript/providers/MyProjectStore\n*L\n120#1:172\n*E\n"})
final class MyProjectStore
extends ProjectWithModuleStoreImpl {
    @JvmField
    @NotNull
    public final AtomicBoolean isConfigurationFileListenerAdded;
    @NotNull
    private final ConcurrentHashMap<Class<Object>, ReadOnlyStorage> storages;

    public MyProjectStore(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.isConfigurationFileListenerAdded = new AtomicBoolean();
        this.storages = new ConcurrentHashMap();
    }

    public final void configurationFileChanged() {
        if (!((Map)this.storages).isEmpty()) {
            StoreReloadManager storeReloadManager = StoreReloadManager.Companion.getInstance(this.getProject());
            IComponentStore iComponentStore = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)this.getProject()));
            Collection<ReadOnlyStorage> collection = this.storages.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            storeReloadManager.storageFilesChanged(iComponentStore, (Collection)CollectionsKt.toList((Iterable)collection));
        }
    }

    public void unloadComponent(@NotNull Object component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super.unloadComponent(component);
        if (component instanceof PersistentStateComponent) {
            this.storages.remove(component.getClass());
        }
    }

    @NotNull
    protected StateStorage getReadOnlyStorage(@NotNull Class<Object> componentClass, @NotNull Class<Object> stateClass, @NotNull String configurationSchemaKey) {
        Intrinsics.checkNotNullParameter(componentClass, (String)"componentClass");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        Intrinsics.checkNotNullParameter((Object)configurationSchemaKey, (String)"configurationSchemaKey");
        ReadOnlyStorage readOnlyStorage = this.storages.computeIfAbsent(componentClass, arg_0 -> MyProjectStore.getReadOnlyStorage$lambda$1(arg_0 -> MyProjectStore.getReadOnlyStorage$lambda$0(configurationSchemaKey, componentClass, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)readOnlyStorage, (String)"computeIfAbsent(...)");
        return readOnlyStorage;
    }

    @NotNull
    protected StateGetter<Object> doCreateStateGetter(boolean reloadData, @NotNull StateStorage storage, @NotNull ComponentInfo info, @NotNull String componentName, @NotNull Class<Object> stateClass, boolean useLoadedStateAsExisting) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        StateGetter stateGetter = super.doCreateStateGetter(reloadData, storage, info, componentName, stateClass, useLoadedStateAsExisting);
        String string = info.getConfigurationSchemaKey();
        if (string == null) {
            return stateGetter;
        }
        String configurationSchemaKey = string;
        ConfigurationFileManager configurationFileManager = ConfigurationFileManager.Companion.getInstance(this.getProject());
        List<NodeTuple> list = configurationFileManager.findValueNode(configurationSchemaKey);
        if (list == null) {
            return stateGetter;
        }
        List<NodeTuple> node = list;
        return (StateGetter)new StateGetter<Object>((StateGetter<Object>)stateGetter, stateClass, node, info){
            final /* synthetic */ StateGetter<Object> $stateGetter;
            final /* synthetic */ Class<Object> $stateClass;
            final /* synthetic */ List<NodeTuple> $node;
            final /* synthetic */ ComponentInfo $info;
            {
                this.$stateGetter = $stateGetter;
                this.$stateClass = $stateClass;
                this.$node = $node;
                this.$info = $info;
            }

            public Object getState(Object mergeInto) {
                Object object = this.$stateGetter.getState(mergeInto);
                if (object == null) {
                    Object object2 = ReflectionUtil.newInstance(this.$stateClass, (boolean)false);
                    object = object2;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"newInstance(...)");
                }
                Object state = object;
                List affectedProperties = new ArrayList<E>();
                BeanConstructorKt.readIntoObject((BaseState)state, this.$node, (Function1<? super StoredProperty<Object>, Unit>)((Function1)arg_0 -> doCreateStateGetter.1.getState$lambda$0(affectedProperties, arg_0)));
                this.$info.affectedPropertyNames = affectedProperties;
                return state;
            }

            public Object archiveState() {
                return null;
            }

            private static final Unit getState$lambda$0(List $affectedProperties, StoredProperty it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                Intrinsics.checkNotNull((Object)string);
                $affectedProperties.add(string);
                return Unit.INSTANCE;
            }
        };
    }

    protected void setStateToSaveSessionProducer(@Nullable Object state, @NotNull ComponentInfo info, @NotNull String effectiveComponentName, @NotNull SaveSessionProducer sessionProducer) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)effectiveComponentName, (String)"effectiveComponentName");
        Intrinsics.checkNotNullParameter((Object)sessionProducer, (String)"sessionProducer");
        String configurationSchemaKey = info.getConfigurationSchemaKey();
        if (state == null || configurationSchemaKey == null || info.affectedPropertyNames.isEmpty() || !(sessionProducer instanceof SaveSessionProducerBase)) {
            super.setStateToSaveSessionProducer(state, info, effectiveComponentName, sessionProducer);
        } else {
            Element serializedState = XmlSerializerKt.deserializeBaseStateWithCustomNameFilter((BaseState)((BaseState)state), (Collection)info.affectedPropertyNames);
            ((SaveSessionProducerBase)sessionProducer).setSerializedState(effectiveComponentName, serializedState);
        }
    }

    @Nullable
    public Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        Intrinsics.checkNotNullParameter(changedStorages, (String)"changedStorages");
        Collection result = super.reload(changedStorages);
        for (StateStorage stateStorage : changedStorages) {
            if (!(stateStorage instanceof ReadOnlyStorage)) continue;
            Object component = this.getProject().getServiceIfCreated(((ReadOnlyStorage)stateStorage).componentClass);
            if (component == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(ConfigurationScriptProjectStoreFactory.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Cannot find component by " + ((ReadOnlyStorage)stateStorage).componentClass.getName());
                continue;
            }
            this.initComponentWithoutStateSpec((PersistentStateComponent)component, ((ReadOnlyStorage)stateStorage).configurationSchemaKey, PluginManagerCore.CORE_ID);
        }
        return result;
    }

    private static final ReadOnlyStorage getReadOnlyStorage$lambda$0(String $configurationSchemaKey, Class $componentClass, MyProjectStore this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ReadOnlyStorage($configurationSchemaKey, $componentClass, this$0);
    }

    private static final ReadOnlyStorage getReadOnlyStorage$lambda$1(Function1 $tmp0, Object p0) {
        return (ReadOnlyStorage)$tmp0.invoke(p0);
    }
}

