/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.Reader;
import java.io.Serializable;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.util.Parameter;

public final class Field
extends AbstractField
implements Fieldable,
Serializable {
    public String stringValue() {
        return this.fieldsData instanceof String ? (String)this.fieldsData : null;
    }

    public Reader readerValue() {
        return this.fieldsData instanceof Reader ? (Reader)this.fieldsData : null;
    }

    public byte[] binaryValue() {
        if (!this.isBinary) {
            return null;
        }
        byte[] data = (byte[])this.fieldsData;
        if (this.binaryOffset == 0 && data.length == this.binaryLength) {
            return data;
        }
        byte[] ret = new byte[this.binaryLength];
        System.arraycopy(data, this.binaryOffset, ret, 0, this.binaryLength);
        return ret;
    }

    public TokenStream tokenStreamValue() {
        return this.fieldsData instanceof TokenStream ? (TokenStream)this.fieldsData : null;
    }

    public void setValue(String value) {
        this.fieldsData = value;
    }

    public void setValue(Reader value) {
        this.fieldsData = value;
    }

    public void setValue(byte[] value) {
        this.fieldsData = value;
        this.binaryLength = value.length;
        this.binaryOffset = 0;
    }

    public void setValue(byte[] value, int offset, int length) {
        this.fieldsData = value;
        this.binaryLength = length;
        this.binaryOffset = offset;
    }

    public void setValue(TokenStream value) {
        this.fieldsData = value;
    }

    public Field(String name, String value, Store store, Index index) {
        this(name, value, store, index, TermVector.NO);
    }

    public Field(String name, String value, Store store, Index index, TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        if (name.length() == 0 && value.length() == 0) {
            throw new IllegalArgumentException("name and value cannot both be empty");
        }
        if (index == Index.NO && store == Store.NO) {
            throw new IllegalArgumentException("it doesn't make sense to have a field that is neither indexed nor stored");
        }
        if (index == Index.NO && termVector != TermVector.NO) {
            throw new IllegalArgumentException("cannot store term vector information for a field that is not indexed");
        }
        this.name = name.intern();
        this.fieldsData = value;
        if (store == Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else if (store == Store.NO) {
            this.isStored = false;
            this.isCompressed = false;
        } else {
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        if (index == Index.NO) {
            this.isIndexed = false;
            this.isTokenized = false;
        } else if (index == Index.ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = true;
        } else if (index == Index.NOT_ANALYZED) {
            this.isIndexed = true;
            this.isTokenized = false;
        } else if (index == Index.NOT_ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = false;
            this.omitNorms = true;
        } else if (index == Index.ANALYZED_NO_NORMS) {
            this.isIndexed = true;
            this.isTokenized = true;
            this.omitNorms = true;
        } else {
            throw new IllegalArgumentException("unknown index parameter " + index);
        }
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String name, Reader reader) {
        this(name, reader, TermVector.NO);
    }

    public Field(String name, Reader reader, TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (reader == null) {
            throw new NullPointerException("reader cannot be null");
        }
        this.name = name.intern();
        this.fieldsData = reader;
        this.isStored = false;
        this.isCompressed = false;
        this.isIndexed = true;
        this.isTokenized = true;
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String name, TokenStream tokenStream) {
        this(name, tokenStream, TermVector.NO);
    }

    public Field(String name, TokenStream tokenStream, TermVector termVector) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (tokenStream == null) {
            throw new NullPointerException("tokenStream cannot be null");
        }
        this.name = name.intern();
        this.fieldsData = tokenStream;
        this.isStored = false;
        this.isCompressed = false;
        this.isIndexed = true;
        this.isTokenized = true;
        this.isBinary = false;
        this.setStoreTermVector(termVector);
    }

    public Field(String name, byte[] value, Store store) {
        this(name, value, 0, value.length, store);
    }

    public Field(String name, byte[] value, int offset, int length, Store store) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.name = name.intern();
        this.fieldsData = value;
        if (store == Store.YES) {
            this.isStored = true;
            this.isCompressed = false;
        } else if (store == Store.COMPRESS) {
            this.isStored = true;
            this.isCompressed = true;
        } else {
            if (store == Store.NO) {
                throw new IllegalArgumentException("binary values can't be unstored");
            }
            throw new IllegalArgumentException("unknown store parameter " + store);
        }
        this.isIndexed = false;
        this.isTokenized = false;
        this.isBinary = true;
        this.binaryLength = length;
        this.binaryOffset = offset;
        this.setStoreTermVector(TermVector.NO);
    }

    public static final class TermVector
    extends Parameter
    implements Serializable {
        public static final TermVector NO = new TermVector("NO");
        public static final TermVector YES = new TermVector("YES");
        public static final TermVector WITH_POSITIONS = new TermVector("WITH_POSITIONS");
        public static final TermVector WITH_OFFSETS = new TermVector("WITH_OFFSETS");
        public static final TermVector WITH_POSITIONS_OFFSETS = new TermVector("WITH_POSITIONS_OFFSETS");

        private TermVector(String name) {
            super(name);
        }
    }

    public static final class Index
    extends Parameter
    implements Serializable {
        public static final Index NO = new Index("NO");
        public static final Index ANALYZED;
        public static final Index TOKENIZED;
        public static final Index NOT_ANALYZED;
        public static final Index UN_TOKENIZED;
        public static final Index NOT_ANALYZED_NO_NORMS;
        public static final Index NO_NORMS;
        public static final Index ANALYZED_NO_NORMS;

        private Index(String name) {
            super(name);
        }

        static {
            TOKENIZED = ANALYZED = new Index("ANALYZED");
            UN_TOKENIZED = NOT_ANALYZED = new Index("NOT_ANALYZED");
            NO_NORMS = NOT_ANALYZED_NO_NORMS = new Index("NOT_ANALYZED_NO_NORMS");
            ANALYZED_NO_NORMS = new Index("ANALYZED_NO_NORMS");
        }
    }

    public static final class Store
    extends Parameter
    implements Serializable {
        public static final Store COMPRESS = new Store("COMPRESS");
        public static final Store YES = new Store("YES");
        public static final Store NO = new Store("NO");

        private Store(String name) {
            super(name);
        }
    }
}

