/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldCacheImpl;
import org.apache.lucene.search.SortComparator;

public interface FieldCache {
    public static final int STRING_INDEX = -1;
    public static final FieldCache DEFAULT = new FieldCacheImpl();

    public byte[] getBytes(IndexReader var1, String var2) throws IOException;

    public byte[] getBytes(IndexReader var1, String var2, ByteParser var3) throws IOException;

    public short[] getShorts(IndexReader var1, String var2) throws IOException;

    public short[] getShorts(IndexReader var1, String var2, ShortParser var3) throws IOException;

    public int[] getInts(IndexReader var1, String var2) throws IOException;

    public int[] getInts(IndexReader var1, String var2, IntParser var3) throws IOException;

    public float[] getFloats(IndexReader var1, String var2) throws IOException;

    public float[] getFloats(IndexReader var1, String var2, FloatParser var3) throws IOException;

    public String[] getStrings(IndexReader var1, String var2) throws IOException;

    public StringIndex getStringIndex(IndexReader var1, String var2) throws IOException;

    public Object getAuto(IndexReader var1, String var2) throws IOException;

    public Comparable[] getCustom(IndexReader var1, String var2, SortComparator var3) throws IOException;

    public static interface FloatParser {
        public float parseFloat(String var1);
    }

    public static interface IntParser {
        public int parseInt(String var1);
    }

    public static interface ShortParser {
        public short parseShort(String var1);
    }

    public static interface ByteParser {
        public byte parseByte(String var1);
    }

    public static class StringIndex {
        public final String[] lookup;
        public final int[] order;

        public StringIndex(int[] values, String[] lookup) {
            this.order = values;
            this.lookup = lookup;
        }
    }
}

