/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.text.paragraph.TextParagraph;
import com.intellij.ide.util.LoadedTipInfo;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipContentConverter;
import com.intellij.ide.util.TipEntity;
import com.intellij.ide.util.TipRetriever;
import com.intellij.ide.util.TipRetrieversInfo;
import com.intellij.ide.util.TipUiSettings;
import com.intellij.ide.util.TipUtils;
import com.intellij.l10n.LocalizationUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001aL\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0018\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0015\u0010)\u001a\u00070\u0013\u00a2\u0006\u0002\b*2\u0006\u0010+\u001a\u00020\nH\u0002\u001a\u0015\u0010,\u001a\u00070\u0013\u00a2\u0006\u0002\b-2\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0006\"\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "ENTITIES", "", "Lcom/intellij/ide/util/TipEntity;", "getENTITIES$annotations", "()V", "loadAndParseTip", "Lcom/intellij/ide/ui/text/paragraph/TextParagraph;", "tip", "Lcom/intellij/ide/util/TipAndTrickBean;", "contextComponent", "Ljava/awt/Component;", "isStrict", "", "loadTip", "Lcom/intellij/ide/util/LoadedTipInfo;", "productCodeTipMap", "", "", "tipDirectory", "getTipRetrievers", "Lcom/intellij/ide/util/TipRetrieversInfo;", "getLocalizationTipRetrievers", "Lcom/intellij/ide/util/TipRetriever;", "loader", "Ljava/lang/ClassLoader;", "loadImages", "Ljavax/swing/Icon;", "tipContent", "Lorg/jsoup/nodes/Element;", "primaryImagesLoader", "secondaryImagesLoader", "tipsPath", "inlineProductInfo", "", "handleWarning", "message", "handleError", "t", "", "getCantReadText", "Lorg/jetbrains/annotations/Nls;", "bean", "getPoweredByText", "Lcom/intellij/openapi/util/NlsSafe;", "intellij.platform.tips"})
@SourceDebugExtension(value={"SMAP\nTipUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TipUtils.kt\ncom/intellij/ide/util/TipUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,389:1\n1869#2,2:390\n1#3:392\n14#4:393\n*S KotlinDebug\n*F\n+ 1 TipUtils.kt\ncom/intellij/ide/util/TipUtilsKt\n*L\n200#1:390,2\n43#1:393\n*E\n"})
public final class TipUtilsKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<TipEntity> ENTITIES;
    @NotNull
    private static final Map<String, String> productCodeTipMap;
    @NotNull
    private static final String tipDirectory = "tips";

    private static /* synthetic */ void getENTITIES$annotations() {
    }

    private static final List<TextParagraph> loadAndParseTip(TipAndTrickBean tip, Component contextComponent, boolean isStrict) {
        LoadedTipInfo currentTip = TipUtilsKt.loadTip(tip, isStrict);
        Document document = Jsoup.parse((String)currentTip.getTipContent());
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document tipHtml = document;
        Element element = tipHtml.body();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"body(...)");
        Element tipContent = element;
        Map<String, Icon> icons = TipUtilsKt.loadImages(tipContent, currentTip.getTipImagesLoader(), currentTip.getTipContentLoader(), currentTip.getImagesLocation(), contextComponent, isStrict);
        TipUtilsKt.inlineProductInfo(tipContent);
        List<TextParagraph> paragraphs = new TipContentConverter(tipContent, icons, isStrict).convert();
        if (paragraphs.isEmpty()) {
            TipUtilsKt.handleWarning("Parsed paragraphs is empty for tip: " + tip, isStrict);
        } else {
            paragraphs.get(0).editAttributes(TipUtilsKt::loadAndParseTip$lambda$1);
        }
        return paragraphs;
    }

    private static final LoadedTipInfo loadTip(TipAndTrickBean tip, boolean isStrict) {
        if (tip == null) {
            String string = IdeBundle.message((String)"no.tip.of.the.day", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new LoadedTipInfo(string, null, null, null, 14, null);
        }
        try {
            Path tipFile = Path.of(tip.fileName, new String[0]);
            if (tipFile.isAbsolute() && Files.exists(tipFile, new LinkOption[0])) {
                String content = Files.readString(tipFile);
                Intrinsics.checkNotNull((Object)content);
                return new LoadedTipInfo(content, ((Object)tipFile.getParent()).toString(), null, null, 12, null);
            }
            TipRetrieversInfo retrieversInfo = TipUtilsKt.getTipRetrievers(tip);
            for (TipRetriever retriever : retrieversInfo.getTipRetrievers()) {
                String tipContent = retriever.getTipContent(tip.fileName);
                if (tipContent == null) continue;
                TipRetriever imagesTipRetriever = retrieversInfo.getImagesTipRetriever();
                String tipImagesLocation = imagesTipRetriever.path + "/" + (String)(((CharSequence)imagesTipRetriever.subPath).length() > 0 ? imagesTipRetriever.subPath + "/" : "");
                return new LoadedTipInfo(tipContent, tipImagesLocation, retriever.loader, imagesTipRetriever.loader);
            }
        }
        catch (IOException e) {
            TipUtilsKt.handleError(e, isStrict);
        }
        return new LoadedTipInfo(TipUtilsKt.getCantReadText(tip), null, null, null, 14, null);
    }

    private static final TipRetrieversInfo getTipRetrievers(TipAndTrickBean tip) {
        Object object = tip.getPluginDescriptor();
        if (object == null || (object = object.getPluginClassLoader()) == null) {
            object = TipUtils.class.getClassLoader();
        }
        Object defaultLoader = object;
        List retrievers = new ArrayList();
        Locale locale = LocalizationUtil.INSTANCE.getLocaleOrNullForDefault();
        if (locale != null) {
            Intrinsics.checkNotNull((Object)defaultLoader);
            retrievers.addAll((Collection)TipUtilsKt.getLocalizationTipRetrievers((ClassLoader)defaultLoader));
            ClassLoader localizationPluginLoader = LocalizationUtil.getPluginClassLoader$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, null, (int)3, null);
            if (localizationPluginLoader != null) {
                String string = ApplicationInfoEx.getInstanceEx().getApiVersionAsNumber().getProductCode();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                String ideCode = string2;
                if (StringsKt.contains$default((CharSequence)ideCode, (CharSequence)"ic", (boolean)false, (int)2, null)) {
                    ideCode = "iu";
                }
                String fallbackIdeCode = productCodeTipMap.getOrDefault(ideCode, ideCode);
                Object[] objectArray = new String[]{ideCode, fallbackIdeCode, "db_pl", "bdt", "misc"};
                Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    retrievers.add(new TipRetriever(localizationPluginLoader, tipDirectory, it, null, 8, null));
                }
            }
        }
        TipRetriever defaultRetriever = new TipRetriever((ClassLoader)defaultLoader, tipDirectory, "", null, 8, null);
        retrievers.add(defaultRetriever);
        return new TipRetrieversInfo(defaultRetriever, retrievers);
    }

    private static final List<TipRetriever> getLocalizationTipRetrievers(ClassLoader loader) {
        List result = new ArrayList();
        List folderPaths = LocalizationUtil.getFolderLocalizedPaths$default((LocalizationUtil)LocalizationUtil.INSTANCE, (String)tipDirectory, null, (int)2, null);
        List suffixes = LocalizationUtil.getLocalizationSuffixes$default((LocalizationUtil)LocalizationUtil.INSTANCE, null, (int)1, null);
        int n = ((Collection)folderPaths).size();
        for (int i = 0; i < n; ++i) {
            String it;
            if ((String)CollectionsKt.getOrNull((List)folderPaths, (int)i) != null) {
                boolean bl = false;
                result.add(new TipRetriever(loader, it, "", null, 8, null));
            }
            if ((String)CollectionsKt.getOrNull((List)suffixes, (int)i) == null) continue;
            boolean bl = false;
            result.add(new TipRetriever(loader, tipDirectory, "", it));
        }
        return result;
    }

    private static final Map<String, Icon> loadImages(Element tipContent, ClassLoader primaryImagesLoader, ClassLoader secondaryImagesLoader, String tipsPath, Component contextComponent, boolean isStrict) {
        if (tipsPath == null) {
            return MapsKt.emptyMap();
        }
        HashMap<String, Icon> icons = new HashMap<String, Icon>();
        Iterator iterator = tipContent.getElementsByTag("img").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String path;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element imgElement = (Element)e;
            if (!imgElement.hasAttr("src")) {
                TipUtilsKt.handleWarning("Not found src attribute in img element:\n" + imgElement, isStrict);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)imgElement.attr("src"), (String)"attr(...)");
            Image image = null;
            if (primaryImagesLoader == null) {
                URL imageUrl;
                try {
                    imageUrl = new File(tipsPath, path).toURI().toURL();
                    Intrinsics.checkNotNull((Object)imageUrl);
                    image = ImageLoader.loadFromUrl((URL)imageUrl);
                }
                catch (MalformedURLException e2) {
                    TipUtilsKt.handleError(e2, isStrict);
                }
                if (image == null) {
                    try {
                        imageUrl = new URL(null, path);
                        image = ImageLoader.loadFromUrl((URL)imageUrl);
                    }
                    catch (MalformedURLException e3) {
                        TipUtilsKt.handleError(e3, isStrict);
                    }
                }
            } else {
                image = ImageCacheKt.loadImageByClassLoader((String)(tipsPath + path), (ClassLoader)primaryImagesLoader, (ScaleContext)ScaleContext.Companion.create(contextComponent));
                if (image == null && secondaryImagesLoader != null) {
                    image = ImageCacheKt.loadImageByClassLoader((String)(tipsPath + path), (ClassLoader)secondaryImagesLoader, (ScaleContext)ScaleContext.Companion.create(contextComponent));
                }
            }
            if (image != null) {
                Icon icon = (Icon)new JBImageIcon(image);
                int maxWidth = TipUiSettings.getImageMaxWidth();
                if (icon.getIconWidth() > maxWidth) {
                    icon = IconUtil.scale((Icon)icon, null, (float)((float)maxWidth * 1.0f / (float)icon.getIconWidth()));
                }
                icons.put(path, icon);
                continue;
            }
            TipUtilsKt.handleWarning("Not found icon for path: " + tipsPath + path, isStrict);
        }
        return icons;
    }

    private static final void inlineProductInfo(Element tipContent) {
        Iterator iterator = tipContent.getElementsContainingOwnText("&").iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String text;
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Element element = (Element)e;
            Intrinsics.checkNotNullExpressionValue((Object)element.text(), (String)"text(...)");
            for (TipEntity entity : ENTITIES) {
                text = entity.inline(text);
            }
            element.text(text);
        }
    }

    private static final void handleWarning(String message, boolean isStrict) {
        if (isStrict) {
            throw new RuntimeException("Warning: " + message);
        }
        LOG.warn(message);
    }

    private static final void handleError(Throwable t, boolean isStrict) {
        if (isStrict) {
            throw t;
        }
        LOG.warn(t);
    }

    private static final String getCantReadText(TipAndTrickBean bean) {
        String string;
        Object[] objectArray;
        String plugin = TipUtilsKt.getPoweredByText(bean);
        if (!(((CharSequence)plugin).length() == 0)) {
            objectArray = new Object[]{ApplicationNamesInfo.getInstance().getFullProductName(), plugin};
            var3_3 = IdeBundle.message((String)"product.and.plugin", (Object[])objectArray);
            Intrinsics.checkNotNull((Object)var3_3);
            string = var3_3;
        } else {
            var3_3 = ApplicationNamesInfo.getInstance().getFullProductName();
            Intrinsics.checkNotNull((Object)var3_3);
            string = var3_3;
        }
        String product = string;
        objectArray = new Object[]{bean.fileName, product};
        String string2 = IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private static final String getPoweredByText(TipAndTrickBean tip) {
        String string;
        PluginDescriptor descriptor = tip.getPluginDescriptor();
        if (descriptor == null || Intrinsics.areEqual((Object)PluginManagerCore.CORE_ID, (Object)descriptor.getPluginId())) {
            string = "";
        } else {
            String string2 = descriptor.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        return string;
    }

    private static final Unit loadAndParseTip$lambda$1(SimpleAttributeSet $this$editAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$editAttributes, (String)"$this$editAttributes");
        StyleConstants.setSpaceAbove($this$editAttributes, 0.0f);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ List access$loadAndParseTip(TipAndTrickBean tip, Component contextComponent, boolean isStrict) {
        return TipUtilsKt.loadAndParseTip(tip, contextComponent, isStrict);
    }

    public static final /* synthetic */ TipRetrieversInfo access$getTipRetrievers(TipAndTrickBean tip) {
        return TipUtilsKt.getTipRetrievers(tip);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TipUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        ApplicationInfo appInfo = ApplicationInfo.getInstance();
        boolean bl = false;
        String string = ApplicationNamesInfo.getInstance().getFullProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFullProductName(...)");
        TipEntity tipEntity = new TipEntity("productName", string);
        String string2 = appInfo.getMajorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getMajorVersion(...)");
        TipEntity tipEntity2 = new TipEntity("majorVersion", string2);
        String string3 = appInfo.getMinorVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getMinorVersion(...)");
        TipEntity tipEntity3 = new TipEntity("minorVersion", string3);
        TipEntity tipEntity4 = new TipEntity("majorMinorVersion", appInfo.getMajorVersion() + (String)(Intrinsics.areEqual((Object)"0", (Object)appInfo.getMinorVersion()) ? "" : "." + appInfo.getMinorVersion()));
        String string4 = CommonBundle.settingsActionPath();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"settingsActionPath(...)");
        List<TipEntity> list = List.of(tipEntity, tipEntity2, tipEntity3, tipEntity4, new TipEntity("settingsPath", string4));
        Intrinsics.checkNotNullExpressionValue(list, (String)"let(...)");
        ENTITIES = list;
        Pair[] pairArray = new Pair[]{new Pair((Object)"iu", (Object)"ij"), new Pair((Object)"pc", (Object)"py_ce"), new Pair((Object)"ds", (Object)"py_ds")};
        productCodeTipMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

