/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.execution.GradleGroovyRunnerUtil;
import org.jetbrains.plugins.gradle.execution.GradleRunConfigurationProducer;
import org.jetbrains.plugins.gradle.execution.GradleRunnerUtil;
import org.jetbrains.plugins.gradle.service.execution.GradleRunConfiguration;

@ApiStatus.Internal
public final class GradleGroovyScriptRunConfigurationProducer
extends GradleRunConfigurationProducer {
    @Override
    @VisibleForTesting
    public boolean setupConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location contextLocation;
        if (configuration == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation = context.getLocation())) {
            return false;
        }
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(module);
        if (projectPath == null) {
            VirtualFile virtualFile = contextLocation.getVirtualFile();
            String string = projectPath = virtualFile != null ? virtualFile.getPath() : null;
        }
        if (projectPath == null) {
            return false;
        }
        List<String> tasksToRun = GradleGroovyRunnerUtil.getTasksTarget(contextLocation);
        ExternalSystemTaskExecutionSettings taskExecutionSettings = configuration.getSettings();
        taskExecutionSettings.setExternalProjectPath(projectPath);
        taskExecutionSettings.setTaskNames(tasksToRun);
        configuration.setName(AbstractExternalSystemTaskConfigurationType.generateName((Project)module.getProject(), (ExternalSystemTaskExecutionSettings)taskExecutionSettings));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull GradleRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Location contextLocation;
        if (configuration == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GradleGroovyScriptRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (!GradleRunnerUtil.isFromGroovyGradleScript(contextLocation = context.getLocation())) {
            return false;
        }
        if (context.getModule() == null) {
            return false;
        }
        String projectPath = GradleRunnerUtil.resolveProjectPath(context.getModule());
        if (projectPath == null) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)projectPath, (CharSequence)configuration.getSettings().getExternalProjectPath())) {
            return false;
        }
        List<String> tasks = GradleGroovyRunnerUtil.getTasksTarget(contextLocation);
        List taskNames = configuration.getSettings().getTaskNames();
        if (tasks.isEmpty() && taskNames.isEmpty()) {
            return true;
        }
        return tasks.containsAll(taskNames) && !taskNames.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleGroovyScriptRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConfigurationFromContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

