/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.codeInspection.htmlInspections.HtmlDeprecatedTagInspection;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithAnotherAction;
import com.intellij.htmltools.codeInspection.htmlInspections.htmltagreplace.ReplaceHtmlTagWithCssAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HtmlPresentationalElementInspection
extends HtmlLocalInspectionTool {
    @NonNls
    private static final Set<String> ourCssReplaceableTags;
    @NonNls
    private static final Set<String> ourHtmlReplaceableTagsHtml4;
    @NonNls
    private static final Set<String> ourHtmlReplaceableTagsHtml5;

    @NotNull
    public String getShortName() {
        return "HtmlPresentationalElement";
    }

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlPresentationalElementInspection.$$$reportNull$$$0(1);
        }
        String name = StringUtil.toLowerCase((String)tag.getName());
        if (HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            if (HtmlUtil.isHtml5Context((XmlElement)tag) && !ourHtmlReplaceableTagsHtml5.contains(tag.getName())) {
                return;
            }
            LocalQuickFix[] fixes = null;
            if (ourCssReplaceableTags.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithCssAction(name)};
                if (ourHtmlReplaceableTagsHtml4.contains(name)) {
                    fixes = new LocalQuickFix[]{fixes[0], new ReplaceHtmlTagWithAnotherAction(name)};
                }
            } else if (ourHtmlReplaceableTagsHtml4.contains(name)) {
                fixes = new LocalQuickFix[]{new ReplaceHtmlTagWithAnotherAction(name)};
            }
            HtmlDeprecatedTagInspection.registerTag(tag, "html.inspections.check.presentational.tag", holder, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    static {
        ourHtmlReplaceableTagsHtml4 = Set.of("i", "b", "tt");
        ourHtmlReplaceableTagsHtml5 = Set.of("i", "b");
        ourCssReplaceableTags = Set.of("i", "b", "big", "small", "tt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlPresentationalElementInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

