/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.Properties;

public abstract class PublicKeyKeyEncryptionMethodGenerator
implements PGPKeyEncryptionMethodGenerator {
    public static final String SESSION_KEY_OBFUSCATION_PROPERTY = "org.bouncycastle.openpgp.session_key_obfuscation";
    public static final long WILDCARD_KEYID = 0L;
    public static final long WILDCARD = 0L;
    public static final byte[] WILDCARD_FINGERPRINT = new byte[0];
    private final PGPPublicKey pubKey;
    protected boolean sessionKeyObfuscation;
    protected boolean useWildcardRecipient;

    private static boolean getSessionKeyObfuscationDefault() {
        return !Properties.isOverrideSetTo(SESSION_KEY_OBFUSCATION_PROPERTY, false);
    }

    protected PublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        switch (pGPPublicKey.getAlgorithm()) {
            case 1: 
            case 2: 
            case 16: 
            case 18: 
            case 20: 
            case 25: 
            case 26: {
                break;
            }
            case 3: {
                throw new IllegalArgumentException("Can't use an RSA_SIGN key for encryption.");
            }
            case 17: {
                throw new IllegalArgumentException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new IllegalArgumentException("Can't use ECDSA for encryption.");
            }
            case 22: 
            case 27: 
            case 28: {
                throw new IllegalArgumentException("Can't use EdDSA for encryption.");
            }
            default: {
                throw new IllegalArgumentException("unknown asymmetric algorithm: " + pGPPublicKey.getAlgorithm());
            }
        }
        this.pubKey = pGPPublicKey;
        this.sessionKeyObfuscation = PublicKeyKeyEncryptionMethodGenerator.getSessionKeyObfuscationDefault();
    }

    public PublicKeyKeyEncryptionMethodGenerator setSessionKeyObfuscation(boolean bl) {
        this.sessionKeyObfuscation = bl;
        return this;
    }

    @Deprecated
    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardKeyID(boolean bl) {
        return this.setUseWildcardRecipient(bl);
    }

    public PublicKeyKeyEncryptionMethodGenerator setUseWildcardRecipient(boolean bl) {
        this.useWildcardRecipient = bl;
        return this;
    }

    public byte[][] encodeEncryptedSessionInfo(byte[] byArray) throws PGPException {
        byte[][] byArrayArray;
        switch (this.pubKey.getAlgorithm()) {
            case 1: 
            case 2: {
                byArrayArray = new byte[][]{this.convertToEncodedMPI(byArray)};
                break;
            }
            case 16: 
            case 20: {
                byte[] byArray2 = new byte[byArray.length / 2];
                byte[] byArray3 = new byte[byArray.length / 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
                System.arraycopy(byArray, byArray2.length, byArray3, 0, byArray3.length);
                byArrayArray = new byte[][]{this.convertToEncodedMPI(byArray2), this.convertToEncodedMPI(byArray3)};
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                byArrayArray = new byte[][]{byArray};
                break;
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + this.pubKey.getAlgorithm());
            }
        }
        return byArrayArray;
    }

    private byte[] convertToEncodedMPI(byte[] byArray) throws PGPException {
        try {
            return new MPInteger(new BigInteger(1, byArray)).getEncoded();
        }
        catch (IOException iOException) {
            throw new PGPException("Invalid MPI encoding: " + iOException.getMessage(), iOException);
        }
    }

    @Override
    public ContainedPacket generate(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, byte[] byArray) throws PGPException {
        int n;
        byte[] byArray2;
        if (pGPDataEncryptorBuilder.getAeadAlgorithm() <= 0 || pGPDataEncryptorBuilder.isV5StyleAEAD()) {
            long l = this.useWildcardRecipient ? 0L : this.pubKey.getKeyID();
            byte[] byArray3 = this.encryptSessionInfo(this.pubKey, byArray, (byte)pGPDataEncryptorBuilder.getAlgorithm(), true);
            byte[][] byArray4 = this.encodeEncryptedSessionInfo(byArray3);
            return PublicKeyEncSessionPacket.createV3PKESKPacket(l, this.pubKey.getAlgorithm(), byArray4);
        }
        if (this.useWildcardRecipient) {
            byArray2 = WILDCARD_FINGERPRINT;
            n = 0;
        } else {
            byArray2 = this.pubKey.getFingerprint();
            n = this.pubKey.getVersion();
        }
        byte[] byArray5 = this.encryptSessionInfo(this.pubKey, byArray, (byte)pGPDataEncryptorBuilder.getAlgorithm(), false);
        byte[][] byArray6 = this.encodeEncryptedSessionInfo(byArray5);
        return PublicKeyEncSessionPacket.createV6PKESKPacket(n, byArray2, this.pubKey.getAlgorithm(), byArray6);
    }

    protected byte[] createSessionInfo(byte by, byte[] byArray) {
        byte[] byArray2;
        if (by != 0) {
            byArray2 = new byte[byArray.length + 3];
            byArray2[0] = by;
            System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
            this.addCheckSum(byArray2, 1);
        } else {
            byArray2 = new byte[byArray.length + 2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.addCheckSum(byArray2, 0);
        }
        return byArray2;
    }

    private void addCheckSum(byte[] byArray, int n) {
        int n2 = 0;
        for (int i = n; i != byArray.length - 2; ++i) {
            n2 += byArray[i] & 0xFF;
        }
        byArray[byArray.length - 2] = (byte)(n2 >> 8);
        byArray[byArray.length - 1] = (byte)n2;
    }

    protected abstract byte[] encryptSessionInfo(PGPPublicKey var1, byte[] var2, byte var3, boolean var4) throws PGPException;

    protected static byte[] getSessionInfo(byte[] byArray, byte by, byte[] byArray2) {
        int n = byArray.length + byArray2.length + (by == 0 ? 1 : 2);
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = (byte)(n - byArray.length - 1);
        if (by != 0) {
            byArray3[byArray.length + 1] = by;
        }
        System.arraycopy(byArray2, 0, byArray3, n - byArray2.length, byArray2.length);
        return byArray3;
    }
}

