/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.AbstractAllInDirectoryConfigurationProducer;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.PatternConfigurationProducer;
import com.intellij.execution.junit2.info.LocationUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAllInPackageConfigurationProducer
extends JUnitConfigurationProducer {
    private static final String mavenJunitPlatformEngine = "org.junit.platform:junit-platform-engine";
    private static final String mavenJunit = "junit:junit";
    private static final String mavenJunitJupiterApi = "org.junit.jupiter:junit-jupiter-api";

    protected AbstractAllInPackageConfigurationProducer() {
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return "package".equals(type);
    }

    public boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Location loc;
        if (configuration == null) {
            AbstractAllInPackageConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractAllInPackageConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (sourceElement == null) {
            AbstractAllInPackageConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((loc = context.getLocation()) == null) {
            return false;
        }
        PsiElement psiElement = loc.getPsiElement();
        PsiPackage psiPackage = AbstractAllInPackageConfigurationProducer.checkPackage((PsiElement)psiElement);
        if (psiPackage == null) {
            return false;
        }
        sourceElement.set((Object)psiPackage);
        JUnitConfiguration.Data data = configuration.getPersistentData();
        if (DumbService.isDumb((Project)psiElement.getProject())) {
            if (!AbstractAllInPackageConfigurationProducer.hasProjectLibraryAttached(psiPackage)) {
                return false;
            }
        } else {
            PsiDirectory psiDirectory;
            if (psiElement instanceof PsiDirectory && !AbstractAllInPackageConfigurationProducer.hasLibraryAttached((Location<PsiElement>)loc, psiDirectory = (PsiDirectory)psiElement)) {
                return false;
            }
            if (psiElement instanceof PsiPackage && !AbstractAllInPackageConfigurationProducer.hasLibraryAttached((Location<PsiElement>)loc, psiPackage)) {
                return false;
            }
        }
        data.PACKAGE_NAME = psiPackage.getQualifiedName();
        data.TEST_OBJECT = "package";
        data.setScope(this.setupPackageConfiguration(context, (ModuleBasedConfiguration)configuration, data.getScope()));
        configuration.setGeneratedName();
        return true;
    }

    private static boolean hasProjectLibraryAttached(PsiPackage psiPackage) {
        return JavaLibraryUtil.hasAnyLibraryJar((Project)psiPackage.getProject(), Set.of(mavenJunitPlatformEngine, mavenJunit, mavenJunitJupiterApi));
    }

    private static boolean hasLibraryAttached(Location<PsiElement> loc, PsiDirectory directory) {
        return LocationUtil.isJarAttached(loc, (PsiDirectory[])new PsiDirectory[]{directory}, (String[])new String[]{"junit.framework.TestCase", "org.junit.jupiter.api.Test", "org.junit.platform.engine.TestEngine"});
    }

    private static boolean hasLibraryAttached(Location<PsiElement> loc, PsiPackage pkg) {
        return LocationUtil.isJarAttached(loc, (PsiPackage)pkg, (String[])new String[]{"junit.framework.TestCase", "org.junit.jupiter.api.Test", "org.junit.platform.engine.TestEngine"});
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return !other.isProducedBy(AbstractAllInDirectoryConfigurationProducer.class) && !other.isProducedBy(PatternConfigurationProducer.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sourceElement";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/junit/AbstractAllInPackageConfigurationProducer";
        objectArray[2] = "setupConfigurationFromContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

