/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.js.rhino;

import com.google.gwt.dev.js.rhino.CodePosition;
import com.google.gwt.dev.js.rhino.Context;
import com.google.gwt.dev.js.rhino.Utils;
import java.io.IOException;
import java.io.Reader;

final class LineBuffer {
    private Reader in;
    private char[] otherBuffer = null;
    private char[] buffer = null;
    private int offset = 0;
    private int end = 0;
    private int otherEnd;
    private int lineno;
    private int columnno;
    private int prevColumnno = 0;
    private int lineStart = 0;
    private int otherStart = 0;
    private int prevStart = 0;
    private boolean lastWasCR = false;
    private boolean hitEOF = false;

    LineBuffer(Reader in, CodePosition position) {
        this.in = in;
        this.lineno = position.getLine();
        this.columnno = position.getOffset();
        this.lineStart = -position.getOffset();
    }

    int read() throws IOException {
        char c;
        do {
            if (this.end == this.offset && !this.fill()) {
                return -1;
            }
            c = this.buffer[this.offset];
            ++this.offset;
            ++this.columnno;
            this.prevColumnno = this.prevColumnno;
            if ((c & 0xDFD0) != 0) continue;
            switch (c) {
                case '\r': {
                    if (this.offset != this.end) {
                        if (this.buffer[this.offset] == '\n') {
                            ++this.offset;
                        }
                    } else {
                        this.lastWasCR = true;
                    }
                }
                case '\n': 
                case '\u2028': 
                case '\u2029': {
                    this.prevStart = this.lineStart;
                    this.lineStart = this.offset;
                    ++this.lineno;
                    this.prevColumnno = this.columnno;
                    this.columnno = 0;
                    return 10;
                }
            }
        } while (c >= '\u0080' && LineBuffer.formatChar(c));
        return c;
    }

    void unread() {
        if (this.offset == 0 && !this.hitEOF) {
            Context.codeBug();
        }
        if (this.offset == 0) {
            return;
        }
        --this.offset;
        --this.columnno;
        char c = this.buffer[this.offset];
        if ((c & 0xDFD0) == 0 && Utils.isEndOfLine(c)) {
            this.lineStart = this.prevStart;
            --this.lineno;
            this.columnno = this.prevColumnno;
        }
    }

    private void skipFormatChar() {
        if (!LineBuffer.formatChar(this.buffer[this.offset])) {
            Context.codeBug();
        }
        if (this.offset != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.buffer[this.offset - 1];
            this.buffer[this.offset - 1] = tmp;
        } else if (this.otherEnd != 0) {
            char tmp = this.buffer[this.offset];
            this.buffer[this.offset] = this.otherBuffer[this.otherEnd - 1];
            this.otherBuffer[this.otherEnd - 1] = tmp;
        }
        ++this.offset;
        this.prevColumnno = this.columnno++;
    }

    int peek() throws IOException {
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if ((c & 0xDFD0) == 0 && Utils.isEndOfLine(c)) {
                return 10;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return c;
            }
            this.skipFormatChar();
        }
        return -1;
    }

    boolean match(int test) throws IOException {
        if ((test & 0xDFD0) == 0 && Utils.isEndOfLine(test)) {
            Context.codeBug();
        }
        if (test >= 128 && LineBuffer.formatChar(test)) {
            Context.codeBug();
        }
        while (this.end != this.offset || this.fill()) {
            char c = this.buffer[this.offset];
            if (test == c) {
                ++this.offset;
                this.prevColumnno = this.columnno++;
                return true;
            }
            if (c < '\u0080' || !LineBuffer.formatChar(c)) {
                return false;
            }
            this.skipFormatChar();
        }
        return false;
    }

    int getOffset() {
        return this.offset - this.lineStart;
    }

    private boolean fill() throws IOException {
        if (this.end != this.offset) {
            Context.codeBug();
        }
        char[] tempBuffer = this.buffer;
        this.buffer = this.otherBuffer;
        this.otherBuffer = tempBuffer;
        if (this.buffer == null) {
            this.buffer = new char[256];
        }
        this.otherStart = this.lineStart >= 0 ? this.lineStart : 0;
        this.otherEnd = this.end;
        this.lineStart = this.otherBuffer == null ? 0 : this.lineStart - this.end;
        this.prevStart = this.lineStart;
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            this.hitEOF = true;
            return false;
        }
        if (this.lastWasCR) {
            if (this.buffer[0] == '\n') {
                ++this.offset;
                this.prevColumnno = this.columnno++;
                if (this.end == 1) {
                    return this.fill();
                }
            }
            this.lineStart = this.offset;
            this.lastWasCR = false;
        }
        return true;
    }

    int getLineno() {
        return this.lineno;
    }

    int getColumnno() {
        return this.columnno;
    }

    private static boolean formatChar(int c) {
        return Character.getType((char)c) == 16;
    }
}

