/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LightModifierList
extends LightElement
implements PsiModifierList {
    private final Set<String> myModifiers;

    public LightModifierList(@NotNull PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            LightModifierList.$$$reportNull$$$0(0);
        }
        this(modifierListOwner.getManager());
        this.copyModifiers(modifierListOwner.getModifierList());
    }

    public LightModifierList(PsiManager manager) {
        this(manager, JavaLanguage.INSTANCE, new String[0]);
    }

    public LightModifierList(PsiManager manager, Language language2, String ... modifiers) {
        super(manager, language2);
        this.myModifiers = ContainerUtil.newHashSet(modifiers);
    }

    public void addModifier(@NotNull String modifier) {
        if (modifier == null) {
            LightModifierList.$$$reportNull$$$0(1);
        }
        this.myModifiers.add(modifier);
    }

    public void copyModifiers(PsiModifierList modifierList2) {
        if (modifierList2 == null) {
            return;
        }
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!modifierList2.hasExplicitModifier(modifier)) continue;
            this.addModifier(modifier);
        }
    }

    public void clearModifiers() {
        this.myModifiers.clear();
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            LightModifierList.$$$reportNull$$$0(2);
        }
        return this.myModifiers.contains(name2);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull String name2) {
        if (name2 == null) {
            LightModifierList.$$$reportNull$$$0(3);
        }
        return this.myModifiers.contains(name2);
    }

    @Override
    public void setModifierProperty(@NotNull String name2, boolean value2) throws IncorrectOperationException {
        if (name2 == null) {
            LightModifierList.$$$reportNull$$$0(4);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void checkSetModifierProperty(@NotNull String name2, boolean value2) throws IncorrectOperationException {
        if (name2 == null) {
            LightModifierList.$$$reportNull$$$0(5);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public PsiAnnotation @NotNull [] getAnnotations() {
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            LightModifierList.$$$reportNull$$$0(6);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @Override
    public PsiAnnotation @NotNull [] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            LightModifierList.$$$reportNull$$$0(7);
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            LightModifierList.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            LightModifierList.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightModifierList.$$$reportNull$$$0(10);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitModifierList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiModifierList";
    }

    @Override
    public String getText() {
        StringBuilder buffer = new StringBuilder();
        for (String modifier : PsiModifier.MODIFIERS) {
            if (!this.hasExplicitModifier(modifier)) continue;
            buffer.append(modifier);
            buffer.append(' ');
        }
        if (buffer.length() > 0) {
            buffer.delete(buffer.length() - 1, buffer.length());
        }
        return buffer.toString();
    }

    public String @NotNull [] getModifiers() {
        String[] stringArray = ArrayUtilRt.toStringArray(this.myModifiers);
        if (stringArray == null) {
            LightModifierList.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightModifierList";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightModifierList";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addModifier";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setModifierProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkSetModifierProperty";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

