/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.java;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.java.FirJavaAwareSymbolProvider;
import org.jetbrains.kotlin.fir.java.FirJavaFacade;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolNamesProviderWithoutCallables;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001(B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J*\u0010\u0014\u001a\u00020\u00152\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u001d\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J&\u0010\u001f\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020 0\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Lorg/jetbrains/kotlin/fir/java/FirJavaAwareSymbolProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "javaFacade", "Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;)V", "getJavaFacade", "()Lorg/jetbrains/kotlin/fir/java/FirJavaFacade;", "classCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ClassCacheContext;", "getClassLikeSymbolByClassId", "classId", "javaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "hasPackage", "", "fqName", "symbolNamesProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "getSymbolNamesProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolNamesProvider;", "ClassCacheContext", "java"})
@SourceDebugExtension(value={"SMAP\nJavaSymbolProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaSymbolProvider.kt\norg/jetbrains/kotlin/fir/java/JavaSymbolProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
public class JavaSymbolProvider
extends FirSymbolProvider
implements FirJavaAwareSymbolProvider {
    @NotNull
    private final FirJavaFacade javaFacade;
    @NotNull
    private final FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> classCache;
    @NotNull
    private final FirSymbolNamesProvider symbolNamesProvider;

    public JavaSymbolProvider(@NotNull FirSession session2, @NotNull FirJavaFacade javaFacade) {
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(javaFacade, "javaFacade");
        super(session2);
        this.javaFacade = javaFacade;
        this.classCache = FirCachesFactoryKt.getFirCachesFactory(session2).createCache((arg_0, arg_1) -> JavaSymbolProvider.classCache$lambda$0(this, arg_0, arg_1));
        this.symbolNamesProvider = new FirSymbolNamesProviderWithoutCallables(this){
            final /* synthetic */ JavaSymbolProvider this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean getHasSpecificClassifierPackageNamesComputation() {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public Set<Name> getTopLevelClassifierNamesInPackage(FqName packageFqName) {
                Set set;
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Set<String> set2 = this.this$0.getJavaFacade().knownClassNamesInPackage(packageFqName);
                if (set2 != null) {
                    Collection $this$mapToSetOrEmpty$iv = set2;
                    boolean $i$f$mapToSetOrEmpty = false;
                    if (!$this$mapToSetOrEmpty$iv.isEmpty()) {
                        void destination$iv$iv;
                        void $this$mapTo$iv$iv;
                        Iterable iterable = $this$mapToSetOrEmpty$iv;
                        Collection collection = new LinkedHashSet<E>();
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            String string2 = (String)item$iv$iv;
                            void var11_11 = destination$iv$iv;
                            boolean bl = false;
                            var11_11.add(Name.identifier((String)it));
                        }
                        set = (Set)destination$iv$iv;
                    } else {
                        set = SetsKt.emptySet();
                    }
                } else {
                    set = null;
                }
                return set;
            }
        };
    }

    @Override
    @NotNull
    public FirJavaFacade getJavaFacade() {
        return this.javaFacade;
    }

    @Nullable
    public FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return this.getJavaFacade().hasTopLevelClassOf(classId) ? this.getClassLikeSymbolByClassId(classId, null) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FirRegularClassSymbol getClassLikeSymbolByClassId(@NotNull ClassId classId, @Nullable JavaClass javaClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> firCache = this.classCache;
        ClassId classId2 = classId;
        ClassId classId3 = classId.getOuterClassId();
        if (classId3 != null) {
            void it;
            ClassId classId4 = classId3;
            ClassId classId5 = classId2;
            FirCache<ClassId, FirRegularClassSymbol, ClassCacheContext> firCache2 = firCache;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol2 = this.getClassLikeSymbolByClassId((ClassId)it, null);
            firCache = firCache2;
            classId2 = classId5;
            firRegularClassSymbol = firRegularClassSymbol2;
        } else {
            firRegularClassSymbol = null;
        }
        JavaClass javaClass2 = javaClass;
        FirRegularClassSymbol firRegularClassSymbol3 = firRegularClassSymbol;
        return firCache.getValue(classId2, new ClassCacheContext(firRegularClassSymbol3, javaClass2));
    }

    @Override
    public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
    }

    @Override
    public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
    }

    @Override
    public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name2) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(name2, "name");
    }

    @Override
    public boolean hasPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        return this.getJavaFacade().hasPackage(fqName);
    }

    @Override
    @NotNull
    public FirSymbolNamesProvider getSymbolNamesProvider() {
        return this.symbolNamesProvider;
    }

    private static final FirRegularClassSymbol classCache$lambda$0(JavaSymbolProvider this$0, ClassId classId, ClassCacheContext context) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        Object object = context;
        if ((object == null || (object = ((ClassCacheContext)object).getFoundJavaClass()) == null) && (object = FirJavaFacade.findClass$default(this$0.getJavaFacade(), classId, null, 2, null)) == null) {
            return null;
        }
        Object javaClass = object;
        FirRegularClassSymbol symbol = new FirRegularClassSymbol(classId);
        ClassCacheContext classCacheContext = context;
        this$0.getJavaFacade().convertJavaClassToFir(symbol, classCacheContext != null ? classCacheContext.getParentClassSymbol() : null, (JavaClass)javaClass);
        return symbol;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/java/JavaSymbolProvider$ClassCacheContext;", "", "parentClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "foundJavaClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/load/java/structure/JavaClass;)V", "getParentClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getFoundJavaClass", "()Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "java"})
    private static final class ClassCacheContext {
        @Nullable
        private final FirRegularClassSymbol parentClassSymbol;
        @Nullable
        private final JavaClass foundJavaClass;

        public ClassCacheContext(@Nullable FirRegularClassSymbol parentClassSymbol, @Nullable JavaClass foundJavaClass) {
            this.parentClassSymbol = parentClassSymbol;
            this.foundJavaClass = foundJavaClass;
        }

        public /* synthetic */ ClassCacheContext(FirRegularClassSymbol firRegularClassSymbol, JavaClass javaClass, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                firRegularClassSymbol = null;
            }
            if ((n & 2) != 0) {
                javaClass = null;
            }
            this(firRegularClassSymbol, javaClass);
        }

        @Nullable
        public final FirRegularClassSymbol getParentClassSymbol() {
            return this.parentClassSymbol;
        }

        @Nullable
        public final JavaClass getFoundJavaClass() {
            return this.foundJavaClass;
        }

        public ClassCacheContext() {
            this(null, null, 3, null);
        }
    }
}

