/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH&J\b\u0010\n\u001a\u00020\u000bH&J\u0019\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH$J\r\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010!\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u0005J\u0006\u0010*\u001a\u00020+J\r\u0010,\u001a\u00020\u001d\u00a2\u0006\u0004\b-\u0010\u001fJ\u0019\u0010.\u001a\u00020\u001d2\b\b\u0002\u0010/\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b0\u00101J\u0012\u00102\u001a\u00020(2\b\b\u0002\u0010/\u001a\u00020\tH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/ByteReader;", "", "<init>", "()V", "isEof", "", "()Z", "read", "amount", "", "readByte", "", "readBytes", "", "(Ljava/lang/Integer;)[B", "readToArray", "", "array", "readUByte", "Lkotlin/UByte;", "readUByte-w2LRezQ", "()B", "bytes2", "readUInt16", "Lkotlin/UShort;", "readUInt16-Mh2AYeg", "()S", "bytes4", "readUInt32", "Lkotlin/UInt;", "readUInt32-pVg5ArA", "()I", "bytes8", "readUInt64", "Lkotlin/ULong;", "readUInt64-s-VKNKU", "()J", "readVarInt7", "readVarInt32", "readVarInt64", "", "readVarUInt1", "readVarUInt7", "", "readVarUInt32", "readVarUInt32-pVg5ArA", "readUnsignedLeb128", "maxCount", "readUnsignedLeb128-OGnWXxg", "(I)I", "readSignedLeb128", "wasm.ir"})
public abstract class ByteReader {
    @NotNull
    private final byte[] bytes2 = new byte[2];
    @NotNull
    private final byte[] bytes4 = new byte[4];
    @NotNull
    private final byte[] bytes8 = new byte[8];

    public abstract boolean isEof();

    @NotNull
    public abstract ByteReader read(int var1);

    public abstract byte readByte();

    @NotNull
    public abstract byte[] readBytes(@Nullable Integer var1);

    public static /* synthetic */ byte[] readBytes$default(ByteReader byteReader, Integer n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readBytes");
        }
        if ((n2 & 1) != 0) {
            n = null;
        }
        return byteReader.readBytes(n);
    }

    protected abstract void readToArray(@NotNull byte[] var1);

    public final byte readUByte-w2LRezQ() {
        return UByte.constructor-impl(this.readByte());
    }

    public final short readUInt16-Mh2AYeg() {
        this.readToArray(this.bytes2);
        return UShort.constructor-impl((short)UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes2[0]) & 0xFF) | UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes2[1]) & 0xFF) << 8)));
    }

    public final int readUInt32-pVg5ArA() {
        this.readToArray(this.bytes4);
        return UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes4[0]) & 0xFF) | UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes4[1]) & 0xFF) << 8)) | UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes4[2]) & 0xFF) << 16)) | UInt.constructor-impl(UInt.constructor-impl(UByte.constructor-impl(this.bytes4[3]) & 0xFF) << 24));
    }

    public final long readUInt64-s-VKNKU() {
        this.readToArray(this.bytes8);
        return ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[0]) & 0xFFL) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[1]) & 0xFFL) << 8)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[2]) & 0xFFL) << 16)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[3]) & 0xFFL) << 24)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[4]) & 0xFFL) << 32)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[5]) & 0xFFL) << 40)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[6]) & 0xFFL) << 48)) | ULong.constructor-impl(ULong.constructor-impl((long)UByte.constructor-impl(this.bytes8[7]) & 0xFFL) << 56));
    }

    public final byte readVarInt7() {
        long it = ByteReader.readSignedLeb128$default(this, 0, 1, null);
        boolean bl = false;
        if (it < -128L || it > 127L) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        return (byte)it;
    }

    public final int readVarInt32() {
        long it = ByteReader.readSignedLeb128$default(this, 0, 1, null);
        boolean bl = false;
        if (it < Integer.MIN_VALUE || it > Integer.MAX_VALUE) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        return (int)it;
    }

    public final long readVarInt64() {
        return this.readSignedLeb128(9);
    }

    public final boolean readVarUInt1() {
        int it = ByteReader.readUnsignedLeb128-OGnWXxg$default(this, 0, 1, null);
        boolean bl = false;
        if (it != 1 && it != 0) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        return it == 1;
    }

    public final short readVarUInt7() {
        int it = ByteReader.readUnsignedLeb128-OGnWXxg$default(this, 0, 1, null);
        boolean bl = false;
        if (Integer.compareUnsigned(it, 255) > 0) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        return (short)it;
    }

    public final int readVarUInt32-pVg5ArA() {
        return ByteReader.readUnsignedLeb128-OGnWXxg$default(this, 0, 1, null);
    }

    protected final int readUnsignedLeb128-OGnWXxg(int maxCount) {
        int result2 = 0;
        int cur = 0;
        int count = 0;
        do {
            cur = UInt.constructor-impl(UInt.constructor-impl(this.readUByte-w2LRezQ() & 0xFF) & 0xFF);
            result2 = UInt.constructor-impl(result2 | UInt.constructor-impl(UInt.constructor-impl(cur & 0x7F) << count * 7));
        } while (UInt.constructor-impl(cur & 0x80) == 128 && ++count <= maxCount);
        if (UInt.constructor-impl(cur & 0x80) == 128) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        return result2;
    }

    public static /* synthetic */ int readUnsignedLeb128-OGnWXxg$default(ByteReader byteReader, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readUnsignedLeb128-OGnWXxg");
        }
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return byteReader.readUnsignedLeb128-OGnWXxg(n);
    }

    private final long readSignedLeb128(int maxCount) {
        long result2 = 0L;
        int cur = 0;
        int count = 0;
        long signBits = -1L;
        do {
            cur = this.readByte() & 0xFF;
            result2 |= (long)(cur & 0x7F) << count * 7;
            signBits <<= 7;
        } while ((cur & 0x80) == 128 && ++count <= maxCount);
        if ((cur & 0x80) == 128) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        if (count > maxCount && maxCount == 9 && ((cur & 0x40) == 64 ? (byte)(cur | 0x80) != -1 : cur != 0)) {
            throw new IllegalStateException("InvalidLeb128Number".toString());
        }
        if ((signBits >> 1 & result2) != 0L) {
            result2 |= signBits;
        }
        return result2;
    }

    static /* synthetic */ long readSignedLeb128$default(ByteReader byteReader, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readSignedLeb128");
        }
        if ((n2 & 1) != 0) {
            n = 4;
        }
        return byteReader.readSignedLeb128(n);
    }
}

