/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.xml;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.util.Preconditions;
import org.w3c.dom.Document;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class XmlStringPrettyFormatter {
    private static final String FORMAT_ERROR = "Unable to format XML string";

    public static String xmlPrettyFormat(String xmlStringToFormat) {
        Preconditions.checkArgument(xmlStringToFormat != null, "Expecting XML String not to be null", new Object[0]);
        return XmlStringPrettyFormatter.prettyFormat(XmlStringPrettyFormatter.toXmlDocument(xmlStringToFormat), xmlStringToFormat.startsWith("<?xml"));
    }

    private static String prettyFormat(Document document, boolean keepXmlDeclaration) {
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            StringWriter stringWriter = new StringWriter();
            LSOutput formattedOutput = domImplementation.createLSOutput();
            formattedOutput.setCharacterStream(stringWriter);
            LSSerializer domSerializer = domImplementation.createLSSerializer();
            domSerializer.getDomConfig().setParameter("format-pretty-print", true);
            domSerializer.getDomConfig().setParameter("xml-declaration", keepXmlDeclaration);
            domSerializer.write(document, formattedOutput);
            return ((Object)stringWriter).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(FORMAT_ERROR, e);
        }
    }

    private static Document toXmlDocument(String xmlString) {
        try {
            InputSource xmlInputSource = new InputSource(new StringReader(xmlString));
            DocumentBuilder xmlDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            return xmlDocumentBuilder.parse(xmlInputSource);
        }
        catch (Exception e) {
            throw new RuntimeException(FORMAT_ERROR, e);
        }
    }

    private XmlStringPrettyFormatter() {
    }
}

