/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.BytecodeLineMappingKt;
import com.intellij.byteCodeViewer.BytecodeViewerBundle;
import com.intellij.byteCodeViewer.BytecodeViewerSettings;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import java.awt.BorderLayout;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\n\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiClass;Lcom/intellij/openapi/vfs/VirtualFile;)V", "bytecodeEditor", "Lcom/intellij/openapi/editor/Editor;", "setEditorText", "", "selectedMatchingEditor", "updateBytecodeSelection", "sourceEditor", "deserializeBytecode", "", "dispose", "Companion", "intellij.java.byteCodeViewer"})
public final class BytecodeToolWindowPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiClass psiClass;
    @NotNull
    private final VirtualFile classFile;
    @NotNull
    private final Editor bytecodeEditor;
    @NotNull
    public static final String TOOL_WINDOW_ID = "Bytecode";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<String> BYTECODE_WITH_DEBUG_INFO;

    public BytecodeToolWindowPanel(@NotNull Project project, @NotNull PsiClass psiClass, @NotNull VirtualFile classFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super(new BorderLayout());
        this.project = project;
        this.psiClass = psiClass;
        this.classFile = classFile;
        Editor editor = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, (FileType)JavaClassFileType.INSTANCE, true);
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"createEditor(...)");
        this.bytecodeEditor = editor;
        this.add(this.bytecodeEditor.getComponent());
        this.setBorder(null);
        this.setEditorText();
        EditorFactory.getInstance().getEventMulticaster().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor sourceEditor = this.selectedMatchingEditor();
                if (!Intrinsics.areEqual((Object)e.getEditor(), (Object)sourceEditor)) {
                    return;
                }
                this.updateBytecodeSelection(sourceEditor);
            }
        }, (Disposable)this);
    }

    public final void setEditorText() {
        String byteCodeText = this.deserializeBytecode();
        this.bytecodeEditor.getDocument().putUserData(BYTECODE_WITH_DEBUG_INFO, (Object)byteCodeText);
        ActionsKt.runWriteAction(() -> BytecodeToolWindowPanel.setEditorText$lambda$0(byteCodeText, this));
        Editor editor = this.selectedMatchingEditor();
        if (editor == null) {
            return;
        }
        Editor sourceEditor = editor;
        this.updateBytecodeSelection(sourceEditor);
    }

    private final Editor selectedMatchingEditor() {
        Object object;
        Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor != null) {
            Editor editor2;
            Editor it = editor2 = editor;
            boolean bl = false;
            object = Intrinsics.areEqual((Object)it.getVirtualFile(), (Object)this.psiClass.getContainingFile().getVirtualFile()) ? editor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void updateBytecodeSelection(Editor sourceEditor) {
        if (sourceEditor.getCaretModel().getCaretCount() != 1) {
            return;
        }
        int sourceStartOffset = sourceEditor.getCaretModel().getCurrentCaret().getSelectionStart();
        int sourceEndOffset = sourceEditor.getCaretModel().getCurrentCaret().getSelectionEnd();
        Document document = sourceEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document sourceDocument = document;
        int sourceStartLine = sourceDocument.getLineNumber(sourceStartOffset);
        int sourceEndLine = sourceDocument.getLineNumber(sourceEndOffset);
        if (sourceEndLine > sourceStartLine && sourceEndOffset > 0 && sourceDocument.getCharsSequence().charAt(sourceEndOffset - 1) == '\n') {
            --sourceEndLine;
        }
        Document document2 = this.bytecodeEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document bytecodeDocument = document2;
        String bytecodeWithDebugInfo = (String)bytecodeDocument.getUserData(BYTECODE_WITH_DEBUG_INFO);
        if (bytecodeWithDebugInfo == null) {
            LOG.warn("Bytecode with debug information is null. Ensure the bytecode has been generated correctly.");
            return;
        }
        IntRange linesRange = BytecodeLineMappingKt.mapLines(bytecodeWithDebugInfo, sourceStartLine, sourceEndLine, true);
        if (Intrinsics.areEqual((Object)linesRange, (Object)new IntRange(0, 0)) || linesRange.getFirst() < 0 || linesRange.getLast() < 0) {
            this.bytecodeEditor.getSelectionModel().removeSelection();
            return;
        }
        int endSelectionLineIndex = Math.min(linesRange.getLast() + 1, bytecodeDocument.getLineCount());
        int startOffset = bytecodeDocument.getLineStartOffset(linesRange.getFirst());
        int endOffset = Math.min(bytecodeDocument.getLineEndOffset(endSelectionLineIndex), bytecodeDocument.getTextLength());
        if (bytecodeDocument.getTextLength() <= startOffset || bytecodeDocument.getTextLength() <= endOffset) {
            return;
        }
        this.bytecodeEditor.getCaretModel().moveToOffset(endOffset);
        this.bytecodeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.bytecodeEditor.getCaretModel().moveToOffset(startOffset);
        this.bytecodeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.bytecodeEditor.getSelectionModel().setSelection(startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String deserializeBytecode() {
        try {
            byte[] byArray = this.classFile.contentsToByteArray(false);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
            byte[] bytes = byArray;
            StringWriter stringWriter = new StringWriter();
            Closeable closeable = new PrintWriter(stringWriter);
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                boolean bl = false;
                new ClassReader(bytes).accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), printWriter), 4);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            String string = stringWriter.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return BytecodeViewerBundle.message("deserialization.error", new Object[0]);
        }
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.bytecodeEditor);
    }

    private static final Unit setEditorText$lambda$0(String $byteCodeText, BytecodeToolWindowPanel this$0) {
        String byteCodeToShow = BytecodeViewerSettings.Companion.getInstance().getState().getShowDebugInfo() ? $byteCodeText : BytecodeLineMappingKt.removeDebugInfo($byteCodeText);
        this$0.bytecodeEditor.getDocument().setText((CharSequence)byteCodeToShow);
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(BytecodeToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"BYTECODE_WITH_DEBUG_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BYTECODE_WITH_DEBUG_INFO = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u00050\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowPanel$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BYTECODE_WITH_DEBUG_INFO", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "intellij.java.byteCodeViewer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

