/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.IoService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NetUtils {
    private static final Logger LOG = Logger.getInstance(NetUtils.class);

    private NetUtils() {
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static boolean canConnectToSocket(String host, int port) {
        if (NetUtils.isLocalhost(host)) {
            return !NetUtils.canBindToLocalSocket(host, port);
        }
        return NetUtils.canConnectToRemoteSocket(host, port);
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static boolean isLocalhost(@NotNull @NlsSafe String hostName) {
        if (hostName == null) {
            NetUtils.$$$reportNull$$$0(0);
        }
        return hostName.equalsIgnoreCase("localhost") || hostName.equals("127.0.0.1") || hostName.equals("::1");
    }

    private static boolean canBindToLocalSocket(String host, int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket();
        try {
            socket.bind(new InetSocketAddress(host, port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
                return false;
            }
        }
        socket.close();
        return bl;
    }

    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static boolean canConnectToRemoteSocket(String host, int port) {
        try {
            Socket socket = new Socket(host, port);
            socket.close();
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findAvailableSocketPort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int port = serverSocket.getLocalPort();
            ServerSocket serverSocket2 = serverSocket;
            synchronized (serverSocket2) {
                try {
                    serverSocket.wait(1L);
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
            }
            int n = port;
            return n;
        }
    }

    public static int tryToFindAvailableSocketPort(int defaultPort) {
        try {
            return NetUtils.findAvailableSocketPort();
        }
        catch (IOException ignored) {
            return defaultPort;
        }
    }

    public static int tryToFindAvailableSocketPort() {
        return NetUtils.tryToFindAvailableSocketPort(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] findAvailableSocketPorts(int capacity) throws IOException {
        int[] ports = new int[capacity];
        ServerSocket[] sockets = new ServerSocket[capacity];
        for (int i = 0; i < capacity; ++i) {
            ServerSocket serverSocket;
            sockets[i] = serverSocket = new ServerSocket(0);
            ports[i] = serverSocket.getLocalPort();
        }
        ServerSocket[] serverSocketArray = sockets;
        synchronized (sockets) {
            try {
                sockets.wait(1L);
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            for (ServerSocket socket : sockets) {
                socket.close();
            }
            return ports;
        }
    }

    public static String getLocalHostString() {
        @NlsSafe String localHostString = "localhost";
        try {
            InetAddress localHost = InetAddress.getByName(localHostString);
            if (localHost.getAddress().length != 4 && SystemInfo.isWindows || localHost.getAddress().length == 4 && SystemInfo.isMac) {
                localHostString = "127.0.0.1";
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localHostString;
    }

    private static void updateIndicator(ProgressIndicator indicator, long downloadSpeed, long bytesDownloaded, long contentLength, boolean progressDescription) {
        double fraction = (double)bytesDownloaded / (double)contentLength;
        if (progressDescription) {
            int rankForContentLength = StringUtilRt.rankForFileSize((long)contentLength);
            String formattedDownloadSpeed = StringUtilRt.formatFileSize((long)downloadSpeed) + "\u29f8s";
            String formattedContentLength = StringUtilRt.formatFileSize((long)contentLength, (String)" ", (int)rankForContentLength);
            String formattedTotalProgress = StringUtilRt.formatFileSize((long)bytesDownloaded, (String)" ", (int)rankForContentLength);
            @NlsSafe String indicatorText = String.format("<html><code>%.0f%% \u00b7 %s\u29f8%s \u00b7 %s</code></html>", fraction * 100.0, formattedTotalProgress, formattedContentLength, formattedDownloadSpeed);
            indicator.setText2(indicatorText);
        }
        indicator.setFraction(fraction);
    }

    @Deprecated
    public static int copyStreamContent(@Nullable ProgressIndicator indicator, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, int expectedContentLength) throws IOException, ProcessCanceledException {
        if (inputStream == null) {
            NetUtils.$$$reportNull$$$0(1);
        }
        if (outputStream == null) {
            NetUtils.$$$reportNull$$$0(2);
        }
        return (int)NetUtils.copyStreamContent(indicator, inputStream, outputStream, (long)expectedContentLength);
    }

    public static long copyStreamContent(@Nullable ProgressIndicator indicator, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, long expectedContentLength) throws IOException, ProcessCanceledException {
        if (inputStream == null) {
            NetUtils.$$$reportNull$$$0(3);
        }
        if (outputStream == null) {
            NetUtils.$$$reportNull$$$0(4);
        }
        return NetUtils.copyStreamContent(indicator, inputStream, outputStream, expectedContentLength, false);
    }

    /*
     * WARNING - void declaration
     */
    public static long copyStreamContent(@Nullable ProgressIndicator indicator, @NotNull InputStream inputStream, @NotNull OutputStream outputStream, long expectedContentLength, boolean bl) throws IOException, ProcessCanceledException {
        void progressDescription;
        long downloadSpeed;
        long currentTime;
        int count;
        if (inputStream == null) {
            NetUtils.$$$reportNull$$$0(5);
        }
        if (outputStream == null) {
            NetUtils.$$$reportNull$$$0(6);
        }
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setIndeterminate(expectedContentLength <= 0L);
        }
        CountingGZIPInputStream gzipStream = inputStream instanceof CountingGZIPInputStream ? (CountingGZIPInputStream)inputStream : null;
        byte[] buffer = new byte[8192];
        long bytesWritten = 0L;
        long bytesRead = 0L;
        long startTime = System.currentTimeMillis();
        while ((count = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
            long l = bytesRead = gzipStream != null ? gzipStream.getCompressedBytesRead() : (bytesWritten += (long)count);
            if (indicator == null) continue;
            indicator.checkCanceled();
            if (expectedContentLength <= 0L || (currentTime = System.currentTimeMillis()) <= startTime) continue;
            downloadSpeed = bytesRead * 1000L / (currentTime - startTime);
            NetUtils.updateIndicator(indicator, downloadSpeed, bytesRead, expectedContentLength, (boolean)progressDescription);
        }
        if (gzipStream != null) {
            bytesRead = gzipStream.getCompressedBytesRead();
            if (indicator != null && expectedContentLength > 0L && (currentTime = System.currentTimeMillis()) > startTime) {
                downloadSpeed = bytesRead * 1000L / (currentTime - startTime);
                NetUtils.updateIndicator(indicator, downloadSpeed, bytesRead, expectedContentLength, (boolean)progressDescription);
            }
        }
        if (indicator != null) {
            indicator.checkCanceled();
        }
        if (bytesRead < expectedContentLength) {
            throw new IOException("Connection closed at byte " + bytesRead + ". Expected " + expectedContentLength + " bytes.");
        }
        return bytesWritten;
    }

    @ApiStatus.Internal
    public static boolean isSniEnabled() {
        return SystemProperties.getBooleanProperty((String)"jsse.enableSNIExtension", (boolean)true);
    }

    @ApiStatus.Internal
    public static ProxySelector getProxySelector(@Nullable String pacUrlForUse) {
        return IoService.getInstance().getProxySelector(pacUrlForUse);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    @NotNull
    public static ValidHostInfo isValidHost(@NotNull String host) {
        ValidHostInfo validHostInfo;
        HostAndPort parsedHost;
        block11: {
            if (host == null) {
                NetUtils.$$$reportNull$$$0(7);
            }
            parsedHost = HostAndPort.fromString((String)host);
            if (!parsedHost.hasPort()) break block11;
            ValidHostInfo validHostInfo2 = ValidHostInfo.INVALID;
            {
                catch (IllegalArgumentException e) {
                    ValidHostInfo validHostInfo3 = ValidHostInfo.INVALID;
                    if (validHostInfo3 == null) {
                        NetUtils.$$$reportNull$$$0(10);
                    }
                    return validHostInfo3;
                }
            }
            if (validHostInfo2 == null) {
                NetUtils.$$$reportNull$$$0(8);
            }
            return validHostInfo2;
        }
        host = parsedHost.getHost();
        try {
            InetAddresses.forString((String)host);
            validHostInfo = ValidHostInfo.VALID;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            InternetDomainName.from((String)host);
        }
        if (validHostInfo == null) {
            NetUtils.$$$reportNull$$$0(9);
        }
        return validHostInfo;
        ValidHostInfo validHostInfo4 = ValidHostInfo.VALID_PROXY;
        if (validHostInfo4 == null) {
            NetUtils.$$$reportNull$$$0(11);
        }
        return validHostInfo4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostName";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/NetUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/NetUtils";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isValidHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLocalhost";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyStreamContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValidHost";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static enum ValidHostInfo {
        INVALID,
        VALID,
        VALID_PROXY;

    }
}

