/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.output.ThresholdingOutputStream;
import org.codehaus.plexus.archiver.zip.ByteArrayOutputStream;

class OffloadingOutputStream
extends ThresholdingOutputStream {
    private ByteArrayOutputStream memoryOutputStream;
    private OutputStream currentOutputStream;
    private Path outputPath = null;
    private final String prefix;
    private final String suffix;

    public OffloadingOutputStream(int threshold, String prefix, String suffix) {
        super(threshold);
        if (prefix == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
        this.memoryOutputStream = new ByteArrayOutputStream(threshold / 10);
        this.currentOutputStream = this.memoryOutputStream;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    protected OutputStream getStream() throws IOException {
        return this.currentOutputStream;
    }

    protected void thresholdReached() throws IOException {
        this.outputPath = Files.createTempFile(this.prefix, this.suffix, new FileAttribute[0]);
        this.currentOutputStream = Files.newOutputStream(this.outputPath, new OpenOption[0]);
    }

    public InputStream getInputStream() throws IOException {
        InputStream memoryAsInput = this.memoryOutputStream.toInputStream();
        if (this.outputPath == null) {
            return memoryAsInput;
        }
        return new SequenceInputStream(memoryAsInput, Files.newInputStream(this.outputPath, new OpenOption[0]));
    }

    public byte[] getData() {
        if (this.memoryOutputStream != null) {
            return this.memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File getFile() {
        return this.outputPath != null ? this.outputPath.toFile() : null;
    }

    public void close() throws IOException {
        super.close();
        this.currentOutputStream.close();
    }
}

