/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.util.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReturnsCheck
implements Check {
    @NotNull
    private final String name;
    @NotNull
    private final Function1<KotlinBuiltIns, KotlinType> type;
    @NotNull
    private final String description;

    private ReturnsCheck(String name2, Function1<? super KotlinBuiltIns, ? extends KotlinType> type2) {
        this.name = name2;
        this.type = type2;
        this.description = Intrinsics.stringPlus((String)"must return ", (Object)this.name);
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean check(@NotNull FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        return Intrinsics.areEqual((Object)functionDescriptor.getReturnType(), (Object)this.type.invoke((Object)DescriptorUtilsKt.getBuiltIns(functionDescriptor)));
    }

    @Override
    @Nullable
    public String invoke(@NotNull FunctionDescriptor functionDescriptor) {
        return Check.DefaultImpls.invoke(this, functionDescriptor);
    }

    public /* synthetic */ ReturnsCheck(String name2, Function1 type2, DefaultConstructorMarker $constructor_marker) {
        this(name2, (Function1<? super KotlinBuiltIns, ? extends KotlinType>)type2);
    }

    public static final class ReturnsBoolean
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsBoolean INSTANCE = new ReturnsBoolean();

        private ReturnsBoolean() {
            super("Boolean", 1.INSTANCE, null);
        }
    }

    public static final class ReturnsInt
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsInt INSTANCE = new ReturnsInt();

        private ReturnsInt() {
            super("Int", 1.INSTANCE, null);
        }
    }

    public static final class ReturnsUnit
    extends ReturnsCheck {
        @NotNull
        public static final ReturnsUnit INSTANCE = new ReturnsUnit();

        private ReturnsUnit() {
            super("Unit", 1.INSTANCE, null);
        }
    }
}

