/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIterator;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectIntHashMap;
import java.util.ConcurrentModificationException;

public final class TObjectIntIterator<K>
extends TIterator {
    private final TObjectIntHashMap<K> _map;

    public TObjectIntIterator(TObjectIntHashMap<K> map) {
        super(map);
        this._map = map;
    }

    @Override
    protected int nextIndex() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        Object[] set = this._map._set;
        int i = this._index;
        while (i-- > 0 && (set[i] == null || set[i] == TObjectHash.REMOVED)) {
        }
        return i;
    }

    public void advance() {
        this.moveToNextIndex();
    }

    public K key() {
        return (K)this._map._set[this._index];
    }

    public int value() {
        return this._map._values[this._index];
    }

    public int setValue(int val) {
        int old = this.value();
        this._map._values[this._index] = val;
        return old;
    }
}

