/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dcl.lang.ide;

import com.android.tools.idea.gradle.dcl.lang.flags.DeclarativeIdeSupport;
import com.android.tools.idea.gradle.dcl.lang.ide.BuildDeclarativeSchemas;
import com.android.tools.idea.gradle.dcl.lang.sync.GradleSchemaProjectResolver;
import com.android.tools.idea.gradle.dcl.lang.sync.ProjectSchemas;
import com.android.tools.idea.gradle.dcl.lang.sync.SettingsSchemas;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u0004\u0018\u00010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDeclarativeSchema", "Lcom/android/tools/idea/gradle/dcl/lang/ide/BuildDeclarativeSchemas;", "Companion", "intellij.android.gradle.declarative.lang.ide"})
public final class DeclarativeService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public DeclarativeService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final BuildDeclarativeSchemas getDeclarativeSchema() {
        if (!DeclarativeIdeSupport.isEnabled()) {
            return null;
        }
        String string = this.project.getBasePath();
        if (string == null) {
            return null;
        }
        String externalProjectPath = string;
        ExternalProjectInfo projectInfo = ProjectDataManager.getInstance().getExternalProjectData(this.project, GradleConstants.SYSTEM_ID, externalProjectPath);
        ExternalProjectInfo externalProjectInfo = projectInfo;
        if (externalProjectInfo == null || (externalProjectInfo = externalProjectInfo.getExternalProjectStructure()) == null) {
            return null;
        }
        ExternalProjectInfo projectStructure = externalProjectInfo;
        DataNode projectSchemas = ExternalSystemApiUtil.find((DataNode)projectStructure, GradleSchemaProjectResolver.Companion.getDECLARATIVE_PROJECT_SCHEMAS());
        DataNode settingsSchemas = ExternalSystemApiUtil.find((DataNode)projectStructure, GradleSchemaProjectResolver.Companion.getDECLARATIVE_SETTINGS_SCHEMAS());
        return projectSchemas != null && settingsSchemas != null ? new BuildDeclarativeSchemas(((SettingsSchemas)settingsSchemas.getData()).getSettings(), ((ProjectSchemas)projectSchemas.getData()).getProjects()) : null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.gradle.declarative.lang.ide"})
    @SourceDebugExtension(value={"SMAP\nDeclarativeSchemaProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarativeSchemaProvider.kt\ncom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,94:1\n30#2,2:95\n*S KotlinDebug\n*F\n+ 1 DeclarativeSchemaProvider.kt\ncom/android/tools/idea/gradle/dcl/lang/ide/DeclarativeService$Companion\n*L\n39#1:95,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DeclarativeService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DeclarativeService> serviceClass$iv = DeclarativeService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DeclarativeService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

