/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockEditorFactory;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockFileTypeManager;
import com.intellij.mock.MockLanguageFileType;
import com.intellij.mock.MockProjectEx;
import com.intellij.mock.MockPsiDocumentManager;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.syntax.psi.CommonElementTypeConverterFactory;
import com.intellij.platform.syntax.psi.ElementTypeConverters;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.BlockSupportImpl;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.DiffLog;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.PsiFileFactoryImpl;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.ExtensionTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.MockSchemeManagerFactory;
import com.intellij.testFramework.ParsingTestUtil;
import com.intellij.testFramework.TestDataFile;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.pico.DefaultPicoContainer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import junit.framework.TestCase;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.picocontainer.ComponentAdapter;

public abstract class ParsingTestCase
extends UsefulTestCase {
    private PluginDescriptor pluginDescriptor;
    private MockApplication app;
    protected MockProjectEx project;
    protected String myFilePrefix;
    protected String myFileExt;
    protected final String myFullDataPath;
    protected PsiFile myFile;
    private MockPsiManager myPsiManager;
    private PsiFileFactoryImpl myFileFactory;
    protected Language myLanguage;
    private final ParserDefinition[] myDefinitions;
    private final boolean myLowercaseFirstLetter;
    private ExtensionPointImpl<KeyedLazyInstance<ParserDefinition>> myLangParserDefinition;

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(0);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(1);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(2);
        }
        this(dataPath, fileExt, false, definitions);
    }

    protected ParsingTestCase(@NotNull String dataPath, @NotNull String fileExt, boolean lowercaseFirstLetter, ParserDefinition ... definitions) {
        if (dataPath == null) {
            ParsingTestCase.$$$reportNull$$$0(3);
        }
        if (fileExt == null) {
            ParsingTestCase.$$$reportNull$$$0(4);
        }
        if (definitions == null) {
            ParsingTestCase.$$$reportNull$$$0(5);
        }
        this.myFilePrefix = "";
        this.myDefinitions = definitions;
        this.myFullDataPath = this.getTestDataPath() + "/" + dataPath;
        this.myFileExt = fileExt;
        this.myLowercaseFirstLetter = lowercaseFirstLetter;
    }

    @NotNull
    protected MockApplication getApplication() {
        MockApplication mockApplication = this.app;
        if (mockApplication == null) {
            ParsingTestCase.$$$reportNull$$$0(6);
        }
        return mockApplication;
    }

    @Override
    protected void setUp() throws Exception {
        MockApplication app;
        super.setUp();
        LightPlatformTestCase.closeAndDeleteProject();
        this.app = app = MockApplication.setUp((Disposable)this.getTestRootDisposable());
        DefaultPicoContainer appContainer = app.getPicoContainer();
        ComponentAdapter component = appContainer.getComponentAdapter((Object)ProgressManager.class.getName());
        if (component == null) {
            appContainer.registerComponentInstance((Object)ProgressManager.class.getName(), (Object)new ProgressManagerImpl());
        }
        IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
        this.project = new MockProjectEx(this.getTestRootDisposable());
        this.myPsiManager = new MockPsiManager((Project)this.project);
        this.myFileFactory = new PsiFileFactoryImpl((PsiManager)this.myPsiManager);
        appContainer.registerComponentInstance(MessageBus.class, (Object)app.getMessageBus());
        appContainer.registerComponentInstance(SchemeManagerFactory.class, (Object)new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        appContainer.registerComponentInstance(EditorFactory.class, (Object)editorFactory);
        app.registerService(FileDocumentManager.class, (Object)new MockFileDocumentManagerImpl(FileDocumentManagerBase.HARD_REF_TO_DOCUMENT_KEY, editorFactory::createDocument));
        app.registerService(PluginUtil.class, (Object)new PluginUtilImpl());
        app.registerService(PsiBuilderFactory.class, (Object)new PsiBuilderFactoryImpl());
        app.registerService(DefaultASTFactory.class, (Object)new DefaultASTFactoryImpl());
        app.registerService(ReferenceProvidersRegistry.class, (Object)new ReferenceProvidersRegistryImpl());
        this.project.registerService(PsiDocumentManager.class, (Object)new MockPsiDocumentManager());
        this.project.registerService(PsiManager.class, this.myPsiManager);
        this.project.registerService(TreeAspect.class, new TreeAspect());
        this.project.registerService(CachedValuesManager.class, new CachedValuesManagerImpl((Project)this.project, (CachedValuesFactory)new PsiCachedValuesFactory((Project)this.project)));
        this.project.registerService(StartupManager.class, new StartupManagerImpl((Project)this.project, this.project.getCoroutineScope()));
        this.registerExtensionPoint(app.getExtensionArea(), (BaseExtensionPointName)FileTypeFactory.FILE_TYPE_FACTORY_EP, (Class)FileTypeFactory.class);
        this.registerExtensionPoint(app.getExtensionArea(), (BaseExtensionPointName)MetaLanguage.EP_NAME, (Class)MetaLanguage.class);
        this.addExplicitExtensionForAnyLanguage(ElementTypeConverters.getInstance(), new CommonElementTypeConverterFactory());
        this.myLangParserDefinition = app.getExtensionArea().registerFakeBeanPoint(LanguageParserDefinitions.INSTANCE.getName(), this.getPluginDescriptor());
        if (this.myDefinitions.length > 0) {
            this.configureFromParserDefinition(this.myDefinitions[0], this.myFileExt);
            int length = this.myDefinitions.length;
            for (int i2 = 1; i2 < length; ++i2) {
                this.registerParserDefinition(this.myDefinitions[i2]);
            }
        }
        this.project.registerService(PomModel.class, new PomModelImpl((Project)this.project));
        Registry.Companion.markAsLoaded();
        LoadingState.setCurrentState((LoadingState)LoadingState.PROJECT_OPENED);
    }

    protected final void registerParserDefinition(final @NotNull ParserDefinition definition) {
        if (definition == null) {
            ParsingTestCase.$$$reportNull$$$0(7);
        }
        final Language language = definition.getFileNodeType().getLanguage();
        this.myLangParserDefinition.registerExtension((Object)new KeyedLazyInstance<ParserDefinition>(){

            @NotNull
            public String getKey() {
                String string = language.getID();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public ParserDefinition getInstance() {
                ParserDefinition parserDefinition = definition;
                if (parserDefinition == null) {
                    1.$$$reportNull$$$0(1);
                }
                return parserDefinition;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/testFramework/ParsingTestCase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKey";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInstance";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        });
        this.clearCachesOfLanguageExtension(language, (LanguageExtension<?>)LanguageParserDefinitions.INSTANCE);
    }

    @ApiStatus.Internal
    public final void clearCachesOfLanguageExtension(Language language, LanguageExtension<?> instance) {
        instance.clearCache(language);
        this.disposeOnTearDown(() -> instance.clearCache(language));
    }

    public void configureFromParserDefinition(@NotNull ParserDefinition definition, String extension) {
        if (definition == null) {
            ParsingTestCase.$$$reportNull$$$0(8);
        }
        this.myLanguage = definition.getFileNodeType().getLanguage();
        this.myFileExt = extension;
        this.registerParserDefinition(definition);
        this.app.registerService(FileTypeManager.class, (Object)new MockFileTypeManager((FileType)new MockLanguageFileType(this.myLanguage, this.myFileExt)));
    }

    protected final <T> void registerExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(9);
        }
        if (extension == null) {
            ParsingTestCase.$$$reportNull$$$0(10);
        }
        this.registerExtensions(name, extension.getClass(), Collections.singletonList(extension));
    }

    protected final <T> void registerExtensions(@NotNull ExtensionPointName<T> name, @NotNull Class<T> extensionClass, @NotNull List<? extends T> extensions) {
        ExtensionsAreaImpl area;
        ExtensionPointImpl<T> point;
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(11);
        }
        if (extensionClass == null) {
            ParsingTestCase.$$$reportNull$$$0(12);
        }
        if (extensions == null) {
            ParsingTestCase.$$$reportNull$$$0(13);
        }
        if ((point = (area = this.app.getExtensionArea()).getExtensionPointIfRegistered(name.getName())) == null) {
            point = this.registerExtensionPoint(area, (BaseExtensionPointName<T>)name, extensionClass);
        }
        for (T extension : extensions) {
            point.registerExtension(extension);
        }
    }

    protected final <T> void addExplicitExtensionForAnyLanguage(@NotNull LanguageExtension<T> collector, @NotNull T object) {
        if (collector == null) {
            ParsingTestCase.$$$reportNull$$$0(14);
        }
        if (object == null) {
            ParsingTestCase.$$$reportNull$$$0(15);
        }
        this.addExplicitExtensionImpl(collector, "any", object);
    }

    protected final <T> void addExplicitExtension(@NotNull LanguageExtension<T> collector, @NotNull Language language, @NotNull T object) {
        if (collector == null) {
            ParsingTestCase.$$$reportNull$$$0(16);
        }
        if (language == null) {
            ParsingTestCase.$$$reportNull$$$0(17);
        }
        if (object == null) {
            ParsingTestCase.$$$reportNull$$$0(18);
        }
        this.addExplicitExtensionImpl(collector, language.getID(), object);
    }

    private <T> void addExplicitExtensionImpl(@NotNull LanguageExtension<T> collector, @NotNull @NlsSafe String languageID, @NotNull T object) {
        if (collector == null) {
            ParsingTestCase.$$$reportNull$$$0(19);
        }
        if (languageID == null) {
            ParsingTestCase.$$$reportNull$$$0(20);
        }
        if (object == null) {
            ParsingTestCase.$$$reportNull$$$0(21);
        }
        ExtensionsAreaImpl area = this.app.getExtensionArea();
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        if (!area.hasExtensionPoint(collector.getName())) {
            area.registerFakeBeanPoint(collector.getName(), pluginDescriptor);
        }
        LanguageExtensionPoint extension = new LanguageExtensionPoint(languageID, object);
        extension.setPluginDescriptor(pluginDescriptor);
        ExtensionTestUtil.addExtension(area, collector, extension);
    }

    protected final <T> void registerExtensionPoint(@NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        if (extensionPointName == null) {
            ParsingTestCase.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            ParsingTestCase.$$$reportNull$$$0(23);
        }
        this.registerExtensionPoint(this.app.getExtensionArea(), (BaseExtensionPointName<T>)extensionPointName, aClass);
    }

    protected <T> ExtensionPointImpl<T> registerExtensionPoint(@NotNull ExtensionsAreaImpl extensionArea, @NotNull BaseExtensionPointName<T> extensionPointName, @NotNull Class<T> extensionClass) {
        String name;
        if (extensionArea == null) {
            ParsingTestCase.$$$reportNull$$$0(24);
        }
        if (extensionPointName == null) {
            ParsingTestCase.$$$reportNull$$$0(25);
        }
        if (extensionClass == null) {
            ParsingTestCase.$$$reportNull$$$0(26);
        }
        if (extensionArea.hasExtensionPoint(name = extensionPointName.getName())) {
            return extensionArea.getExtensionPoint(name);
        }
        return extensionArea.registerPoint(name, extensionClass, this.getPluginDescriptor(), false);
    }

    @NotNull
    protected PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            this.pluginDescriptor = pluginDescriptor = new DefaultPluginDescriptor(PluginId.getId((String)(((Object)((Object)this)).getClass().getName() + "." + this.getName())), ParsingTestCase.class.getClassLoader());
        }
        PluginDescriptor pluginDescriptor2 = pluginDescriptor;
        if (pluginDescriptor2 == null) {
            ParsingTestCase.$$$reportNull$$$0(27);
        }
        return pluginDescriptor2;
    }

    @NotNull
    public MockProjectEx getProject() {
        MockProjectEx mockProjectEx = this.project;
        if (mockProjectEx == null) {
            ParsingTestCase.$$$reportNull$$$0(28);
        }
        return mockProjectEx;
    }

    public MockPsiManager getPsiManager() {
        return this.myPsiManager;
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFile = null;
        this.project = null;
        this.myPsiManager = null;
        this.myFileFactory = null;
        super.tearDown();
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    @NotNull
    public final String getTestName() {
        String string = this.getTestName(this.myLowercaseFirstLetter);
        if (string == null) {
            ParsingTestCase.$$$reportNull$$$0(29);
        }
        return string;
    }

    protected boolean includeRanges() {
        return false;
    }

    protected boolean skipSpaces() {
        return false;
    }

    protected boolean checkAllPsiRoots() {
        return true;
    }

    protected void ensureNoErrorElements() {
        ParsingTestUtil.assertNoPsiErrorElements(this.myFile);
    }

    protected void doTest(boolean checkResult) {
        this.doTest(checkResult, false);
    }

    protected void doTest(boolean checkResult, boolean ensureNoErrorElements) {
        String name = this.getTestName();
        try {
            this.parseFile(name, this.loadFile(name + "." + this.myFileExt));
            if (checkResult) {
                this.checkResult(name, this.myFile);
                if (ensureNoErrorElements) {
                    this.ensureNoErrorElements();
                }
            } else {
                ParsingTestCase.toParseTreeText((PsiElement)this.myFile, this.skipSpaces(), this.includeRanges());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected PsiFile parseFile(String name, String text) {
        this.myFile = this.createPsiFile(name, text);
        ParsingTestCase.assertEquals((String)"light virtual file text mismatch", (String)text, (String)((LightVirtualFile)this.myFile.getVirtualFile()).getContent().toString());
        ParsingTestCase.assertEquals((String)"virtual file text mismatch", (Object)text, (Object)LoadTextUtil.loadText((VirtualFile)this.myFile.getVirtualFile()));
        ParsingTestCase.assertEquals((String)"doc text mismatch", (String)text, (String)Objects.requireNonNull(this.myFile.getViewProvider().getDocument()).getText());
        if (this.checkAllPsiRoots()) {
            for (PsiFile root : this.myFile.getViewProvider().getAllFiles()) {
                this.doSanityChecks(root);
            }
        } else {
            this.doSanityChecks(this.myFile);
        }
        return this.myFile;
    }

    private void doSanityChecks(PsiFile root) {
        ParsingTestCase.assertEquals((String)"psi text mismatch", (String)root.getViewProvider().getContents().toString(), (String)root.getText());
        ParsingTestCase.ensureParsed(root);
        ParsingTestCase.ensureCorrectReparse(root, this.isCheckNoPsiEventsOnReparse());
        ParsingTestCase.checkRangeConsistency(root);
    }

    @Deprecated
    protected boolean isCheckNoPsiEventsOnReparse() {
        return true;
    }

    private static void checkRangeConsistency(final PsiFile file) {
        file.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof ForeignLeafPsiElement) {
                    return;
                }
                try {
                    this.ensureNodeRangeConsistency(element, file);
                }
                catch (Throwable e) {
                    throw new AssertionError("In " + String.valueOf(element) + " of " + String.valueOf(element.getClass()), e);
                }
                super.visitElement(element);
            }

            private void ensureNodeRangeConsistency(PsiElement parent, PsiFile file2) {
                int parentOffset = parent.getTextRange().getStartOffset();
                int childOffset = 0;
                ASTNode child = parent.getNode().getFirstChildNode();
                if (child != null) {
                    while (child != null) {
                        int childLength = 2.checkChildRangeConsistency(file2, parentOffset, childOffset, child);
                        childOffset += childLength;
                        child = child.getTreeNext();
                    }
                    TestCase.assertEquals((int)childOffset, (int)parent.getTextLength());
                }
            }

            private static int checkChildRangeConsistency(PsiFile file2, int parentOffset, int childOffset, ASTNode child) {
                TestCase.assertEquals((int)child.getStartOffsetInParent(), (int)childOffset);
                TestCase.assertEquals((int)child.getStartOffset(), (int)(childOffset + parentOffset));
                int childLength = child.getTextLength();
                TestCase.assertEquals((Object)TextRange.from((int)(childOffset + parentOffset), (int)childLength), (Object)child.getTextRange());
                if (!(child.getPsi() instanceof ForeignLeafPsiElement)) {
                    TestCase.assertEquals((String)child.getTextRange().substring(file2.getText()), (String)child.getText());
                }
                return childLength;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestCase$2", "visitElement"));
            }
        });
    }

    protected void doTest(String suffix) throws IOException {
        String name = this.getTestName();
        String text = this.loadFile(name + "." + this.myFileExt);
        this.myFile = this.createPsiFile(name, text);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)text, (String)this.myFile.getText());
        this.checkResult(name + suffix, this.myFile);
    }

    protected void doCodeTest(@NotNull String code) throws IOException {
        if (code == null) {
            ParsingTestCase.$$$reportNull$$$0(30);
        }
        String name = this.getTestName();
        this.myFile = this.createPsiFile("a", code);
        ParsingTestCase.ensureParsed(this.myFile);
        ParsingTestCase.assertEquals((String)code, (String)this.myFile.getText());
        this.checkResult(this.myFilePrefix + name, this.myFile);
    }

    protected void doReparseTest(String textBefore, String textAfter) {
        PsiFile file = this.createFile("test." + this.myFileExt, textBefore);
        PsiFile fileAfter = this.createFile("test." + this.myFileExt, textAfter);
        int rangeStart = StringUtil.commonPrefixLength((CharSequence)textBefore, (CharSequence)textAfter);
        int rangeEnd = textBefore.length() - StringUtil.commonSuffixLength((CharSequence)textBefore, (CharSequence)textAfter);
        TextRange range = new TextRange(Math.min(rangeStart, rangeEnd), Math.max(rangeStart, rangeEnd));
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)fileAfter, (boolean)true, (boolean)false, (boolean)true, null);
        DebugUtil.performPsiModification((String)"ensureCorrectReparse", () -> new BlockSupportImpl().reparseRange(file, file.getNode(), range, (CharSequence)fileAfter.getText(), (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)file.getText()).performActualPsiChange(file));
        ParsingTestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)false, (boolean)true, null));
    }

    protected PsiFile createPsiFile(@NotNull String name, @NotNull String text) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(31);
        }
        if (text == null) {
            ParsingTestCase.$$$reportNull$$$0(32);
        }
        return this.createFile(name + "." + this.myFileExt, text);
    }

    protected PsiFile createFile(@NotNull String name, @NotNull String text) {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(33);
        }
        if (text == null) {
            ParsingTestCase.$$$reportNull$$$0(34);
        }
        LightVirtualFile virtualFile = new LightVirtualFile(name, this.myLanguage, (CharSequence)text);
        virtualFile.setCharset(StandardCharsets.UTF_8);
        return this.createFile(virtualFile);
    }

    protected PsiFile createFile(@NotNull LightVirtualFile virtualFile) {
        if (virtualFile == null) {
            ParsingTestCase.$$$reportNull$$$0(35);
        }
        return this.myFileFactory.trySetupPsiForFile(virtualFile, this.myLanguage, true, false);
    }

    protected void checkResult(@NotNull @TestDataFile String targetDataName, @NotNull PsiFile file) throws IOException {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(36);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(37);
        }
        this.checkResult(this.myFullDataPath, targetDataName, file);
    }

    protected void checkResult(String fullDataPath, @NotNull @TestDataFile String targetDataName, @NotNull PsiFile file) throws IOException {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(38);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(39);
        }
        ParsingTestCase.doCheckResult(fullDataPath, file, this.checkAllPsiRoots(), targetDataName, this.skipSpaces(), this.includeRanges(), this.allTreesInSingleFile());
        if (SystemProperties.getBooleanProperty((String)"dumpAstTypeNames", (boolean)false)) {
            this.printAstTypeNamesTree(targetDataName, file);
        }
    }

    private void printAstTypeNamesTree(@NotNull @TestDataFile String targetDataName, @NotNull PsiFile file) {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(40);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(41);
        }
        StringBuffer buffer = new StringBuffer();
        Arrays.stream(file.getNode().getChildren(TokenSet.ANY)).forEach(it -> ParsingTestCase.printAstTypeNamesTree(it, buffer, 0));
        try {
            Files.writeString(Paths.get(this.myFullDataPath, targetDataName + ".fleet.txt"), (CharSequence)buffer, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printAstTypeNamesTree(ASTNode node, StringBuffer buffer, int indent) {
        buffer.append(" ".repeat(indent));
        buffer.append(node.getElementType()).append("\n");
        indent += 2;
        for (ASTNode childNode = node.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            ParsingTestCase.printAstTypeNamesTree(childNode, buffer, indent);
        }
    }

    protected boolean allTreesInSingleFile() {
        return false;
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(42);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(43);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(44);
        }
        ParsingTestCase.doCheckResult(testDataDir, file, checkAllPsiRoots, targetDataName, skipSpaces, printRanges, false);
    }

    public static void doCheckResult(@NotNull String testDataDir, @NotNull PsiFile file, boolean checkAllPsiRoots, @NotNull String targetDataName, boolean skipSpaces, boolean printRanges, boolean allTreesInSingleFile) {
        if (testDataDir == null) {
            ParsingTestCase.$$$reportNull$$$0(45);
        }
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(46);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(47);
        }
        FileViewProvider provider = file.getViewProvider();
        Set languages = provider.getLanguages();
        if (!checkAllPsiRoots || languages.size() == 1) {
            ParsingTestCase.doCheckResult(testDataDir, targetDataName + ".txt", ParsingTestCase.toParseTreeText((PsiElement)file, skipSpaces, printRanges).trim());
            return;
        }
        if (allTreesInSingleFile) {
            String expectedName = targetDataName + ".txt";
            StringBuilder sb = new StringBuilder();
            ArrayList languagesList = new ArrayList(languages);
            ContainerUtil.sort(languagesList, Comparator.comparing(Language::getID));
            for (Language language : languagesList) {
                sb.append("Subtree: ").append(language.getDisplayName()).append(" (").append(language.getID()).append(")").append("\n").append(ParsingTestCase.toParseTreeText((PsiElement)provider.getPsi(language), skipSpaces, printRanges).trim()).append("\n").append(StringUtil.repeat((String)"-", (int)80)).append("\n");
            }
            ParsingTestCase.doCheckResult(testDataDir, expectedName, sb.toString());
        } else {
            for (Language language : languages) {
                PsiFile root = provider.getPsi(language);
                ParsingTestCase.assertNotNull((String)("FileViewProvider " + String.valueOf(provider) + " didn't return PSI root for language " + language.getID()), (Object)root);
                String expectedName = targetDataName + "." + language.getID() + ".txt";
                ParsingTestCase.doCheckResult(testDataDir, expectedName, ParsingTestCase.toParseTreeText((PsiElement)root, skipSpaces, printRanges).trim());
            }
        }
    }

    protected void checkResult(@NotNull String actual) {
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(48);
        }
        String name = this.getTestName();
        ParsingTestCase.doCheckResult(this.myFullDataPath, this.myFilePrefix + name + ".txt", actual);
    }

    protected void checkResult(@NotNull @TestDataFile String targetDataName, @NotNull String actual) {
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(49);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(50);
        }
        ParsingTestCase.doCheckResult(this.myFullDataPath, targetDataName, actual);
    }

    public static void doCheckResult(@NotNull String fullPath, @NotNull String targetDataName, @NotNull String actual) {
        if (fullPath == null) {
            ParsingTestCase.$$$reportNull$$$0(51);
        }
        if (targetDataName == null) {
            ParsingTestCase.$$$reportNull$$$0(52);
        }
        if (actual == null) {
            ParsingTestCase.$$$reportNull$$$0(53);
        }
        String expectedFileName = fullPath + File.separatorChar + targetDataName;
        UsefulTestCase.assertSameLinesWithFile(expectedFileName, actual);
    }

    protected static String toParseTreeText(@NotNull PsiElement file, boolean skipSpaces, boolean printRanges) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(54);
        }
        return DebugUtil.psiToString((PsiElement)file, (!skipSpaces ? 1 : 0) != 0, (boolean)printRanges);
    }

    protected String loadFile(@NotNull @TestDataFile String name) throws IOException {
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(55);
        }
        return ParsingTestCase.loadFileDefault(this.myFullDataPath, name);
    }

    public static String loadFileDefault(@NotNull String dir, @NotNull String name) throws IOException {
        if (dir == null) {
            ParsingTestCase.$$$reportNull$$$0(56);
        }
        if (name == null) {
            ParsingTestCase.$$$reportNull$$$0(57);
        }
        return FileUtil.loadFile((File)new File(dir, name), (String)"UTF-8", (boolean)true).trim();
    }

    public static void ensureParsed(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(58);
        }
        file.accept(new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/testFramework/ParsingTestCase$3", "visitElement"));
            }
        });
    }

    public static void ensureCorrectReparse(@NotNull PsiFile file) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(59);
        }
        ParsingTestCase.ensureCorrectReparse(file, true);
    }

    private static void ensureCorrectReparse(@NotNull PsiFile file, boolean isCheckNoPsiEventsOnReparse) {
        if (file == null) {
            ParsingTestCase.$$$reportNull$$$0(60);
        }
        String psiToStringDefault = DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)false);
        TreeChangeEventImpl event = (TreeChangeEventImpl)DebugUtil.performPsiModification((String)"ensureCorrectReparse", () -> {
            String fileText = file.getText();
            DiffLog diffLog = new BlockSupportImpl().reparseRange(file, file.getNode(), TextRange.allOf((String)fileText), (CharSequence)fileText, (ProgressIndicator)new EmptyProgressIndicator(), (CharSequence)fileText);
            return diffLog.performActualPsiChange(file);
        });
        ParsingTestCase.assertEquals((String)psiToStringDefault, (String)DebugUtil.psiToString((PsiElement)file, (boolean)true, (boolean)false));
        if (isCheckNoPsiEventsOnReparse) {
            ParsingTestCase.assertEmpty(event.getChangedElements());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitions";
                break;
            }
            case 6: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: 
            case 11: 
            case 31: 
            case 33: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageID";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPointName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionArea";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 47: 
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDataName";
                break;
            }
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 54: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 48: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/ParsingTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplication";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerParserDefinition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureFromParserDefinition";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtensionForAnyLanguage";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtensionImpl";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPoint";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doCodeTest";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createPsiFile";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkResult";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "printAstTypeNamesTree";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "doCheckResult";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "toParseTreeText";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "loadFileDefault";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "ensureParsed";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "ensureCorrectReparse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 27, 28, 29 -> new IllegalStateException(string);
        };
    }
}

