/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.common.util;

import java.util.Stack;
import org.jdom2.Namespace;

class NamespaceStack {
    private Stack<String> prefixes = new Stack();
    private Stack<String> uris = new Stack();

    NamespaceStack() {
    }

    public void push(Namespace ns) {
        this.prefixes.push(ns.getPrefix());
        this.uris.push(ns.getURI());
    }

    public String pop() {
        String prefix = this.prefixes.pop();
        this.uris.pop();
        return prefix;
    }

    public int size() {
        return this.prefixes.size();
    }

    public String getURI(String prefix) {
        int index = this.prefixes.lastIndexOf(prefix);
        if (index == -1) {
            return null;
        }
        String uri = (String)this.uris.elementAt(index);
        return uri;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String sep = System.lineSeparator();
        buf.append("Stack: " + this.prefixes.size() + sep);
        for (int i = 0; i < this.prefixes.size(); ++i) {
            buf.append((String)this.prefixes.elementAt(i) + "&" + (String)this.uris.elementAt(i) + sep);
        }
        return buf.toString();
    }
}

