/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCallTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.TranslatedCallArgument;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperator;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsDoubleLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsSuperRef;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\n\u001a\u00020\u00022\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010 \u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\"\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010$\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020%2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010&\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020)2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010*\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020+2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010,\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010.\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u00100\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002012\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u00102\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002032\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00104\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002052\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00106\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u00108\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u0002092\u0006\u0010\r\u001a\u00020\u0003H\u0016J \u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010>\u001a\u00020?2\u0006\u0010<\u001a\u00020=2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J \u0010@\u001a\u00020A2\u0006\u0010<\u001a\u00020B2\u0006\u0010\u000b\u001a\u0002072\u0006\u0010\r\u001a\u00020\u0003H\u0002J\f\u0010C\u001a\u00020\u0007*\u00020DH\u0002\u00a8\u0006E"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "isClassInlineLike", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitMemberAccess", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "data", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "context", "visitExpressionBody", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "toDoubleConst", "", "f", "", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "visitDynamicOperatorExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "visitRawFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrRawFunctionReference;", "prefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "operator", "Lorg/jetbrains/kotlin/js/backend/ast/JsUnaryOperator;", "postfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "binaryOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperator;", "isThisReceiver", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrElementToJsExpressionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrElementToJsExpressionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n*L\n1#1,365:1\n1803#2,3:366\n2746#2,3:369\n1563#2:372\n1634#2,3:373\n1563#2:380\n1634#2,3:381\n2746#2,3:384\n1634#2,3:388\n1634#2,3:392\n1634#2,3:396\n1292#3,3:376\n1#4:379\n16#5:387\n16#5:391\n16#5:395\n*S KotlinDebug\n*F\n+ 1 IrElementToJsExpressionTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrElementToJsExpressionTransformer\n*L\n45#1:366,3\n51#1:369,3\n52#1:372\n52#1:373,3\n183#1:380\n183#1:381,3\n215#1:384,3\n216#1:388,3\n231#1:392,3\n328#1:396,3\n102#1:376,3\n216#1:387\n231#1:391\n328#1:395\n*E\n"})
public final class IrElementToJsExpressionTransformer
extends BaseIrElementToJsNodeTransformer<JsExpression, JsGenerationContext> {
    private final boolean isClassInlineLike(JsGenerationContext $this$isClassInlineLike, IrClass irClass) {
        return $this$isClassInlineLike.getStaticContext().getBackendContext().getInlineClassesUtils().isClassInlineLike(irClass);
    }

    @NotNull
    public JsExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = super.visitMemberAccess(expression2, (Object)data);
        JsExpression $this$visitMemberAccess_u24lambda_u240 = (JsExpression)object;
        boolean bl = false;
        MetadataProperties.setSynthetic($this$visitMemberAccess_u24lambda_u240, Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT()));
        return (JsExpression)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitComposite(@NotNull IrComposite expression2, @NotNull JsGenerationContext data) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int size = expression2.getStatements().size();
        if (size == 0) {
            String string = "Empty IrComposite is not supported";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        JsExpression first = (JsExpression)((IrStatement)expression2.getStatements().get(0)).accept((IrVisitor)this, (Object)data);
        if (size == 1) {
            return first;
        }
        Iterable iterable = expression2.getStatements();
        JsExpression initial$iv = first;
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void right;
            IrStatement irStatement = (IrStatement)element$iv;
            JsExpression left = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.COMMA, left, (JsExpression)right.accept((IrVisitor)this, (Object)data));
        }
        return accumulator$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitVararg(@NotNull IrVararg expression2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        boolean $this$none$iv2;
        block5: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$none$iv2 = expression2.getElements();
            boolean $i$f$none = false;
            if ($this$none$iv2 instanceof Collection && ((Collection)$this$none$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv2) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrSpreadElement)) continue;
                    bl = false;
                    break block5;
                }
                bl = $this$none$iv2 = true;
            }
        }
        if (_Assertions.ENABLED && !$this$none$iv2) {
            String $i$f$none = "Assertion failed";
            throw new AssertionError((Object)$i$f$none);
        }
        Iterable $this$map$iv = expression2.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((JsExpression)it.accept((IrVisitor)this, (Object)context));
        }
        List list = MemoryOptimizedCollectionUtilKt.toSmartList((Collection)((List)destination$iv$iv));
        return (JsExpression)JsAstUtilsKt.withSource$default(new JsArrayLiteral(list), (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitExpressionBody(@NotNull IrExpressionBody body, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (JsExpression)body.getExpression().accept((IrVisitor)this, (Object)context);
    }

    @NotNull
    public JsExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrSimpleFunction irFunction = expression2.getFunction();
        Object object = irFunction.accept((IrVisitor)new IrFunctionToJsTransformer(), (Object)context);
        JsFunction $this$visitFunctionExpression_u24lambda_u244 = (JsFunction)object;
        boolean bl = false;
        $this$visitFunctionExpression_u24lambda_u244.setName(null);
        if (context.getStaticContext().getBackendContext().getConfiguration().getBoolean(JSConfigurationKeys.COMPILE_LAMBDAS_AS_ES6_ARROW_FUNCTIONS)) {
            $this$visitFunctionExpression_u24lambda_u244.setEs6Arrow(true);
        }
        return (JsExpression)object;
    }

    @NotNull
    public JsExpression visitConst(@NotNull IrConst expression2, @NotNull JsGenerationContext context) {
        JsLiteral.JsValueLiteral jsValueLiteral;
        IrConstKind kind;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrConstKind irConstKind = kind = expression2.getKind();
        if (irConstKind instanceof IrConstKind.String) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            jsValueLiteral = new JsStringLiteral((String)object);
        } else if (irConstKind instanceof IrConstKind.Null) {
            jsValueLiteral = new JsNullLiteral();
        } else if (irConstKind instanceof IrConstKind.Boolean) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            jsValueLiteral = new JsBooleanLiteral((Boolean)object);
        } else if (irConstKind instanceof IrConstKind.Byte) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
            jsValueLiteral = new JsIntLiteral(((Byte)object).byteValue());
        } else if (irConstKind instanceof IrConstKind.Short) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
            jsValueLiteral = new JsIntLiteral(((Short)object).shortValue());
        } else if (irConstKind instanceof IrConstKind.Int) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            jsValueLiteral = new JsIntLiteral((Integer)object);
        } else {
            if (irConstKind instanceof IrConstKind.Long) {
                CompilationExceptionKt.compilationException((String)"Long const should have been lowered at this point", (IrElement)((IrElement)expression2));
                throw new KotlinNothingValueException();
            }
            if (irConstKind instanceof IrConstKind.Char) {
                CompilationExceptionKt.compilationException((String)"Char const should have been lowered at this point", (IrElement)((IrElement)expression2));
                throw new KotlinNothingValueException();
            }
            if (irConstKind instanceof IrConstKind.Float) {
                Object object = expression2.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
                jsValueLiteral = new JsDoubleLiteral(this.toDoubleConst(((Float)object).floatValue()));
            } else if (irConstKind instanceof IrConstKind.Double) {
                Object object = expression2.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
                jsValueLiteral = new JsDoubleLiteral((Double)object);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsValueLiteral, (IrElement)expression2, context, null, null, 12, null);
    }

    private final double toDoubleConst(float f) {
        return Float.isInfinite(f) || Float.isNaN(f) ? (double)f : Double.parseDouble(String.valueOf(f));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull JsGenerationContext context) {
        void $this$fold$iv;
        Sequence tail;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrExpression firstArgument = (IrExpression)CollectionsKt.firstOrNull((List)expression2.getArguments());
        IrExpression irExpression = firstArgument;
        Pair pair = (irExpression != null && (irExpression = irExpression.getType()) != null ? IrTypePredicatesKt.isString((IrType)irExpression) : false) ? new Pair(firstArgument.accept((IrVisitor)this, (Object)context), (Object)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)expression2.getArguments()), (int)1)) : new Pair((Object)new JsStringLiteral(""), (Object)CollectionsKt.asSequence((Iterable)expression2.getArguments()));
        JsExpression head = (JsExpression)pair.component1();
        Sequence sequence = tail = (Sequence)pair.component2();
        JsExpression initial$iv = head;
        boolean $i$f$fold = false;
        JsExpression accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void irExpr;
            IrExpression irExpression2 = (IrExpression)element$iv;
            JsExpression jsExpr = accumulator$iv;
            boolean bl = false;
            accumulator$iv = new JsBinaryOperation(JsBinaryOperator.ADD, jsExpr, (JsExpression)irExpr.accept((IrVisitor)this, (Object)context));
        }
        return accumulator$iv;
    }

    @NotNull
    public JsExpression visitGetField(@NotNull IrGetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrFieldSymbol symbol = expression2.getSymbol();
        IrField field = (IrField)symbol.getOwner();
        IrDeclarationParent fieldParent = field.getParent();
        if (fieldParent instanceof IrClass && IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)field))) {
            boolean bl = IrUtilsKt.isEnumClass((IrClass)((IrClass)fieldParent));
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = RenderIrElementKt.render$default((IrElement)((IrElement)field), null, (int)1, null) + " in non-external class " + RenderIrElementKt.render$default((IrElement)((IrElement)fieldParent), null, (int)1, null);
                throw new AssertionError((Object)string);
            }
            Object object = expression2.getReceiver();
            if (object == null || (object = (JsExpression)object.accept((IrVisitor)this, (Object)context)) == null) {
                CompilationExceptionKt.compilationException((String)"Expect expression.receiver to not be null", (IrElement)((IrElement)expression2));
                throw new KotlinNothingValueException();
            }
            Object receiver = object;
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsNameRef(AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)field).getIdentifier(), (JsExpression)receiver), (IrElement)expression2, context, null, null, 12, null);
        }
        if (fieldParent instanceof IrClass && this.isClassInlineLike(context, (IrClass)fieldParent)) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            return (JsExpression)JsAstUtilsKt.withSource$default((JsNode)irExpression.accept((IrVisitor)this, (Object)context), (IrElement)expression2, context, null, null, 12, null);
        }
        JsName fieldName = context.getNameForField(field);
        IrExpression irExpression = expression2.getReceiver();
        JsNode jsNode = JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsElementAccess(fieldName, irExpression != null ? (JsExpression)irExpression.accept((IrVisitor)this, (Object)context) : null), (IrElement)expression2, context, null, null, 12, null);
        JsExpression $this$visitGetField_u24lambda_u247 = (JsExpression)jsNode;
        boolean bl = false;
        if (Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFIELD_FOR_OBJECT_INSTANCE()) && Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)JsStatementOrigins.INSTANCE.getSYNTHESIZED_STATEMENT())) {
            MetadataProperties.setSynthetic($this$visitGetField_u24lambda_u247, true);
            MetadataProperties.setSideEffects($this$visitGetField_u24lambda_u247, SideEffectKind.PURE);
        }
        return (JsExpression)jsNode;
    }

    @NotNull
    public JsExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueDeclaration owner = expression2.getSymbol().getOwner();
        if (this.isThisReceiver(owner)) {
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsThisRef(), (IrElement)expression2, context, null, null, 12, null);
        }
        JsNode jsNode = JsAstUtilsKt.withSource$default(context.getNameForValueDeclaration((IrDeclarationWithName)owner).makeRef(), (IrElement)expression2, context, null, null, 12, null);
        Intrinsics.checkNotNull((Object)jsNode);
        return (JsExpression)jsNode;
    }

    @NotNull
    public JsExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull JsGenerationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrClass obj = (IrClass)expression2.getSymbol().getOwner();
        boolean bl2 = bl = obj.getKind() == ClassKind.OBJECT;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)obj));
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22 = false;
            String $i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22 = "Non external IrGetObjectValue must be lowered";
            throw new AssertionError((Object)$i$a$-assert-IrElementToJsExpressionTransformer$visitGetObjectValue$22);
        }
        JsNode jsNode = JsAstUtilsKt.withSource$default(context.getRefForExternalClass(obj), (IrElement)expression2, context, null, null, 12, null);
        JsNameRef $this$visitGetObjectValue_u24lambda_u249 = (JsNameRef)jsNode;
        boolean bl3 = false;
        MetadataProperties.setSideEffects($this$visitGetObjectValue_u24lambda_u249, SideEffectKind.PURE);
        return (JsExpression)jsNode;
    }

    @NotNull
    public JsExpression visitSetField(@NotNull IrSetField expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        JsName fieldName = context.getNameForField(field);
        String string = fieldName.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
        IrExpression irExpression = expression2.getReceiver();
        JsExpression dest = JsAstUtilsKt.jsElementAccess(string, irExpression != null ? (JsExpression)irExpression.accept((IrVisitor)this, (Object)context) : null);
        JsExpression source = (JsExpression)expression2.getValue().accept((IrVisitor)this, (Object)context);
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsAssignment(dest, source), (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        IrValueDeclaration field = expression2.getSymbol().getOwner();
        JsNameRef ref = new JsNameRef(context.getNameForValueDeclaration((IrDeclarationWithName)field));
        JsExpression value = (JsExpression)expression2.getValue().accept((IrVisitor)this, (Object)context);
        return (JsExpression)JsAstUtilsKt.withSource$default(new JsBinaryOperation(JsBinaryOperator.ASG, ref, value), (IrElement)expression2, context, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull JsGenerationContext context) {
        void $this$mapTo$iv$iv;
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsExpression classNameRef = IrTypeUtilsKt.getConstructorRef((IrConstructor)expression2.getSymbol().getOwner(), context.getStaticContext());
        JsNameRef callFuncRef = new JsNameRef(Namer.INSTANCE.getCALL_FUNCTION(), classNameRef);
        boolean fromPrimary = context.getCurrentFunction() instanceof IrConstructor;
        if (fromPrimary) {
            jsExpression = new JsThisRef();
        } else {
            IrFunction irFunction = context.getCurrentFunction();
            Intrinsics.checkNotNull((Object)irFunction);
            JsNameRef jsNameRef = context.getNameForValueDeclaration((IrDeclarationWithName)CollectionsKt.last((List)irFunction.getParameters())).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            jsExpression = jsNameRef;
        }
        JsExpression thisRef = jsExpression;
        Iterable $this$map$iv = JsAstUtilsKt.translateNonDispatchCallArguments$default((IrMemberAccessExpression)expression2, context, this, false, 8, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getJsArgument());
        }
        List arguments = (List)destination$iv$iv;
        IrConstructor constructor = (IrConstructor)expression2.getSymbol().getOwner();
        if (this.isClassInlineLike(context, IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)constructor)))) {
            boolean bl = constructor.isPrimary();
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string = "Delegation to secondary inline constructors must be lowered into simple function calls";
                throw new AssertionError((Object)string);
            }
            return (JsExpression)JsAstUtilsKt.withSource$default(new JsBinaryOperation(JsBinaryOperator.ASG, thisRef, (JsExpression)CollectionsKt.single((List)arguments)), (IrElement)expression2, context, null, null, 12, null);
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(context.getStaticContext().getBackendContext().getEs6mode() ? new JsInvocation((JsExpression)new JsSuperRef(), arguments) : new JsInvocation((JsExpression)callFuncRef, MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus((List)CollectionsKt.listOf((Object)thisRef), (List)arguments)), (IrElement)expression2, context, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull JsGenerationContext context) {
        JsNew jsNew;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Function2<IrConstructorCall, JsGenerationContext, JsExpression> function2 = context.getStaticContext().getIntrinsics().get(expression2.getSymbol());
        if (function2 != null) {
            Function2<IrConstructorCall, JsGenerationContext, JsExpression> it = function2;
            boolean bl = false;
            return (JsExpression)it.invoke((Object)expression2, (Object)context);
        }
        IrConstructor function3 = (IrConstructor)expression2.getSymbol().getOwner();
        List arguments = JsAstUtilsKt.translateNonDispatchCallArguments$default((IrMemberAccessExpression)expression2, context, this, false, 8, null);
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function3));
        if (!(!this.isClassInlineLike(context, klass))) {
            boolean $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332 = false;
            String $i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-IrElementToJsExpressionTransformer$visitConstructorCall$332.toString());
        }
        if (IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)klass))) {
            JsExpression[] $this$mapTo$iv$iv;
            boolean bl;
            Iterable $this$none$iv;
            JsExpression refForExternalClass;
            block11: {
                refForExternalClass = IrTypeUtilsKt.getClassRef(klass, context.getStaticContext());
                $this$none$iv = ((IrConstructor)expression2.getSymbol().getOwner()).getParameters();
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl2 = false;
                        if (!AdditionalIrUtilsKt.isVararg((IrValueParameter)it)) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (bl) {
                void $this$memoryOptimizedMap$iv;
                $this$none$iv = arguments;
                JsExpression jsExpression = refForExternalClass;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object t : $this$mapTo$iv$iv) {
                    void it;
                    TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)t;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getJsArgument());
                }
                List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
                JsExpression jsExpression2 = jsExpression;
                jsNew = new JsNew(jsExpression2, list);
            } else {
                IrValueParameter irValueParameter = klass.getThisReceiver();
                Intrinsics.checkNotNull((Object)irValueParameter);
                TranslatedCallArgument dummyThisArg = new TranslatedCallArgument(irValueParameter, null, new JsNullLiteral());
                JsExpression argumentsAsSingleArray = JsAstUtilsKt.argumentsWithVarargAsSingleArray(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)dummyThisArg), (Iterable)arguments), context);
                $this$mapTo$iv$iv = new JsExpression[]{refForExternalClass, argumentsAsSingleArray};
                JsNew jsNew2 = new JsNew((JsExpression)new JsInvocation((JsExpression)new JsNameRef("apply", (JsExpression)new JsNameRef("bind", (JsExpression)new JsNameRef("Function"))), $this$mapTo$iv$iv), CollectionsKt.emptyList());
                jsNew = jsNew2;
            }
        } else {
            void $this$mapTo$iv$iv;
            void $this$memoryOptimizedMap$iv;
            Collection refForExternalClass = arguments;
            JsExpression jsExpression = IrTypeUtilsKt.getClassRef(klass, context.getStaticContext());
            boolean $i$f$memoryOptimizedMap = false;
            Iterable argumentsAsSingleArray = (Iterable)$this$memoryOptimizedMap$iv;
            Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TranslatedCallArgument translatedCallArgument = (TranslatedCallArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(translatedCallArgument.getJsArgument());
            }
            List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
            JsExpression jsExpression3 = jsExpression;
            jsNew = new JsNew(jsExpression3, list);
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsNew, (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitCall(@NotNull IrCall expression2, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.checkIfJsCode((IrFunctionSymbol)expression2.getSymbol()) || context.checkIfHasAssociatedJsCode((IrFunctionSymbol)expression2.getSymbol())) {
            return new JsCallTransformer(expression2, context).generateExpression();
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.translateCall(expression2, context, this), (IrElement)expression2, context, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitWhen(@NotNull IrWhen expression2, @NotNull JsGenerationContext context) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getANDAND())) {
            return new JsBinaryOperation(JsBinaryOperator.AND, (JsExpression)((IrBranch)expression2.getBranches().get(0)).getCondition().accept((IrVisitor)this, (Object)context), (JsExpression)((IrBranch)expression2.getBranches().get(0)).getResult().accept((IrVisitor)this, (Object)context));
        }
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getOROR())) {
            return new JsBinaryOperation(JsBinaryOperator.OR, (JsExpression)((IrBranch)expression2.getBranches().get(0)).getCondition().accept((IrVisitor)this, (Object)context), (JsExpression)((IrBranch)expression2.getBranches().get(1)).getResult().accept((IrVisitor)this, (Object)context));
        }
        IrBranch lastBranch = (IrBranch)CollectionsKt.lastOrNull((List)expression2.getBranches());
        JsPrefixOperation implicitElse = lastBranch == null || !IrUtilsKt.isElseBranch((IrBranch)lastBranch) ? new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(0)) : null;
        boolean bl2 = bl = implicitElse == null || IrTypePredicatesKt.isUnit((IrType)expression2.getType());
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Non unit when-expression must have else branch";
            throw new AssertionError((Object)string);
        }
        JsNode jsNode = JsAstUtilsKt.toJsNode(expression2, this, context, visitWhen.2.INSTANCE, (JsNode)implicitElse);
        Intrinsics.checkNotNull((Object)jsNode);
        return (JsExpression)jsNode;
    }

    @NotNull
    public JsExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()] != 1) {
            CompilationExceptionKt.compilationException((String)"All type operator calls except REINTERPRET_CAST should be lowered at this point", (IrElement)((IrElement)expression2));
            throw new KotlinNothingValueException();
        }
        return (JsExpression)JsAstUtilsKt.withSource$default((JsExpression)expression2.getArgument().accept((IrVisitor)this, (Object)data), (IrElement)expression2, data, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull JsGenerationContext data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return (JsExpression)JsAstUtilsKt.withSource$default(JsAstUtilsKt.jsElementAccess(expression2.getMemberName(), (JsExpression)expression2.getReceiver().accept((IrVisitor)this, (Object)data)), (IrElement)expression2, data, null, null, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public JsExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull JsGenerationContext data) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                jsExpression = this.prefixOperation(JsUnaryOperator.POS, expression2, data);
                break;
            }
            case 2: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NEG, expression2, data);
                break;
            }
            case 3: {
                jsExpression = this.prefixOperation(JsUnaryOperator.NOT, expression2, data);
                break;
            }
            case 4: {
                jsExpression = this.prefixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 5: {
                jsExpression = this.prefixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 6: {
                jsExpression = this.postfixOperation(JsUnaryOperator.INC, expression2, data);
                break;
            }
            case 7: {
                jsExpression = this.postfixOperation(JsUnaryOperator.DEC, expression2, data);
                break;
            }
            case 8: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ADD, expression2, data);
                break;
            }
            case 9: {
                jsExpression = this.binaryOperation(JsBinaryOperator.SUB, expression2, data);
                break;
            }
            case 10: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MUL, expression2, data);
                break;
            }
            case 11: {
                jsExpression = this.binaryOperation(JsBinaryOperator.DIV, expression2, data);
                break;
            }
            case 12: {
                jsExpression = this.binaryOperation(JsBinaryOperator.MOD, expression2, data);
                break;
            }
            case 13: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GT, expression2, data);
                break;
            }
            case 14: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LT, expression2, data);
                break;
            }
            case 15: {
                jsExpression = this.binaryOperation(JsBinaryOperator.GTE, expression2, data);
                break;
            }
            case 16: {
                jsExpression = this.binaryOperation(JsBinaryOperator.LTE, expression2, data);
                break;
            }
            case 17: {
                jsExpression = this.binaryOperation(JsBinaryOperator.EQ, expression2, data);
                break;
            }
            case 18: {
                jsExpression = this.binaryOperation(JsBinaryOperator.NEQ, expression2, data);
                break;
            }
            case 19: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_EQ, expression2, data);
                break;
            }
            case 20: {
                jsExpression = this.binaryOperation(JsBinaryOperator.REF_NEQ, expression2, data);
                break;
            }
            case 21: {
                jsExpression = this.binaryOperation(JsBinaryOperator.AND, expression2, data);
                break;
            }
            case 22: {
                jsExpression = this.binaryOperation(JsBinaryOperator.OR, expression2, data);
                break;
            }
            case 23: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG, expression2, data);
                break;
            }
            case 24: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_ADD, expression2, data);
                break;
            }
            case 25: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_SUB, expression2, data);
                break;
            }
            case 26: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MUL, expression2, data);
                break;
            }
            case 27: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_DIV, expression2, data);
                break;
            }
            case 28: {
                jsExpression = this.binaryOperation(JsBinaryOperator.ASG_MOD, expression2, data);
                break;
            }
            case 29: {
                jsExpression = new JsArrayAccess((JsExpression)IrExpressionsKt.getLeft((IrDynamicOperatorExpression)expression2).accept((IrVisitor)this, (Object)data), (JsExpression)IrExpressionsKt.getRight((IrDynamicOperatorExpression)expression2).accept((IrVisitor)this, (Object)data));
                break;
            }
            case 30: {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                Collection collection = expression2.getArguments();
                JsExpression jsExpression2 = (JsExpression)expression2.getReceiver().accept((IrVisitor)this, (Object)data);
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrExpression irExpression = (IrExpression)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add((JsExpression)it.accept((IrVisitor)this, (Object)data));
                }
                List list = org.jetbrains.kotlin.utils.CollectionsKt.compactIfPossible((List)((List)destination$iv$iv));
                JsExpression jsExpression3 = jsExpression2;
                jsExpression = new JsInvocation(jsExpression3, list);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return (JsExpression)JsAstUtilsKt.withSource$default(jsExpression, (IrElement)expression2, data, null, null, 12, null);
    }

    @NotNull
    public JsExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull JsGenerationContext data) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrFunction function2 = expression2.getSymbol().getOwner();
        if (function2 instanceof IrConstructor) {
            jsExpression = IrTypeUtilsKt.getConstructorRef((IrConstructor)function2, data.getStaticContext());
        } else if (function2 instanceof IrSimpleFunction) {
            JsNameRef jsNameRef = data.getNameForStaticFunction((IrSimpleFunction)function2).makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            jsExpression = jsNameRef;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JsExpression name = jsExpression;
        return (JsExpression)JsAstUtilsKt.withSource$default(name, (IrElement)expression2, data, null, null, 12, null);
    }

    private final JsPrefixOperation prefixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPrefixOperation(operator, (JsExpression)expression2.getReceiver().accept((IrVisitor)this, (Object)data));
    }

    private final JsPostfixOperation postfixOperation(JsUnaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsPostfixOperation(operator, (JsExpression)expression2.getReceiver().accept((IrVisitor)this, (Object)data));
    }

    private final JsBinaryOperation binaryOperation(JsBinaryOperator operator, IrDynamicOperatorExpression expression2, JsGenerationContext data) {
        return new JsBinaryOperation(operator, (JsExpression)IrExpressionsKt.getLeft((IrDynamicOperatorExpression)expression2).accept((IrVisitor)this, (Object)data), (JsExpression)IrExpressionsKt.getRight((IrDynamicOperatorExpression)expression2).accept((IrVisitor)this, (Object)data));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isThisReceiver(IrValueDeclaration $this$isThisReceiver) {
        if ($this$isThisReceiver instanceof IrVariable) return false;
        IrDeclarationParent p = $this$isThisReceiver.getParent();
        if (p instanceof IrSimpleFunction) {
            if ($this$isThisReceiver != ((IrSimpleFunction)p).getDispatchReceiverParameter()) return false;
            return true;
        }
        if (!(p instanceof IrClass)) return false;
        if ($this$isThisReceiver != ((IrClass)p).getThisReceiver()) return false;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrDynamicOperator.values().length];
            try {
                nArray[IrDynamicOperator.UNARY_PLUS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.UNARY_MINUS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PREFIX_INCREMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PREFIX_DECREMENT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.POSTFIX_INCREMENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.POSTFIX_DECREMENT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.BINARY_PLUS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.BINARY_MINUS.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MUL.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.DIV.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MOD.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.GT.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.LT.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.GE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.LE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQEQ.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCLEQ.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQEQEQ.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EXCLEQEQ.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.ANDAND.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.OROR.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.EQ.ordinal()] = 23;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.PLUSEQ.ordinal()] = 24;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MINUSEQ.ordinal()] = 25;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MULEQ.ordinal()] = 26;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.DIVEQ.ordinal()] = 27;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.MODEQ.ordinal()] = 28;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.ARRAY_ACCESS.ordinal()] = 29;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrDynamicOperator.INVOKE.ordinal()] = 30;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

