/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index.archetype;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.search.Query;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.FlatSearchRequest;
import org.sonatype.nexus.index.FlatSearchResponse;
import org.sonatype.nexus.index.NexusIndexer;
import org.sonatype.nexus.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ArchetypeDataSource.class, hint="nexus")
public class NexusArchetypeDataSource
extends AbstractLogEnabled
implements ArchetypeDataSource {
    @Requirement
    private NexusIndexer indexer;

    public ArchetypeCatalog getArchetypeCatalog(Properties properties) throws ArchetypeDataSourceException {
        ArchetypeCatalog catalog = new ArchetypeCatalog();
        try {
            Map<String, String> repositories = this.getRepositoryMap();
            Query pq = this.indexer.constructQuery(ArtifactInfo.PACKAGING, "^maven-archetype$");
            FlatSearchRequest searchRequest = new FlatSearchRequest(pq);
            FlatSearchResponse searchResponse = this.indexer.searchFlat(searchRequest);
            for (ArtifactInfo info : searchResponse.getResults()) {
                Archetype archetype = new Archetype();
                archetype.setGroupId(info.groupId);
                archetype.setArtifactId(info.artifactId);
                archetype.setVersion(info.version);
                archetype.setDescription(info.description);
                archetype.setRepository(repositories.get(info.repository));
                catalog.addArchetype(archetype);
            }
        }
        catch (Exception ex) {
            this.getLogger().error("Unable to retrieve archetypes", (Throwable)ex);
        }
        return catalog;
    }

    private Map<String, String> getRepositoryMap() {
        HashMap<String, String> repositories = new HashMap<String, String>();
        for (IndexingContext context : this.indexer.getIndexingContexts().values()) {
            String repositoryUrl = context.getRepositoryUrl();
            if (repositoryUrl == null) continue;
            repositories.put(context.getId(), repositoryUrl);
        }
        return repositories;
    }

    public void updateCatalog(Properties properties, Archetype archetype) {
    }
}

