/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DataGridBundle;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.view.editors.DataGridEditorUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBListTable;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvRecordFormatForm
implements Disposable {
    public static final List<LazyPair<String>> DELIMITERS = List.of(new LazyPair<String>("\n", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.newline", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.newline.lowercase", (Object[])new Object[0])), new LazyPair<String>(" ", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.space", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.space.lowercase", (Object[])new Object[0])), new LazyPair<String>("\t", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.tab", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.tab.lowercase", (Object[])new Object[0])), new LazyPair<String>(",", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.comma", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.comma.lowercase", (Object[])new Object[0])), new LazyPair<String>(";", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.semicolon", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.semicolon.lowercase", (Object[])new Object[0])), new LazyPair<String>("|", DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.pipe", (Object[])new Object[0]), DataGridBundle.messagePointer((String)"csv.format.settings.delimiter.pipe.lowercase", (Object[])new Object[0])));
    private static final List<LazyPair<String>> NULL_TEXT_VARIANTS = List.of(new LazyPair<Object>(DataGridBundle.messagePointer((String)"csv.format.settings.null.text.undefined", (Object[])new Object[0]), null), new LazyPair<String>(DataGridBundle.messagePointer((String)"csv.format.settings.null.text.empty.string", (Object[])new Object[0]), ""), new LazyPair<String>(() -> "\\N", "\\N"));
    private static final List<LazyPair<CsvRecordFormat.QuotationPolicy>> QUOTATION_POLICIES = List.of(new LazyPair<CsvRecordFormat.QuotationPolicy>(DataGridBundle.messagePointer((String)"csv.format.settings.quotation.policy.never", (Object[])new Object[0]), CsvRecordFormat.QuotationPolicy.NEVER), new LazyPair<CsvRecordFormat.QuotationPolicy>(DataGridBundle.messagePointer((String)"csv.format.settings.quotation.policy.when.needed", (Object[])new Object[0]), CsvRecordFormat.QuotationPolicy.AS_NEEDED), new LazyPair<CsvRecordFormat.QuotationPolicy>(DataGridBundle.messagePointer((String)"csv.format.settings.quotation.policy.always", (Object[])new Object[0]), CsvRecordFormat.QuotationPolicy.ALWAYS));
    private JPanel myPanel;
    private JBCheckBox myTrimWhitespaceCheckBox;
    private JBTextField myRecordPrefixTextField;
    private JBTextField myRecordSuffixTextField;
    private ComboBox<String> myNullTextCombo;
    private ComboBox<String> myValueSeparatorComboBox;
    private ComboBox<String> myRecordSeparatorComboBox;
    private ComboBox<String> myQuotationPolicyComboBox;
    private JPanel myRowPrefixSuffixPanel;
    private ActionLink myAddRowPrefixSuffixActionLink;
    private JPanel myQuotesTablePanel;
    private JBLabel myQuotationLabel;
    private QuotesListTable myQuotesTable;
    private boolean myResetting;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public CsvRecordFormatForm(@NotNull Disposable parent) {
        if (parent == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myQuotesTablePanel.add(DataGridEditorUtil.labeledDecorator((JComponent)this.myQuotationLabel, this.myQuotesTable.getTable()));
        ItemListener fireFormatChangedOnItemUpdate = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        };
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                CsvRecordFormatForm.this.fireFormatChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvRecordFormatForm$2", "textChanged"));
            }
        };
        CsvRecordFormatForm.prepareComboBox(this.myRecordSeparatorComboBox, DELIMITERS, (DocumentListener)documentAdapter);
        CsvRecordFormatForm.prepareComboBox(this.myValueSeparatorComboBox, DELIMITERS, (DocumentListener)documentAdapter);
        CsvRecordFormatForm.prepareComboBox(this.myQuotationPolicyComboBox, QUOTATION_POLICIES, (DocumentListener)documentAdapter);
        CsvRecordFormatForm.prepareComboBox(this.myNullTextCombo, NULL_TEXT_VARIANTS, (DocumentListener)documentAdapter);
        this.myTrimWhitespaceCheckBox.addItemListener(fireFormatChangedOnItemUpdate);
        DocumentAdapter fireFormatChangeOnTextUpdate = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                CsvRecordFormatForm.this.fireFormatChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/csv/ui/CsvRecordFormatForm$3", "textChanged"));
            }
        };
        this.myRecordPrefixTextField.getDocument().addDocumentListener((DocumentListener)fireFormatChangeOnTextUpdate);
        this.myRecordSuffixTextField.getDocument().addDocumentListener((DocumentListener)fireFormatChangeOnTextUpdate);
        this.setRowPrefixSuffixVisible(false);
        this.myQuotationPolicyComboBox.addItemListener(fireFormatChangedOnItemUpdate);
    }

    private void createUIComponents() {
        this.myQuotesTable = new QuotesListTable(this);
        this.myQuotesTable.getTable().getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CsvRecordFormatForm.this.fireFormatChanged();
            }
        });
        this.myAddRowPrefixSuffixActionLink = new ActionLink("", e -> this.setRowPrefixSuffixVisible(true));
        this.myAddRowPrefixSuffixActionLink.setBorder((Border)JBUI.Borders.emptyTop((int)4));
    }

    public void reset(@NotNull CsvRecordFormat recordFormat) {
        if (recordFormat == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(1);
        }
        this.myResetting = true;
        try {
            CsvRecordFormatForm.selectInCombo(this.myRecordSeparatorComboBox, DELIMITERS, recordFormat.recordSeparator);
            CsvRecordFormatForm.selectInCombo(this.myValueSeparatorComboBox, DELIMITERS, recordFormat.valueSeparator);
            CsvRecordFormatForm.selectInCombo(this.myNullTextCombo, NULL_TEXT_VARIANTS, recordFormat.nullText);
            this.myTrimWhitespaceCheckBox.setSelected(recordFormat.trimWhitespace);
            CsvRecordFormatForm.selectInCombo(this.myQuotationPolicyComboBox, QUOTATION_POLICIES, recordFormat.quotationPolicy);
            this.myQuotesTable.setQuotes(recordFormat.quotes);
            this.myRecordPrefixTextField.setText(recordFormat.prefix);
            this.myRecordSuffixTextField.setText(recordFormat.suffix);
            this.setRowPrefixSuffixVisible(StringUtil.isNotEmpty((String)recordFormat.prefix) || StringUtil.isNotEmpty((String)recordFormat.suffix));
        }
        finally {
            this.myResetting = false;
            this.fireFormatChanged();
        }
    }

    @NotNull
    public CsvRecordFormat getFormat() {
        String rowSeparator = Objects.requireNonNull((String)CsvRecordFormatForm.selectedInCombo(this.myRecordSeparatorComboBox, DELIMITERS));
        String valueSeparator = Objects.requireNonNull((String)CsvRecordFormatForm.selectedInCombo(this.myValueSeparatorComboBox, DELIMITERS));
        String nullText = (String)CsvRecordFormatForm.selectedInCombo(this.myNullTextCombo, NULL_TEXT_VARIANTS);
        boolean trimWhitespace = this.myTrimWhitespaceCheckBox.isSelected();
        List<CsvRecordFormat.Quotes> quotes = this.myQuotesTable.getQuotes();
        CsvRecordFormat.QuotationPolicy quotationPolicy = Objects.requireNonNull((CsvRecordFormat.QuotationPolicy)CsvRecordFormatForm.selectedInCombo(this.myQuotationPolicyComboBox, QUOTATION_POLICIES));
        String prefix = this.myRecordPrefixTextField.getText();
        String suffix = this.myRecordSuffixTextField.getText();
        return new CsvRecordFormat(prefix, suffix, nullText, quotes, quotationPolicy, valueSeparator, rowSeparator, trimWhitespace);
    }

    @NotNull
    public JPanel getMainPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public void addChangeListener(@NotNull ChangeListener listener) {
        if (listener == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(3);
        }
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void dispose() {
    }

    private void fireFormatChanged() {
        if (!this.myResetting) {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).recordFormatChanged(this);
        }
    }

    private void setRowPrefixSuffixVisible(boolean visible) {
        this.myAddRowPrefixSuffixActionLink.setVisible(!visible);
        this.myRowPrefixSuffixPanel.setVisible(visible);
    }

    @Nullable
    private static <V, P extends LazyPair<V>> V selectedInCombo(@NotNull ComboBox<String> combobox, @NotNull List<P> mappings) {
        if (combobox == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(4);
        }
        if (mappings == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(5);
        }
        Object selected = combobox.isEditable() ? combobox.getEditor().getItem() : combobox.getSelectedItem();
        LazyPair mapping = (LazyPair)ContainerUtil.find(mappings, pair -> pair.uiName.get().equals(selected));
        return (V)(mapping == null ? selected : mapping.value);
    }

    private static <V, P extends LazyPair<V>> void selectInCombo(@NotNull ComboBox<String> combo, @NotNull List<P> mappings, @Nullable V what) {
        LazyPair mapping;
        if (combo == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(6);
        }
        if (mappings == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(7);
        }
        if ((mapping = (LazyPair)ContainerUtil.find(mappings, pair -> Objects.equals(pair.value, what))) == null) {
            if (what != null) {
                combo.setSelectedItem(what);
            }
            return;
        }
        combo.setSelectedItem((Object)mapping.uiName.get());
    }

    private static void prepareComboBox(@NotNull ComboBox<String> combo, @NotNull List<? extends LazyPair<?>> mappings, @NotNull DocumentListener documentListener) {
        if (combo == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(8);
        }
        if (mappings == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(9);
        }
        if (documentListener == null) {
            CsvRecordFormatForm.$$$reportNull$$$0(10);
        }
        combo.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList(ContainerUtil.map(mappings, pair -> pair.uiName.get()))));
        Component component = combo.getEditor().getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(documentListener);
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        ComboBox comboBox2;
        JBLabel jBLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JBTextField jBTextField;
        JBTextField jBTextField2;
        JPanel jPanel2;
        ComboBox comboBox3;
        ComboBox comboBox4;
        JPanel jPanel3;
        this.createUIComponents();
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.value.separator"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myValueSeparatorComboBox = comboBox4 = new ComboBox();
        comboBox4.setEditable(true);
        jPanel3.add((Component)comboBox4, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.row.separator"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordSeparatorComboBox = comboBox3 = new ComboBox();
        comboBox3.setEditable(true);
        jPanel3.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 2, 6, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(7, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myRowPrefixSuffixPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.row.prefix"));
        jPanel2.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordPrefixTextField = jBTextField2 = new JBTextField();
        jBTextField2.setColumns(3);
        jBTextField2.setText("");
        jPanel2.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.row.suffix"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRecordSuffixTextField = jBTextField = new JBTextField();
        jBTextField.setColumns(3);
        jBTextField.setText("");
        jPanel2.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        ActionLink actionLink = this.myAddRowPrefixSuffixActionLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.add.row.prefix.suffix"));
        jPanel3.add((Component)actionLink, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTrimWhitespaceCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.trim.whitespaces"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.null.value.text"));
        jPanel3.add((Component)jBLabel6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), null, 0, 0, null, null));
        this.myQuotesTablePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(0, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        this.myQuotationLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.quotation"));
        jPanel.add((Component)jBLabel, "North");
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/DataGridBundle", CsvRecordFormatForm.class).getString("settings.quote.values"));
        jPanel4.add((Component)jBLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myQuotationPolicyComboBox = comboBox2 = new ComboBox();
        jPanel4.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, new Dimension(1, -1), null));
        this.myNullTextCombo = comboBox = new ComboBox();
        comboBox.setEditable(true);
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 4, 0, null, new Dimension(1, -1), null));
        jBLabel2.setLabelFor((Component)comboBox4);
        jBLabel3.setLabelFor((Component)comboBox3);
        jBLabel4.setLabelFor((Component)jBTextField2);
        jBLabel5.setLabelFor((Component)jBTextField);
        jBLabel6.setLabelFor((Component)comboBox);
        jBLabel7.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordFormat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/csv/ui/CsvRecordFormatForm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combobox";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/csv/ui/CsvRecordFormatForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectedInCombo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectInCombo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareComboBox";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static interface ChangeListener
    extends EventListener {
        public void recordFormatChanged(@NotNull CsvRecordFormatForm var1);
    }

    private static class QuotesListTable
    extends JBListTable {
        private final QuotesTable.QuotesRowRenderer myRenderer;
        private final QuotesTable.QuotesRowEditor myEditor;

        QuotesListTable(@NotNull Disposable parent) {
            if (parent == null) {
                QuotesListTable.$$$reportNull$$$0(0);
            }
            super((JBTable)new QuotesTable(), parent);
            this.myRenderer = new QuotesTable.QuotesRowRenderer(parent);
            this.myEditor = new QuotesTable.QuotesRowEditor();
            this.getTable().addPropertyChangeListener("tableCellEditor", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TableCellEditor cellEditor = (TableCellEditor)ObjectUtils.tryCast((Object)evt.getNewValue(), TableCellEditor.class);
                    if (cellEditor != null) {
                        myEditor.editingStarted(cellEditor);
                    }
                }
            });
            JComponent c2 = this.myEditor.getComponent();
            int width = c2.getPreferredSize().width + UIUtil.getScrollBarWidth();
            this.getTable().setPreferredScrollableViewportSize((Dimension)JBUI.size((int)width, (int)-1));
            this.getTable().setVisibleRowCount(5);
            this.getTable().setShowGrid(false);
        }

        @NotNull
        public List<CsvRecordFormat.Quotes> getQuotes() {
            List<CsvRecordFormat.Quotes> list = this.quotesTable().getQuotes();
            if (list == null) {
                QuotesListTable.$$$reportNull$$$0(1);
            }
            return list;
        }

        public void setQuotes(@NotNull List<CsvRecordFormat.Quotes> quotes) {
            if (quotes == null) {
                QuotesListTable.$$$reportNull$$$0(2);
            }
            this.quotesTable().setQuotes(quotes);
        }

        protected JBTableRowRenderer getRowRenderer(int row) {
            return this.myRenderer;
        }

        protected JBTableRowEditor getRowEditor(int row) {
            this.myEditor.prepareEditor((JTable)this.myInternalTable, row);
            return new DataGridEditorUtil.JBTableRowEditorWrapper<QuotesTable.QuotesRowEditor>(this.myEditor){

                public JBTableRow getValue() {
                    return myEditor.getValue();
                }
            };
        }

        @NotNull
        private QuotesTable quotesTable() {
            QuotesTable quotesTable = (QuotesTable)this.myInternalTable;
            if (quotesTable == null) {
                QuotesListTable.$$$reportNull$$$0(3);
            }
            return quotesTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quotes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuotes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "quotesTable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setQuotes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 3 -> new IllegalStateException(string);
            };
        }

        private static class QuotesTable
        extends JBTable {
            private static final Supplier<@Nls String> DUPLICATE_ESCAPE_METHOD = DataGridBundle.messagePointer((String)"csv.format.settings.quotation.policy.escape.duplicate", (Object[])new Object[0]);
            static final MyColumnInfo LEFT_QUOTE_COLUMN = new MyColumnInfo(DataGridBundle.message((String)"settings.column.left.quote", (Object[])new Object[0]), 0);
            static final MyColumnInfo RIGHT_QUOTE_COLUMN = new MyColumnInfo(DataGridBundle.message((String)"settings.column.right.quote", (Object[])new Object[0]), 1);
            static final MyColumnInfo ESCAPE_METHOD_COLUMN = new MyColumnInfo(DataGridBundle.message((String)"settings.escape.method", (Object[])new Object[0]), 2);

            QuotesTable() {
                super((TableModel)new ListTableModel<String[]>(new ColumnInfo[]{LEFT_QUOTE_COLUMN, RIGHT_QUOTE_COLUMN, ESCAPE_METHOD_COLUMN}){

                    public void addRow() {
                        this.addRow(new String[]{"'", "'", DUPLICATE_ESCAPE_METHOD.get()});
                    }
                });
            }

            /*
             * Exception decompiling
             */
            public void setQuotes(@NotNull List<CsvRecordFormat.Quotes> quotesList) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * java.lang.UnsupportedOperationException
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public List<CsvRecordFormat.Quotes> getQuotes() {
                List list = ContainerUtil.mapNotNull((Collection)QuotesTable.model((JTable)((Object)this)).getItems(), aspects -> {
                    String left = LEFT_QUOTE_COLUMN.valueOf((String[])aspects);
                    String right = RIGHT_QUOTE_COLUMN.valueOf((String[])aspects);
                    String escapeMethod = ESCAPE_METHOD_COLUMN.valueOf((String[])aspects);
                    if (StringUtil.isEmpty((String)left) || StringUtil.isEmpty((String)right) || StringUtil.isEmpty((String)escapeMethod)) {
                        return null;
                    }
                    return DUPLICATE_ESCAPE_METHOD.get().equalsIgnoreCase(escapeMethod) ? new CsvRecordFormat.Quotes(left, right, left + left, right + right) : new CsvRecordFormat.Quotes(left, right, escapeMethod + left, escapeMethod + right);
                });
                if (list == null) {
                    QuotesTable.$$$reportNull$$$0(1);
                }
                return list;
            }

            @NotNull
            private static String escapeMethod(@NotNull CsvRecordFormat.Quotes quotes) {
                if (quotes == null) {
                    QuotesTable.$$$reportNull$$$0(2);
                }
                String string = StringUtil.equals((CharSequence)(quotes.leftQuote + quotes.leftQuote), (CharSequence)quotes.leftQuoteEscaped) && StringUtil.equals((CharSequence)(quotes.rightQuote + quotes.rightQuote), (CharSequence)quotes.rightQuoteEscaped) ? DUPLICATE_ESCAPE_METHOD.get() : StringUtil.trimEnd((String)quotes.leftQuoteEscaped, (String)quotes.leftQuote);
                if (string == null) {
                    QuotesTable.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            private static ListTableModel<String[]> model(@NotNull JTable t) {
                if (t == null) {
                    QuotesTable.$$$reportNull$$$0(4);
                }
                ListTableModel listTableModel = (ListTableModel)t.getModel();
                if (listTableModel == null) {
                    QuotesTable.$$$reportNull$$$0(5);
                }
                return listTableModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "quotesList";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "quotes";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "t";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getQuotes";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "escapeMethod";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "model";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "setQuotes";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "escapeMethod";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "model";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 5 -> new IllegalStateException(string);
                };
            }

            private static class MyColumnInfo
            extends ColumnInfo<String[], String> {
                private final int myIndex;

                MyColumnInfo(@NlsContexts.ColumnName @NotNull String name, int index) {
                    if (name == null) {
                        MyColumnInfo.$$$reportNull$$$0(0);
                    }
                    super(name);
                    this.myIndex = index;
                }

                @Nls
                @Nullable
                public String valueOf(String @Nls [] aspects) {
                    return aspects[this.myIndex];
                }

                public void setValue(String @Nls [] strings, @Nls String value) {
                    strings[this.myIndex] = value;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$MyColumnInfo", "<init>"));
                }
            }

            static class QuotesRowEditor
            extends DataGridEditorUtil.EmbeddableEditorAdapter {
                private JPanel myPanel;
                private JBTextField myLeftQuoteTextField;
                private JBTextField myRightQuoteTextField;
                private ComboBox<String> myEscapeMethodComboBox;

                QuotesRowEditor() {
                    this.$$$setupUI$$$();
                    this.myLeftQuoteTextField.setColumns(4);
                    this.myRightQuoteTextField.setColumns(4);
                    this.myEscapeMethodComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{DUPLICATE_ESCAPE_METHOD.get()}));
                    this.myEscapeMethodComboBox.setEditable(true);
                }

                @Override
                @NotNull
                public JComponent getComponent() {
                    JPanel jPanel = this.myPanel;
                    if (jPanel == null) {
                        QuotesRowEditor.$$$reportNull$$$0(0);
                    }
                    return jPanel;
                }

                void prepareEditor(JTable table2, int row) {
                    String[] aspects = (String[])QuotesTable.model(table2).getItem(row);
                    this.myLeftQuoteTextField.setText(LEFT_QUOTE_COLUMN.valueOf(aspects));
                    this.myRightQuoteTextField.setText(RIGHT_QUOTE_COLUMN.valueOf(aspects));
                    this.myEscapeMethodComboBox.setSelectedItem((Object)ESCAPE_METHOD_COLUMN.valueOf(aspects));
                }

                JBTableRow getValue() {
                    return new JBTableRow(){

                        public Object getValueAt(int column) {
                            return switch (column) {
                                case 0 -> myLeftQuoteTextField.getText();
                                case 1 -> myRightQuoteTextField.getText();
                                case 2 -> myEscapeMethodComboBox.getEditor().getItem();
                                default -> throw new AssertionError();
                            };
                        }
                    };
                }

                @Override
                @NotNull
                public JComponent getPreferredFocusedComponent() {
                    JBTextField jBTextField = this.myLeftQuoteTextField;
                    if (jBTextField == null) {
                        QuotesRowEditor.$$$reportNull$$$0(1);
                    }
                    return jBTextField;
                }

                @Override
                public JComponent @NotNull [] getFocusableComponents() {
                    JComponent[] jComponentArray = new JComponent[]{this.myLeftQuoteTextField, this.myRightQuoteTextField, this.myEscapeMethodComboBox};
                    if (jComponentArray == null) {
                        QuotesRowEditor.$$$reportNull$$$0(2);
                    }
                    return jComponentArray;
                }

                void editingStarted(@NotNull TableCellEditor editor) {
                    if (editor == null) {
                        QuotesRowEditor.$$$reportNull$$$0(3);
                    }
                    ComboBox.registerTableCellEditor(this.myEscapeMethodComboBox, (TableCellEditor)editor);
                }

                private /* synthetic */ void $$$setupUI$$$() {
                    ComboBox comboBox;
                    JBTextField jBTextField;
                    JBTextField jBTextField2;
                    JPanel jPanel;
                    this.myPanel = jPanel = new JPanel();
                    jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
                    JBLabel jBLabel = new JBLabel();
                    this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DataGridBundle", QuotesRowEditor.class).getString("csv.format.settings.quotes.left"));
                    jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
                    Spacer spacer = new Spacer();
                    jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
                    this.myLeftQuoteTextField = jBTextField2 = new JBTextField();
                    jPanel.add((Component)jBTextField2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
                    JBLabel jBLabel2 = new JBLabel();
                    this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DataGridBundle", QuotesRowEditor.class).getString("csv.format.settings.quotes.right"));
                    jPanel.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 1, 0, 0, null, null, null));
                    this.myRightQuoteTextField = jBTextField = new JBTextField();
                    jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
                    JBLabel jBLabel3 = new JBLabel();
                    this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DataGridBundle", QuotesRowEditor.class).getString("csv.format.settings.quotes.escape"));
                    jPanel.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, null, null));
                    this.myEscapeMethodComboBox = comboBox = new ComboBox();
                    jPanel.add((Component)comboBox, new GridConstraints(1, 2, 1, 1, 0, 1, 2, 0, null, null, null));
                }

                public /* synthetic */ JComponent $$$getRootComponent$$$() {
                    return this.myPanel;
                }

                private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl = false;
                    char c2 = '\u0000';
                    int n = -1;
                    for (int i = 0; i < string.length(); ++i) {
                        if (string.charAt(i) == '&') {
                            if (++i == string.length()) break;
                            if (!bl && string.charAt(i) != '&') {
                                bl = true;
                                c2 = string.charAt(i);
                                n = stringBuffer.length();
                            }
                        }
                        stringBuffer.append(string.charAt(i));
                    }
                    jLabel.setText(stringBuffer.toString());
                    if (bl) {
                        jLabel.setDisplayedMnemonic(c2);
                        jLabel.setDisplayedMnemonicIndex(n);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 3 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "editor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getComponent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPreferredFocusedComponent";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getFocusableComponents";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowEditor";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 3: {
                            objectArray = objectArray;
                            objectArray[2] = "editingStarted";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 3 -> new IllegalArgumentException(string);
                    };
                }
            }

            static class QuotesRowRenderer
            extends EditorTextFieldJBTableRowRenderer {
                protected QuotesRowRenderer(@NotNull Disposable parent) {
                    if (parent == null) {
                        QuotesRowRenderer.$$$reportNull$$$0(0);
                    }
                    super(null, parent);
                }

                protected String getText(JTable table2, int row) {
                    String[] aspects = (String[])QuotesTable.model(table2).getItem(row);
                    String escapeMethod = ESCAPE_METHOD_COLUMN.valueOf(aspects);
                    String escapeMethodText = DUPLICATE_ESCAPE_METHOD.get().equals(escapeMethod) ? DataGridBundle.message((String)"csv.format.settings.quotation.policy.escape.duplicate.renderer.text", (Object[])new Object[0]) : DataGridBundle.message((String)"csv.format.settings.quotation.policy.escape.pattern", (Object[])new Object[]{escapeMethod == null ? "<unknown>" : escapeMethod});
                    String leftQuoteText = LEFT_QUOTE_COLUMN.valueOf(aspects);
                    String rightQuoteText = RIGHT_QUOTE_COLUMN.valueOf(aspects);
                    return StringUtil.join((String[])new String[]{leftQuoteText, rightQuoteText, escapeMethodText}, (String)"  ");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvRecordFormatForm$QuotesListTable$QuotesTable$QuotesRowRenderer", "<init>"));
                }
            }
        }
    }

    public static class LazyPair<T> {
        public final Supplier<@Nls String> uiName;
        public final Supplier<@Nls String> uiNameLowercase;
        public final T value;

        LazyPair(@NotNull Supplier<@Nls String> uiName, @Nullable T value) {
            if (uiName == null) {
                LazyPair.$$$reportNull$$$0(0);
            }
            this(value, uiName, null);
        }

        LazyPair(@Nullable T value, @NotNull Supplier<@Nls String> uiName, @Nullable Supplier<@Nls String> uiNameLowercase) {
            if (uiName == null) {
                LazyPair.$$$reportNull$$$0(1);
            }
            this.value = value;
            this.uiName = uiName;
            this.uiNameLowercase = uiNameLowercase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiName", "com/intellij/database/csv/ui/CsvRecordFormatForm$LazyPair", "<init>"));
        }
    }
}

