/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.util.Consumer;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GridWidget
implements StatusBarWidget,
CustomStatusBarWidget,
StatusBarWidget.TextPresentation {
    protected StatusBar myStatusBar;
    private CompletableFuture<@NlsContexts.Label String> myFuture;
    protected DataGrid myGrid;
    protected final Project myProject;
    private GridWidgetHelper myHelper;
    protected boolean myComponentShown;
    private FocusListener myFocusListener;
    private final LazyInitializer.LazyValue<TextPanel> myComponent;

    public GridWidget(@NotNull Project project) {
        if (project == null) {
            GridWidget.$$$reportNull$$$0(0);
        }
        this.myFuture = null;
        this.myComponent = LazyInitializer.create(() -> {
            TextPanel result = new TextPanel();
            this.installClickListener(result);
            return result;
        });
        this.myProject = project;
    }

    private void installClickListener(TextPanel result) {
        final Consumer clickConsumer = this.getClickConsumer();
        if (clickConsumer != null) {
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!e.isPopupTrigger() && 1 == e.getButton()) {
                        clickConsumer.consume((Object)e);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/datagrid/GridWidget$1", "onClick"));
                }
            }.installOn((Component)result, true);
        }
    }

    public JComponent getComponent() {
        return (JComponent)this.myComponent.get();
    }

    @NotNull
    protected abstract String getWidgetHelperKey();

    @NlsContexts.Label
    @NotNull
    public String getText() {
        boolean componentShown;
        GridWidget positionWidget = this.myStatusBar == null ? null : (GridWidget)ObjectUtils.tryCast((Object)this.myStatusBar.getWidget("GridPosition"), GridWidget.class);
        GridWidget aggregateWidget = this.myStatusBar == null ? null : (GridWidget)ObjectUtils.tryCast((Object)this.myStatusBar.getWidget("GridAggregator"), GridWidget.class);
        boolean bl = componentShown = positionWidget != null && positionWidget.myComponentShown || aggregateWidget != null && aggregateWidget.myComponentShown;
        if (this.myHelper == null || !componentShown && (this.myGrid == null || !this.myGrid.getResultView().getComponent().hasFocus())) {
            return "";
        }
        this.myFuture = this.myHelper.getText();
        this.myFuture.thenAccept(result -> ApplicationManager.getApplication().invokeLater(() -> {
            ((TextPanel)this.myComponent.get()).setText(result);
            ((TextPanel)this.myComponent.get()).setVisible(!StringUtil.isEmptyOrSpaces((String)result));
            this.myStatusBar.updateWidget(this.ID());
        }));
        String string = this.myFuture.getNow(DataGridBundle.message((String)"status.bar.grid.aggregator.widget.calculating", (Object[])new Object[0]));
        if (string == null) {
            GridWidget.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void install(final @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridWidget.$$$reportNull$$$0(2);
        }
        this.myStatusBar = statusBar;
        if (this.myGrid != null) {
            this.myGrid.getResultView().getComponent().removeFocusListener(this.myFocusListener);
            this.myGrid = null;
            this.myFocusListener = null;
        }
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(DataGrid.ACTIVE_GRID_CHANGED_TOPIC, (Object)new DataGrid.ActiveGridListener(){

            @Override
            public void changed(@NotNull DataGrid grid) {
                if (grid == null) {
                    2.$$$reportNull$$$0(0);
                }
                GridWidget.this.set(grid, statusBar);
            }

            @Override
            public void closed() {
                GridWidget.this.set(null, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridWidget$2", "changed"));
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                DataGrid grid = GridWidget.this.getDataGrid(statusBar);
                GridWidget.this.set(grid, statusBar);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/database/datagrid/GridWidget$3", "selectionChanged"));
            }
        });
        this.set(this.getDataGrid(statusBar), statusBar);
    }

    @Nullable
    private DataGrid getDataGrid(@NotNull StatusBar bar) {
        if (bar == null) {
            GridWidget.$$$reportNull$$$0(3);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        FileEditor fileEditor = StatusBarUtil.getCurrentFileEditor((StatusBar)bar);
        return fileEditor instanceof TableEditorBase ? ((TableEditorBase)fileEditor).getDataGrid() : null;
    }

    protected void set(@Nullable DataGrid grid, final @NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridWidget.$$$reportNull$$$0(4);
        }
        if (grid != null && !this.isOurGrid(grid, statusBar)) {
            return;
        }
        if (this.myGrid != grid) {
            if (this.myGrid != null) {
                this.myGrid.getResultView().getComponent().removeFocusListener(this.myFocusListener);
                this.myFocusListener = null;
            }
            this.myGrid = grid;
            if (this.myGrid != null) {
                this.myFocusListener = new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        GridWidget.this.update(statusBar);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        GridWidget.this.update(statusBar);
                    }
                };
                this.myGrid.getResultView().getComponent().addFocusListener(this.myFocusListener);
            }
            this.myHelper = grid == null ? null : (GridWidgetHelper)ObjectUtils.tryCast((Object)grid.getResultView().getComponent().getClientProperty(this.getWidgetHelperKey()), GridWidgetHelper.class);
        }
        this.update(statusBar);
    }

    private void update(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            GridWidget.$$$reportNull$$$0(5);
        }
        String text = this.getText();
        ((TextPanel)this.myComponent.get()).setText(text);
        ((TextPanel)this.myComponent.get()).setVisible(!StringUtil.isEmptyOrSpaces((String)text));
        statusBar.updateWidget(this.ID());
    }

    protected boolean isOurGrid(@NotNull DataGrid grid, @NotNull StatusBar bar) {
        if (grid == null) {
            GridWidget.$$$reportNull$$$0(6);
        }
        if (bar == null) {
            GridWidget.$$$reportNull$$$0(7);
        }
        return GridWidget.isOurComponent((JComponent)grid.getPanel().getComponent(), this.myProject, bar);
    }

    private static boolean isOurComponent(@NotNull JComponent component, @NotNull Project project, @NotNull StatusBar bar) {
        if (component == null) {
            GridWidget.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GridWidget.$$$reportNull$$$0(9);
        }
        if (bar == null) {
            GridWidget.$$$reportNull$$$0(10);
        }
        return WindowManager.getInstance().getStatusBar((Component)component, project) == bar;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridWidget";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridWidget";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDataGrid";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOurGrid";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOurComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static interface GridWidgetHelper {
        public @NotNull CompletableFuture<@NlsContexts.Label String> getText();
    }
}

