/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.coverage.org.objectweb.asm;

import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ByteVector;
import org.jetbrains.coverage.org.objectweb.asm.Symbol;
import org.jetbrains.coverage.org.objectweb.asm.SymbolTable;
import org.jetbrains.coverage.org.objectweb.asm.Type;
import org.jetbrains.coverage.org.objectweb.asm.TypePath;
import org.jetbrains.coverage.org.objectweb.asm.TypeReference;

final class AnnotationWriter
extends AnnotationVisitor {
    private final SymbolTable symbolTable;
    private final boolean useNamedValues;
    private final ByteVector annotation;
    private final int numElementValuePairsOffset;
    private int numElementValuePairs;
    private final AnnotationWriter previousAnnotation;
    private AnnotationWriter nextAnnotation;

    /*
     * WARNING - void declaration
     */
    AnnotationWriter(SymbolTable symbolTable, boolean useNamedValues, ByteVector annotation, AnnotationWriter previousAnnotation) {
        super(589824);
        void var3_3;
        void var2_2;
        void var1_1;
        this.symbolTable = var1_1;
        this.useNamedValues = var2_2;
        this.annotation = annotation;
        this.numElementValuePairsOffset = annotation.length == 0 ? -1 : var3_3.length - 2;
        this.previousAnnotation = previousAnnotation;
        if (previousAnnotation != null) {
            previousAnnotation.nextAnnotation = this;
        }
    }

    /*
     * WARNING - void declaration
     */
    static AnnotationWriter create(SymbolTable symbolTable, String descriptor, AnnotationWriter previousAnnotation) {
        void var2_2;
        void var3_3;
        SymbolTable symbolTable2;
        void var1_1;
        ByteVector annotation = new ByteVector();
        annotation.putShort(symbolTable.addConstantUtf8((String)var1_1)).putShort(0);
        return new AnnotationWriter(symbolTable2, true, (ByteVector)var3_3, (AnnotationWriter)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static AnnotationWriter create(SymbolTable symbolTable, int typeRef, TypePath typePath, String descriptor, AnnotationWriter previousAnnotation) {
        SymbolTable symbolTable2;
        void var3_3;
        void var2_2;
        void var1_1;
        ByteVector typeAnnotation = new ByteVector();
        TypeReference.putTarget((int)var1_1, typeAnnotation);
        TypePath.put((TypePath)var2_2, typeAnnotation);
        typeAnnotation.putShort(symbolTable.addConstantUtf8((String)var3_3)).putShort(0);
        return new AnnotationWriter(symbolTable2, true, typeAnnotation, previousAnnotation);
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(String name, Object value) {
        void var1_1;
        void var2_3;
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            this.annotation.putShort(this.symbolTable.addConstantUtf8(name));
        }
        if (value instanceof String) {
            this.annotation.put12(115, this.symbolTable.addConstantUtf8((String)value));
            return;
        }
        if (value instanceof Byte) {
            this.annotation.put12(66, this.symbolTable.addConstantInteger((int)((Byte)value).byteValue()).index);
            return;
        }
        if (value instanceof Boolean) {
            int booleanValue = (Boolean)value != false ? 1 : 0;
            this.annotation.put12(90, this.symbolTable.addConstantInteger((int)booleanValue).index);
            return;
        }
        if (value instanceof Character) {
            this.annotation.put12(67, this.symbolTable.addConstantInteger((int)((Character)value).charValue()).index);
            return;
        }
        if (value instanceof Short) {
            this.annotation.put12(83, this.symbolTable.addConstantInteger((int)((Short)value).shortValue()).index);
            return;
        }
        if (value instanceof Type) {
            this.annotation.put12(99, this.symbolTable.addConstantUtf8(((Type)value).getDescriptor()));
            return;
        }
        if (value instanceof byte[]) {
            byte[] byteArray = (byte[])value;
            this.annotation.put12(91, byteArray.length);
            for (byte byteValue : byteArray) {
                this.annotation.put12(66, this.symbolTable.addConstantInteger((int)byteValue).index);
            }
            return;
        }
        if (value instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])value;
            this.annotation.put12(91, booleanArray.length);
            for (boolean booleanValue : booleanArray) {
                this.annotation.put12(90, this.symbolTable.addConstantInteger((int)(booleanValue ? 1 : 0)).index);
            }
            return;
        }
        if (value instanceof short[]) {
            short[] shortArray = (short[])value;
            this.annotation.put12(91, shortArray.length);
            for (short shortValue : shortArray) {
                this.annotation.put12(83, this.symbolTable.addConstantInteger((int)shortValue).index);
            }
            return;
        }
        if (value instanceof char[]) {
            char[] charArray = (char[])value;
            this.annotation.put12(91, charArray.length);
            for (char charValue : charArray) {
                this.annotation.put12(67, this.symbolTable.addConstantInteger((int)charValue).index);
            }
            return;
        }
        if (value instanceof int[]) {
            int[] intArray = (int[])value;
            this.annotation.put12(91, intArray.length);
            for (int intValue : intArray) {
                this.annotation.put12(73, this.symbolTable.addConstantInteger((int)intValue).index);
            }
            return;
        }
        if (value instanceof long[]) {
            long[] longArray = (long[])value;
            this.annotation.put12(91, longArray.length);
            for (long longValue : longArray) {
                this.annotation.put12(74, this.symbolTable.addConstantLong((long)longValue).index);
            }
            return;
        }
        if (value instanceof float[]) {
            float[] floatArray = (float[])value;
            this.annotation.put12(91, floatArray.length);
            for (float floatValue : floatArray) {
                this.annotation.put12(70, this.symbolTable.addConstantFloat((float)floatValue).index);
            }
            return;
        }
        if (value instanceof double[]) {
            double[] doubleArray = (double[])value;
            this.annotation.put12(91, doubleArray.length);
            for (double doubleValue : doubleArray) {
                this.annotation.put12(68, this.symbolTable.addConstantDouble((double)doubleValue).index);
            }
            return;
        }
        Symbol symbol = this.symbolTable.addConstant(var2_3);
        this.annotation.put12(".s.IFJDCS".charAt(symbol.tag), var1_1.index);
    }

    /*
     * WARNING - void declaration
     */
    public final void visitEnum(String name, String descriptor, String value) {
        void var3_3;
        void var2_2;
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            void var1_1;
            this.annotation.putShort(this.symbolTable.addConstantUtf8((String)var1_1));
        }
        this.annotation.put12(101, this.symbolTable.addConstantUtf8((String)var2_2)).putShort(this.symbolTable.addConstantUtf8((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationVisitor visitAnnotation(String name, String descriptor) {
        void var2_2;
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            void var1_1;
            this.annotation.putShort(this.symbolTable.addConstantUtf8((String)var1_1));
        }
        this.annotation.put12(64, this.symbolTable.addConstantUtf8((String)var2_2)).putShort(0);
        return new AnnotationWriter(this.symbolTable, true, this.annotation, null);
    }

    /*
     * WARNING - void declaration
     */
    public final AnnotationVisitor visitArray(String name) {
        ++this.numElementValuePairs;
        if (this.useNamedValues) {
            void var1_1;
            this.annotation.putShort(this.symbolTable.addConstantUtf8((String)var1_1));
        }
        this.annotation.put12(91, 0);
        return new AnnotationWriter(this.symbolTable, false, this.annotation, null);
    }

    public final void visitEnd() {
        if (this.numElementValuePairsOffset != -1) {
            byte[] data = this.annotation.data;
            this.annotation.data[this.numElementValuePairsOffset] = (byte)(this.numElementValuePairs >>> 8);
            var1_1[this.numElementValuePairsOffset + 1] = (byte)this.numElementValuePairs;
        }
    }

    /*
     * WARNING - void declaration
     */
    final int computeAnnotationsSize(String attributeName) {
        void var1_2;
        if (attributeName != null) {
            this.symbolTable.addConstantUtf8(attributeName);
        }
        int attributeSize = 8;
        AnnotationWriter annotationWriter = this;
        while (annotationWriter != null) {
            attributeSize += annotationWriter.annotation.length;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        return (int)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static int computeAnnotationsSize(AnnotationWriter lastRuntimeVisibleAnnotation, AnnotationWriter lastRuntimeInvisibleAnnotation, AnnotationWriter lastRuntimeVisibleTypeAnnotation, AnnotationWriter lastRuntimeInvisibleTypeAnnotation) {
        int size = 0;
        if (lastRuntimeVisibleAnnotation != null) {
            AnnotationWriter annotationWriter;
            size = 0 + annotationWriter.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (lastRuntimeInvisibleAnnotation != null) {
            void var1_1;
            size += var1_1.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (lastRuntimeVisibleTypeAnnotation != null) {
            void var2_2;
            size += var2_2.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (lastRuntimeInvisibleTypeAnnotation != null) {
            void var3_3;
            size += var3_3.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        return size;
    }

    /*
     * WARNING - void declaration
     */
    final void putAnnotations(int attributeNameIndex, ByteVector output) {
        void var3_3;
        void var1_1;
        int attributeLength = 2;
        int numAnnotations = 0;
        AnnotationWriter annotationWriter = this;
        AnnotationWriter firstAnnotation = null;
        while (annotationWriter != null) {
            annotationWriter.visitEnd();
            attributeLength += annotationWriter.annotation.length;
            ++numAnnotations;
            firstAnnotation = annotationWriter;
            annotationWriter = annotationWriter.previousAnnotation;
        }
        output.putShort((int)var1_1);
        output.putInt((int)var3_3);
        output.putShort(numAnnotations);
        annotationWriter = firstAnnotation;
        while (annotationWriter != null) {
            output.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
            annotationWriter = annotationWriter.nextAnnotation;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void putAnnotations(SymbolTable symbolTable, AnnotationWriter lastRuntimeVisibleAnnotation, AnnotationWriter lastRuntimeInvisibleAnnotation, AnnotationWriter lastRuntimeVisibleTypeAnnotation, AnnotationWriter lastRuntimeInvisibleTypeAnnotation, ByteVector output) {
        if (lastRuntimeVisibleAnnotation != null) {
            void var1_1;
            var1_1.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), output);
        }
        if (lastRuntimeInvisibleAnnotation != null) {
            void var2_2;
            var2_2.putAnnotations(symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), output);
        }
        if (lastRuntimeVisibleTypeAnnotation != null) {
            void var3_3;
            var3_3.putAnnotations(symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), output);
        }
        if (lastRuntimeInvisibleTypeAnnotation != null) {
            SymbolTable symbolTable2;
            lastRuntimeInvisibleTypeAnnotation.putAnnotations(symbolTable2.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), output);
        }
    }

    /*
     * WARNING - void declaration
     */
    static int computeParameterAnnotationsSize(String attributeName, AnnotationWriter[] annotationWriters, int annotableParameterCount) {
        void var3_3;
        int attributeSize = 7 + 2 * annotableParameterCount;
        for (int i = 0; i < annotableParameterCount; ++i) {
            AnnotationWriter annotationWriter = annotationWriters[i];
            attributeSize += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(attributeName) - 8;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    static void putParameterAnnotations(int attributeNameIndex, AnnotationWriter[] annotationWriters, int annotableParameterCount, ByteVector output) {
        AnnotationWriter annotationWriter;
        int i;
        int attributeLength = 1 + 2 * annotableParameterCount;
        for (i = 0; i < annotableParameterCount; ++i) {
            annotationWriter = annotationWriters[i];
            attributeLength += annotationWriter == null ? 0 : annotationWriter.computeAnnotationsSize(null) - 8;
        }
        output.putShort(attributeNameIndex);
        output.putInt(attributeLength);
        output.putByte(annotableParameterCount);
        for (i = 0; i < annotableParameterCount; ++i) {
            void var0_1;
            annotationWriter = annotationWriters[i];
            AnnotationWriter firstAnnotation = null;
            int numAnnotations = 0;
            while (annotationWriter != null) {
                annotationWriter.visitEnd();
                ++numAnnotations;
                firstAnnotation = annotationWriter;
                annotationWriter = annotationWriter.previousAnnotation;
            }
            output.putShort(numAnnotations);
            annotationWriter = var0_1;
            while (annotationWriter != null) {
                output.putByteArray(annotationWriter.annotation.data, 0, annotationWriter.annotation.length);
                annotationWriter = annotationWriter.nextAnnotation;
            }
        }
    }
}

