/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.daemon.impl.analysis.RemoveAttributeIntentionFix;
import com.intellij.codeInsight.daemon.impl.analysis.RemoveTagIntentionFix;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMember;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyAttributeDescriptor;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public final class JavaFxRedundantPropertyValueInspection
extends XmlSuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance(JavaFxRedundantPropertyValueInspection.class);
    private static Reference<Map<String, Map<String, String>>> ourDefaultPropertyValues;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(1);
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new XmlElementVisitor(){

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                if (attribute == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitXmlAttribute(attribute);
                XmlAttributeDescriptor descriptor = attribute.getDescriptor();
                if (!(descriptor instanceof JavaFxPropertyAttributeDescriptor)) {
                    return;
                }
                String attributeName = attribute.getName();
                String attributeValue = attribute.getValue();
                if (attributeValue == null || attributeValue.startsWith("$") || attributeValue.startsWith("#") || attributeValue.startsWith("%") || "fx:id".equals(attributeName) || "fx:value".equals(attributeName) || "fx:constant".equals(attributeName) || "fx:controller".equals(attributeName)) {
                    return;
                }
                PsiClass tagClass = JavaFxPsiUtil.getTagClass(attribute.getParent());
                String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultValue(attributeName, tagClass);
                if (defaultValue == null) {
                    return;
                }
                if (JavaFxRedundantPropertyValueInspection.isEqualValue(tagClass, attributeValue, defaultValue, descriptor.getDeclaration())) {
                    holder.registerProblem((PsiElement)attribute, JavaFXBundle.message("inspection.javafx.redundant.property.values.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAttributeIntentionFix(attributeName)});
                }
            }

            public void visitXmlTag(@NotNull XmlTag tag) {
                if (tag == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitXmlTag(tag);
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (!(descriptor instanceof JavaFxPropertyTagDescriptor)) {
                    return;
                }
                if (tag.getSubTags().length != 0) {
                    return;
                }
                String tagText = tag.getValue().getTrimmedText();
                if (tagText.startsWith("$") || tagText.startsWith("#") || tagText.startsWith("%")) {
                    return;
                }
                XmlTag parentTag = tag.getParentTag();
                if (parentTag == null) {
                    return;
                }
                PsiClass tagClass = JavaFxPsiUtil.getTagClass(parentTag);
                String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultValue(tag.getName(), tagClass);
                if (defaultValue == null) {
                    return;
                }
                if (JavaFxRedundantPropertyValueInspection.isEqualValue(tagClass, tagText, defaultValue, descriptor.getDeclaration())) {
                    holder.registerProblem((PsiElement)tag, JavaFXBundle.message("inspection.javafx.redundant.property.values.redundant.tag.problem", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveTagIntentionFix(tag.getName(), tag)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tag";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxRedundantPropertyValueInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlTag";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    private static String getDefaultValue(@NotNull String propertyName, @Nullable PsiClass containingClass) {
        String qualifiedName;
        if (propertyName == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(3);
        }
        for (PsiClass psiClass = containingClass; psiClass != null && !"java.lang.Object".equals(qualifiedName = psiClass.getQualifiedName()); psiClass = psiClass.getSuperClass()) {
            String defaultValue = JavaFxRedundantPropertyValueInspection.getDefaultPropertyValue(qualifiedName, propertyName);
            if (defaultValue == null) continue;
            return defaultValue;
        }
        return null;
    }

    private static boolean isEqualValue(@Nullable PsiClass containingClass, @NotNull String attributeValue, @NotNull String defaultValue, @Nullable PsiElement declaration) {
        if (attributeValue == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(4);
        }
        if (defaultValue == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(5);
        }
        if (!(declaration instanceof PsiMember)) {
            return false;
        }
        String boxedQName = JavaFxPsiUtil.getBoxedPropertyType(containingClass, (PsiMember)declaration);
        if (boxedQName == null) {
            return defaultValue.equals(attributeValue);
        }
        try {
            return switch (boxedQName) {
                case "java.lang.Boolean" -> {
                    if (Boolean.parseBoolean(defaultValue) == Boolean.parseBoolean(attributeValue)) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Double" -> {
                    if (Double.compare(Double.parseDouble(defaultValue), Double.parseDouble(attributeValue)) == 0) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Float" -> {
                    if (Float.compare(Float.parseFloat(defaultValue), Float.parseFloat(attributeValue)) == 0) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Integer" -> {
                    if (Integer.parseInt(defaultValue) == Integer.parseInt(attributeValue)) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Long" -> {
                    if (Long.parseLong(defaultValue) == Long.parseLong(attributeValue)) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Short" -> {
                    if (Short.parseShort(defaultValue) == Short.parseShort(attributeValue)) {
                        yield true;
                    }
                    yield false;
                }
                case "java.lang.Byte" -> {
                    if (Byte.parseByte(defaultValue) == Byte.parseByte(attributeValue)) {
                        yield true;
                    }
                    yield false;
                }
                default -> defaultValue.equals(attributeValue);
            };
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    @Nullable
    private static String getDefaultPropertyValue(String classQualifiedName, String propertyName) {
        Map<String, String> values = JavaFxRedundantPropertyValueInspection.getDefaultPropertyValues(classQualifiedName);
        return values != null ? values.get(propertyName) : null;
    }

    @Nullable
    private static Map<String, String> getDefaultPropertyValues(String classQualifiedName) {
        Map<String, Map<String, String>> values = (Map<String, Map<String, String>>)SoftReference.dereference(ourDefaultPropertyValues);
        if (values == null) {
            values = JavaFxRedundantPropertyValueInspection.loadDefaultPropertyValues(JavaFxRedundantPropertyValueInspection.class.getSimpleName() + "8.txt");
            ourDefaultPropertyValues = new java.lang.ref.SoftReference<Map<String, Map<String, String>>>(values);
        }
        return (Map)values.get(classQualifiedName);
    }

    @NotNull
    private static Map<String, Map<String, String>> loadDefaultPropertyValues(@NotNull String resourceName) {
        URL resource;
        if (resourceName == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(6);
        }
        if ((resource = JavaFxRedundantPropertyValueInspection.class.getResource(resourceName)) == null) {
            LOG.warn("Resource not found: " + resourceName);
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(7);
            }
            return map;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(200);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
            for (String line : FileUtil.loadLines((BufferedReader)reader)) {
                if (line.isEmpty() || line.startsWith("--")) continue;
                boolean lineParsed = false;
                int p1 = line.indexOf(35);
                if (p1 > 0) {
                    String className = line.substring(0, p1);
                    int p2 = line.indexOf(61, p1);
                    if (p2 > p1 && p2 < line.length()) {
                        String propertyName = line.substring(p1 + 1, p2);
                        String valueText = line.substring(p2 + 1);
                        lineParsed = true;
                        Map properties = result.computeIfAbsent(className, ignored -> new HashMap());
                        if (properties.put(propertyName, valueText) != null) {
                            LOG.warn("Duplicate default property value " + line);
                        }
                    }
                }
                if (lineParsed) continue;
                LOG.warn("Can't parse default property value " + line);
            }
        }
        catch (IOException e) {
            LOG.warn("Can't read resource: " + resourceName, (Throwable)e);
            Map<String, Map<String, String>> map = Collections.emptyMap();
            if (map == null) {
                JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(8);
            }
            return map;
        }
        HashMap<String, Map<String, String>> hashMap = result;
        if (hashMap == null) {
            JavaFxRedundantPropertyValueInspection.$$$reportNull$$$0(9);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxRedundantPropertyValueInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxRedundantPropertyValueInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefaultPropertyValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEqualValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadDefaultPropertyValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

