/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.KotlinBlock;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingBuilderUtilImpl;
import org.jetbrains.kotlin.idea.formatter.KotlinSpacingRulesKt;
import org.jetbrains.kotlin.idea.formatter.NodeAlignmentStrategy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormattingModelBuilder;", "Lcom/intellij/formatting/FormattingModelBuilder;", "<init>", "()V", "createModel", "Lcom/intellij/formatting/FormattingModel;", "formattingContext", "Lcom/intellij/formatting/FormattingContext;", "getRangeAffectingIndent", "Lcom/intellij/openapi/util/TextRange;", "psiFile", "Lcom/intellij/psi/PsiFile;", "i", "", "astNode", "Lcom/intellij/lang/ASTNode;", "intellij.kotlin.formatter.minimal"})
public final class KotlinFormattingModelBuilder
implements FormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        Intrinsics.checkNotNullParameter((Object)formattingContext, (String)"formattingContext");
        CodeStyleSettings codeStyleSettings = formattingContext.getCodeStyleSettings();
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getCodeStyleSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        PsiFile psiFile = formattingContext.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile containingFile = psiFile;
        FileASTNode fileASTNode = containingFile.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
        ASTNode aSTNode = (ASTNode)fileASTNode;
        NodeAlignmentStrategy nodeAlignmentStrategy = NodeAlignmentStrategy.getNullStrategy();
        Intrinsics.checkNotNullExpressionValue((Object)nodeAlignmentStrategy, (String)"getNullStrategy(...)");
        KotlinBlock block = new KotlinBlock(aSTNode, nodeAlignmentStrategy, Indent.getNoneIndent(), null, settings, KotlinSpacingRulesKt.createSpacingBuilder(settings, KotlinSpacingBuilderUtilImpl.INSTANCE), null, 64, null);
        FormattingModel formattingModel = FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)containingFile, (Block)((Block)block), (CodeStyleSettings)settings);
        Intrinsics.checkNotNullExpressionValue((Object)formattingModel, (String)"createFormattingModelForPsiFile(...)");
        return formattingModel;
    }

    @Nullable
    public TextRange getRangeAffectingIndent(@NotNull PsiFile psiFile, int i, @NotNull ASTNode astNode) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)astNode, (String)"astNode");
        return null;
    }
}

