/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.CancellationManager;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.IdentityRenamerFactory;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.extern.IMemberIdentifierRenamer;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.main.extern.IVariableNamingFactory;
import org.jetbrains.java.decompiler.modules.renamer.IdentifierConverter;
import org.jetbrains.java.decompiler.modules.renamer.MemberConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.ClasspathScanner;
import org.jetbrains.java.decompiler.util.JADNameProvider;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class Fernflower
implements IDecompiledData {
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private final IMemberIdentifierRenamer helper;
    private final IdentifierConverter converter;

    public Fernflower(IBytecodeProvider provider, IResultSaver saver, @Nullable Map<String, Object> customProperties, IFernflowerLogger logger, @Nullable CancellationManager cancellationManager) {
        String level;
        HashMap<String, Object> properties = new HashMap<String, Object>(IFernflowerPreferences.DEFAULTS);
        if (customProperties != null) {
            properties.putAll(customProperties);
        }
        if ((level = (String)properties.get("log")) != null) {
            try {
                logger.setSeverity(IFernflowerLogger.Severity.valueOf(level.toUpperCase(Locale.ENGLISH)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.structContext = new StructContext(saver, this, new LazyLoader(provider));
        this.classProcessor = new ClassesProcessor(this.structContext);
        PoolInterceptor interceptor = null;
        if ("1".equals(properties.get("ren"))) {
            this.helper = Fernflower.loadHelper((String)properties.get("urc"), logger);
            interceptor = new PoolInterceptor();
            this.converter = new IdentifierConverter(this.structContext, this.helper, interceptor);
        } else {
            this.helper = null;
            this.converter = null;
        }
        IVariableNamingFactory renamerFactory = null;
        String factoryClazz = (String)properties.get("RENAMER_FACTORY");
        if (factoryClazz != null) {
            try {
                renamerFactory = Class.forName(factoryClazz).asSubclass(IVariableNamingFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.writeMessage("Error loading renamer factory class: " + factoryClazz, e);
            }
        }
        if (renamerFactory == null) {
            if ("1".equals(properties.get("jvn"))) {
                boolean renameParams = "1".equals(properties.get("jpr"));
                renamerFactory = new JADNameProvider.JADNameProviderFactory(renameParams);
            } else {
                renamerFactory = new IdentityRenamerFactory();
            }
        }
        DecompilerContext context = new DecompilerContext(properties, logger, this.structContext, this.classProcessor, interceptor, cancellationManager, renamerFactory);
        DecompilerContext.setCurrentContext(context);
        if (DecompilerContext.getOption("iec")) {
            ClasspathScanner.addAllClasspath(this.structContext);
        }
    }

    public Fernflower(IBytecodeProvider provider, IResultSaver saver, Map<String, Object> customProperties, IFernflowerLogger logger) {
        this(provider, saver, customProperties, logger, null);
    }

    private static IMemberIdentifierRenamer loadHelper(String className, IFernflowerLogger logger) {
        if (className != null) {
            try {
                Class<?> renamerClass = Fernflower.class.getClassLoader().loadClass(className);
                return (IMemberIdentifierRenamer)renamerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.writeMessage("Cannot load renamer '" + className + "'", IFernflowerLogger.Severity.WARN, e);
            }
        }
        return new MemberConverterHelper();
    }

    public void addSource(File source) {
        this.structContext.addSpace(source, true);
    }

    public void addLibrary(File library) {
        this.structContext.addSpace(library, false);
    }

    public void decompileContext() {
        if (this.converter != null) {
            this.converter.rename();
        }
        this.classProcessor.loadClasses(this.helper);
        this.structContext.saveContext();
    }

    public void addToMustBeDecompiled(String prefix) {
        this.classProcessor.addToMustBeDecompiled(prefix);
    }

    public void clearContext() {
        DecompilerContext.setCurrentContext(null);
    }

    @Override
    public String getClassEntryName(StructClass cl, String entryName) {
        ClassesProcessor.ClassNode node = this.classProcessor.getMapRootClasses().get(cl.qualifiedName);
        if (node == null || node.type != 0) {
            return null;
        }
        if (this.converter != null) {
            String simpleClassName = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf(47) + 1);
            return entryName.substring(0, entryName.lastIndexOf(47) + 1) + simpleClassName + ".java";
        }
        return entryName.substring(0, entryName.lastIndexOf(".class")) + ".java";
    }

    @Override
    public String getClassContent(StructClass cl) {
        try {
            TextBuffer buffer = new TextBuffer(16384);
            buffer.append(DecompilerContext.getProperty("ban").toString());
            this.classProcessor.writeClass(cl, buffer);
            return buffer.toString();
        }
        catch (CancellationManager.CanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            DecompilerContext.getLogger().writeMessage("Class " + cl.qualifiedName + " couldn't be fully decompiled.", t);
            return null;
        }
    }
}

