/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.execution.JUnitBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Query;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public final class MultipleExceptionsDeclaredOnTestMethodInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = JUnitBundle.message("multiple.exceptions.declared.on.test.method.problem.descriptor", new Object[0]);
        if (string == null) {
            MultipleExceptionsDeclaredOnTestMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected LocalQuickFix buildFix(Object ... infos) {
        return new MultipleExceptionsDeclaredOnTestMethodFix();
    }

    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        return new RedundantExceptionDeclarationVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit/codeInspection/MultipleExceptionsDeclaredOnTestMethodInspection", "buildErrorString"));
    }

    private static class MultipleExceptionsDeclaredOnTestMethodFix
    extends PsiUpdateModCommandQuickFix {
        private MultipleExceptionsDeclaredOnTestMethodFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"throws Exception"});
            if (string == null) {
                MultipleExceptionsDeclaredOnTestMethodFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (project == null) {
                MultipleExceptionsDeclaredOnTestMethodFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                MultipleExceptionsDeclaredOnTestMethodFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                MultipleExceptionsDeclaredOnTestMethodFix.$$$reportNull$$$0(3);
            }
            if (!(element instanceof PsiReferenceList)) {
                return;
            }
            PsiReferenceList referenceList = (PsiReferenceList)element;
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = referenceList.getReferenceElements()) {
                referenceElement.delete();
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            GlobalSearchScope scope = referenceList.getResolveScope();
            PsiJavaCodeReferenceElement referenceElement = factory.createReferenceElementByFQClassName("java.lang.Exception", scope);
            referenceList.add((PsiElement)referenceElement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/junit/codeInspection/MultipleExceptionsDeclaredOnTestMethodInspection$MultipleExceptionsDeclaredOnTestMethodFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/junit/codeInspection/MultipleExceptionsDeclaredOnTestMethodInspection$MultipleExceptionsDeclaredOnTestMethodFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class RedundantExceptionDeclarationVisitor
    extends BaseInspectionVisitor {
        private RedundantExceptionDeclarationVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                RedundantExceptionDeclarationVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!TestUtils.isJUnitTestMethod((PsiMethod)method)) {
                return;
            }
            PsiReferenceList throwsList = method.getThrowsList();
            PsiJavaCodeReferenceElement[] referenceElements = throwsList.getReferenceElements();
            if (referenceElements.length < 2) {
                return;
            }
            Query query = MethodReferencesSearch.search((PsiMethod)method);
            PsiReference firstReference = (PsiReference)query.findFirst();
            if (firstReference != null) {
                return;
            }
            this.registerError((PsiElement)throwsList, new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/junit/codeInspection/MultipleExceptionsDeclaredOnTestMethodInspection$RedundantExceptionDeclarationVisitor", "visitMethod"));
        }
    }
}

