/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.quantity.Quantities;

final class BigIntegerQuantity<Q extends Quantity<Q>>
extends AbstractQuantity<Q>
implements Serializable {
    private static final long serialVersionUID = -593014349777834846L;
    private final BigInteger value;

    public BigIntegerQuantity(BigInteger value, Unit<Q> unit) {
        super(unit);
        this.value = value;
    }

    public BigIntegerQuantity(long value, Unit<Q> unit) {
        super(unit);
        this.value = BigInteger.valueOf(value);
    }

    public BigIntegerQuantity negate() {
        return new BigIntegerQuantity(this.value.negate(), this.getUnit());
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public double doubleValue(Unit<Q> unit) {
        if (this.getUnit().equals(unit)) {
            return this.value.doubleValue();
        }
        return this.getUnit().getConverterTo(unit).convert(this.value.doubleValue());
    }

    @Override
    public BigDecimal decimalValue(Unit<Q> unit) throws ArithmeticException {
        if (this.getUnit().equals(unit)) {
            return new BigDecimal(this.value);
        }
        Number converted = ((AbstractConverter)unit.getConverterTo(unit)).convert(this.value);
        if (converted instanceof BigDecimal) {
            return (BigDecimal)BigDecimal.class.cast(converted);
        }
        if (converted instanceof BigInteger) {
            return new BigDecimal((BigInteger)BigInteger.class.cast(converted));
        }
        return BigDecimal.valueOf(converted.doubleValue());
    }

    @Override
    public ComparableQuantity<Q> add(Quantity<Q> that) {
        BigInteger sumValue;
        Unit pickedUnit;
        boolean switchUnits;
        if (this.getUnit().equals(that.getUnit())) {
            return Quantities.getQuantity(this.value.add(Calculus.toBigInteger(that.getValue())), this.getUnit());
        }
        UnitConverter t1 = this.getUnit().getConverterTo(that.getUnit());
        UnitConverter t2 = that.getUnit().getConverterTo(this.getUnit());
        boolean bl = switchUnits = Math.abs(t1.convert(1.0)) > Math.abs(t2.convert(1.0));
        if (switchUnits) {
            pickedUnit = that.getUnit();
            BigInteger thisValueTransformed = Calculus.toBigInteger(t1.convert((Number)this.getValue()));
            sumValue = Calculus.toBigInteger(that.getValue()).add(thisValueTransformed);
        } else {
            pickedUnit = this.getUnit();
            BigInteger thatValueTransformed = Calculus.toBigInteger(t2.convert(that.getValue()));
            sumValue = this.value.add(thatValueTransformed);
        }
        return Quantities.getQuantity(sumValue, pickedUnit);
    }

    @Override
    public ComparableQuantity<Q> subtract(Quantity<Q> that) {
        if (that instanceof BigIntegerQuantity) {
            return this.add(((BigIntegerQuantity)that).negate());
        }
        return this.add(Quantities.getQuantity(Calculus.negate(that.getValue()), that.getUnit()));
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return new BigIntegerQuantity<Q>(this.value.multiply(Calculus.toBigDecimal(that.getValue()).toBigInteger()), this.getUnit().multiply(that.getUnit()));
    }

    @Override
    public ComparableQuantity<Q> multiply(Number that) {
        return Quantities.getQuantity(this.value.multiply(Calculus.toBigInteger(that)), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> divide(Number that) {
        return Quantities.getQuantity(this.value.divide(Calculus.toBigDecimal(that).toBigInteger()), this.getUnit());
    }

    @Override
    public ComparableQuantity<Q> inverse() {
        return Quantities.getQuantity(BigInteger.ONE.divide(this.value), this.getUnit().inverse());
    }

    @Override
    protected long longValue(Unit<Q> unit) {
        double result = this.doubleValue(unit);
        if (result < -9.223372036854776E18 || result > 9.223372036854776E18) {
            throw new ArithmeticException("Overflow (" + result + ")");
        }
        return (long)result;
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return new BigIntegerQuantity<Q>(this.value.divide(Calculus.toBigInteger(that.getValue())), this.getUnit().divide(that.getUnit()));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return false;
    }
}

