/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.api.GenericPlatform;

class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Object bufferedImage;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int widthOffscreen;
    int heightOffscreen;
    Object offscreenImage;
    Object graphicsForTextOrImage;
    GenericPlatform apiPlatform;
    private static boolean backgroundTransparent = false;

    Platform3D(GenericPlatform apiPlatform) {
        this.apiPlatform = apiPlatform;
    }

    Object getGraphicsForMetrics() {
        return this.apiPlatform.getGraphics(this.allocateOffscreenImage(1, 1));
    }

    void allocateTBuffers(boolean antialiasTranslucent) {
        this.bufferSizeT = antialiasTranslucent ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int width, int height, boolean antialias, boolean isImageWrite) {
        this.windowWidth = width;
        this.windowHeight = height;
        this.windowSize = width * height;
        if (antialias) {
            width *= 2;
            height *= 2;
        }
        this.bufferWidth = width;
        this.bufferHeight = height;
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.bufferedImage = this.apiPlatform.allocateRgbImage(this.windowWidth, this.windowHeight, this.pBuffer, this.windowSize, backgroundTransparent, isImageWrite);
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.bufferedImage != null) {
            this.apiPlatform.flushImage(this.bufferedImage);
            this.bufferedImage = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    boolean hasContent() {
        int i = this.bufferSize;
        while (--i >= 0) {
            if (this.zBuffer[i] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer() {
        int i = this.bufferSize;
        while (--i >= 0) {
            this.zBuffer[i] = Integer.MAX_VALUE;
            this.pBuffer[i] = 0;
        }
    }

    void setBackgroundColor(int bgColor) {
        if (this.pBuffer == null) {
            return;
        }
        int i = this.bufferSize;
        while (--i >= 0) {
            if (this.pBuffer[i] != 0) continue;
            this.pBuffer[i] = bgColor;
        }
    }

    void clearTBuffer() {
        int i = this.bufferSizeT;
        while (--i >= 0) {
            this.zBufferT[i] = Integer.MAX_VALUE;
            this.pBufferT[i] = 0;
        }
    }

    final void clearBuffer() {
        this.clearScreenBuffer();
    }

    final void clearScreenBufferThreaded() {
    }

    void notifyEndOfRendering() {
        this.apiPlatform.notifyEndOfRendering();
    }

    Object getGraphicsForTextOrImage(int width, int height) {
        if (width > this.widthOffscreen || height > this.heightOffscreen) {
            if (this.offscreenImage != null) {
                this.apiPlatform.disposeGraphics(this.graphicsForTextOrImage);
                this.apiPlatform.flushImage(this.offscreenImage);
            }
            if (width > this.widthOffscreen) {
                this.widthOffscreen = width;
            }
            if (height > this.heightOffscreen) {
                this.heightOffscreen = height;
            }
            this.offscreenImage = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
            this.graphicsForTextOrImage = this.apiPlatform.getStaticGraphics(this.offscreenImage, backgroundTransparent);
        }
        return this.graphicsForTextOrImage;
    }

    private Object allocateOffscreenImage(int width, int height) {
        return this.apiPlatform.newOffScreenImage(width, height);
    }

    void setBackgroundTransparent(boolean tf) {
        backgroundTransparent = tf;
    }
}

