/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.c.STR;

public class TempArray {
    private static final int freePointsSize = 6;
    private final int[] lengthsFreePoints = new int[6];
    private final P3[][] freePoints = new P3[6][];
    private static final int freeScreensSize = 6;
    private final int[] lengthsFreeScreens = new int[6];
    private final P3i[][] freeScreens = new P3i[6][];
    private static final int freeEnumSize = 2;
    private final int[] lengthsFreeEnum = new int[2];
    private final STR[][] freeEnum = new STR[2][];

    public void clear() {
        this.clearTempPoints();
        this.clearTempScreens();
    }

    private static int findBestFit(int size, int[] lengths) {
        int iFit = -1;
        int fitLength = Integer.MAX_VALUE;
        int i = lengths.length;
        while (--i >= 0) {
            int freeLength = lengths[i];
            if (freeLength < size || freeLength >= fitLength) continue;
            fitLength = freeLength;
            iFit = i;
        }
        if (iFit >= 0) {
            lengths[iFit] = 0;
        }
        return iFit;
    }

    private static int findShorter(int size, int[] lengths) {
        int i = lengths.length;
        while (--i >= 0) {
            if (lengths[i] != 0) continue;
            lengths[i] = size;
            return i;
        }
        int iShortest = 0;
        int shortest = lengths[0];
        int i2 = lengths.length;
        while (--i2 > 0) {
            if (lengths[i2] >= shortest) continue;
            shortest = lengths[i2];
            iShortest = i2;
        }
        if (shortest < size) {
            lengths[iShortest] = size;
            return iShortest;
        }
        return -1;
    }

    private void clearTempPoints() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreePoints[i] = 0;
            this.freePoints[i] = null;
        }
    }

    public P3[] allocTempPoints(int size) {
        P3[] tempPoints;
        int iFit = TempArray.findBestFit(size, this.lengthsFreePoints);
        if (iFit > 0) {
            tempPoints = this.freePoints[iFit];
        } else {
            tempPoints = new P3[size];
            int i = size;
            while (--i >= 0) {
                tempPoints[i] = new P3();
            }
        }
        return tempPoints;
    }

    public void freeTempPoints(P3[] tempPoints) {
        for (int i = 0; i < this.freePoints.length; ++i) {
            if (this.freePoints[i] != tempPoints) continue;
            this.lengthsFreePoints[i] = tempPoints.length;
            return;
        }
        int iFree = TempArray.findShorter(tempPoints.length, this.lengthsFreePoints);
        if (iFree >= 0) {
            this.freePoints[iFree] = tempPoints;
        }
    }

    private void clearTempScreens() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreeScreens[i] = 0;
            this.freeScreens[i] = null;
        }
    }

    public P3i[] allocTempScreens(int size) {
        P3i[] tempScreens;
        int iFit = TempArray.findBestFit(size, this.lengthsFreeScreens);
        if (iFit > 0) {
            tempScreens = this.freeScreens[iFit];
        } else {
            tempScreens = new P3i[size];
            int i = size;
            while (--i >= 0) {
                tempScreens[i] = new P3i();
            }
        }
        return tempScreens;
    }

    public void freeTempScreens(P3i[] tempScreens) {
        for (int i = 0; i < this.freeScreens.length; ++i) {
            if (this.freeScreens[i] != tempScreens) continue;
            this.lengthsFreeScreens[i] = tempScreens.length;
            return;
        }
        int iFree = TempArray.findShorter(tempScreens.length, this.lengthsFreeScreens);
        if (iFree >= 0) {
            this.freeScreens[iFree] = tempScreens;
        }
    }

    public STR[] allocTempEnum(int size) {
        int iFit = TempArray.findBestFit(size, this.lengthsFreeEnum);
        STR[] tempEnum = iFit > 0 ? this.freeEnum[iFit] : new STR[size];
        return tempEnum;
    }

    public void freeTempEnum(STR[] tempEnum) {
        for (int i = 0; i < this.freeEnum.length; ++i) {
            if (this.freeEnum[i] != tempEnum) continue;
            this.lengthsFreeEnum[i] = tempEnum.length;
            return;
        }
        int iFree = TempArray.findShorter(tempEnum.length, this.lengthsFreeEnum);
        if (iFree >= 0) {
            this.freeEnum[iFree] = tempEnum;
        }
    }

    public static Object[] getSlabWithinRange(float min, float max) {
        return new Object[]{1073742114, new Float[]{Float.valueOf(min), Float.valueOf(max)}, Boolean.FALSE, null};
    }

    public static Object[] getSlabObjectType(int tok, Object data, boolean isCap, Object colorData) {
        return new Object[]{tok, data, isCap, colorData};
    }
}

