/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.SB;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.XMLParser;
import org.jmol.util.Logger;

abstract class XMLReader
implements SourceReader {
    protected JDXSource source;
    protected String filePath = "";
    protected XMLParser parser;
    protected String tagName = "START";
    protected String attrList = "";
    protected String title = "";
    protected String owner = "UNKNOWN";
    protected String origin = "UNKNOWN";
    protected String tmpEnd = "END";
    protected String molForm = "";
    protected String techname = "";
    protected int npoints = -1;
    protected int samplenum = -1;
    protected double[] yaxisData;
    protected double[] xaxisData;
    protected String xUnits = "";
    protected String yUnits = "ARBITRARY UNITS";
    protected String vendor = "na";
    protected String modelType = "MODEL UNKNOWN";
    protected String LongDate = "";
    protected String pathlength = "na";
    protected String identifier = "";
    protected String plLabel = "";
    protected String resolution = "na";
    protected String resLabel = "";
    protected String LocName = "";
    protected String LocContact = "";
    protected String casName = "";
    protected String sampleowner = "";
    protected String obNucleus = "";
    protected String strObFreq = "";
    protected boolean increasing = false;
    protected boolean continuous = false;
    protected int ivspoints;
    protected int evspoints;
    protected int sampleRefNum = 0;
    protected double deltaX = Double.MAX_VALUE;
    protected double xFactor = Double.MAX_VALUE;
    protected double yFactor = Double.MAX_VALUE;
    protected double firstX = Double.MAX_VALUE;
    protected double lastX = Double.MAX_VALUE;
    protected double firstY = Double.MAX_VALUE;
    protected double obFreq = Double.MAX_VALUE;
    protected double refPoint = Double.MAX_VALUE;
    protected String casRN = "";
    protected String sampleID;
    protected SB errorLog = new SB();
    static final String[] tagNames = new String[]{"audittrail", "experimentstepset", "sampleset", "xx result", "spectrum", "metadatalist", "conditionlist", "parameterlist", "sample", "spectrumdata", "peaklist", "author", "peaklist", "acquisitionnucleus", "effectiveexcitationfield", "spectrum1d", "spectrumAnnotationList", "chemicalcompound", "identifier", "npmrd_id", "structure", "atomlist", "atom", "bondlist", "bond", "atomassignmentlist", "multiplet", "atoms", "multiplicity", "peakList", "peak", "acquisition", "spectrumdataarray", "spectrumlist"};
    static final int AML_0 = 0;
    static final int AML_AUDITTRAIL = 0;
    static final int AML_EXPERIMENTSTEPSET = 1;
    static final int AML_SAMPLESET = 2;
    static final int AML_RESULT = 3;
    static final int AML_1 = 3;
    static final int CML_0 = 4;
    static final int CML_SPECTRUM = 4;
    static final int CML_METADATALIST = 5;
    static final int CML_CONDITIONLIST = 6;
    static final int CML_PARAMETERLIST = 7;
    static final int CML_SAMPLE = 8;
    static final int CML_SPECTRUMDATA = 9;
    static final int CML_PEAKLIST = 10;
    static final int CML_1 = 10;
    static final int AML_AUTHOR = 11;
    static final int CML_PEAKLIST2 = 12;
    static final int NMRML_0 = 13;
    static final int NMRML_acquisitionnucleus = 13;
    static final int NMRML_effectiveexcitationfield = 14;
    static final int NMRML_spectrum1d = 15;
    static final int NMRML_spectrumAnnotationList = 16;
    static final int NMRML_chemicalcompound = 17;
    static final int NMRML_identifier = 18;
    static final int NMRML_npmrd_id = 19;
    static final int NMRML_structure = 20;
    static final int NMRML_atomlist = 21;
    static final int NMRML_atom = 22;
    static final int NMRML_bondlist = 23;
    static final int NMRML_bond = 24;
    static final int NMRML_atomAssignmentList = 25;
    static final int NMRML_multiplet = 26;
    static final int NMRML_atoms = 27;
    static final int NMRML_multiplicity = 28;
    static final int NMRML_peakList = 29;
    static final int NMRML_peak = 30;
    static final int NMRML_acquisition = 31;
    static final int NMRML_spectrumdataarray = 32;
    static final int NMRML_spectrumlist = 33;
    static final int NMRML_1 = 33;

    protected abstract JDXSource getXML(BufferedReader var1);

    protected abstract boolean processTag(int var1) throws Exception;

    protected abstract void processEndTag(int var1) throws Exception;

    @Override
    public JDXSource getSource(String filePath, BufferedReader br) {
        this.filePath = filePath;
        return this.getXML(br);
    }

    protected void getSimpleXmlReader(BufferedReader br) {
        this.parser = new XMLParser(br);
    }

    protected void checkStart() throws Exception {
        if (this.parser.peek() == 1) {
            return;
        }
        String errMsg = "Error: XML <xxx> not found at beginning of file; not an XML document?";
        this.errorLog.append(errMsg);
        throw new IOException(errMsg);
    }

    protected void populateVariables() {
        JDXHeader.DataLDRTable myLDRTable = new JDXHeader.DataLDRTable();
        Spectrum spectrum = new Spectrum();
        spectrum.setTitle(this.title);
        spectrum.setJcampdx("5.01");
        spectrum.setDataClass("XYDATA");
        spectrum.setDataType(this.techname);
        spectrum.setContinuous(this.continuous);
        spectrum.setIncreasing(this.increasing);
        spectrum.setXFactor(this.xFactor);
        spectrum.setYFactor(this.yFactor);
        spectrum.setLongDate(this.LongDate);
        spectrum.setOrigin(this.origin);
        spectrum.setOwner(this.owner);
        spectrum.setNucleusAndFreq(this.obNucleus, true);
        myLDRTable.addHeader("##PATHLENGTH", this.pathlength);
        myLDRTable.addHeader("##RESOLUTION", this.resolution);
        if (!this.strObFreq.equals("")) {
            myLDRTable.addHeader("##.OBSERVEFREQUENCY", this.strObFreq);
        }
        if (!this.obNucleus.equals("")) {
            myLDRTable.addHeader("##.OBSERVENUCLEUS", this.obNucleus);
        }
        myLDRTable.addHeader("##$MANUFACTURER", this.vendor);
        if (!this.casRN.equals("")) {
            myLDRTable.addHeader("##CASREGISTRYNO", this.casRN);
        }
        if (!this.molForm.equals("")) {
            myLDRTable.addHeader("##MOLFORM", this.molForm);
        }
        if (!this.modelType.equals("")) {
            myLDRTable.addHeader("##SPECTROMETER/DATA SYSTEM", this.modelType);
        }
        spectrum.setHeaderTable(myLDRTable.table);
        double xScale = 1.0;
        if (this.obFreq != Double.MAX_VALUE) {
            spectrum.setObservedFreq(this.obFreq);
            if (this.xUnits.toUpperCase().equals("HZ")) {
                this.xUnits = "PPM";
                spectrum.setHZtoPPM(true);
                xScale = this.obFreq;
            }
        }
        Coordinate[] xyCoords = new Coordinate[this.npoints];
        for (int x = 0; x < this.npoints; ++x) {
            xyCoords[x] = new Coordinate().set(this.xaxisData[x] / xScale, this.yaxisData[x]);
        }
        if (!this.increasing) {
            xyCoords = Coordinate.reverse(xyCoords);
        }
        spectrum.setXUnits(this.xUnits);
        spectrum.setYUnits(this.yUnits);
        spectrum.setXYCoords(xyCoords);
        this.source.addJDXSpectrum(this.filePath, spectrum, false);
    }

    protected boolean checkPointCount() {
        if (this.continuous && this.npoints < 5) {
            System.err.println("Insufficient points to plot");
            this.errorLog.append("Insufficient points to plot \n");
            this.source.setErrorLog(this.errorLog.toString());
            return false;
        }
        return true;
    }

    protected void processErrors(String type) {
        this.parser = null;
        if (this.errorLog.length() > 0) {
            this.errorLog.append("these errors were found in " + type + " \n");
            this.errorLog.append("=====================\n");
        }
        this.source.setErrorLog(this.errorLog.toString());
    }

    protected void processXML(int i0, int i1) throws Exception {
        block0: while (this.parser.hasNext()) {
            if (this.parser.nextEvent() != 1) continue;
            String theTag = this.parser.getTagName();
            boolean requiresEndTag = this.parser.requiresEndTag();
            if (Logger.debugging) {
                Logger.info(this.tagName);
            }
            for (int i = i0; i <= i1; ++i) {
                if (!theTag.equals(tagNames[i])) continue;
                this.process(i, requiresEndTag);
                continue block0;
            }
        }
    }

    protected void process(int tagId, boolean requiresEndTag) {
        String thisTagName = tagNames[tagId];
        try {
            this.tagName = this.parser.getTagName();
            this.attrList = this.parser.getAttributeList();
            if (!this.processTag(tagId) || !requiresEndTag) {
                return;
            }
            block6: while (this.parser.hasNext()) {
                switch (this.parser.nextEvent()) {
                    default: {
                        continue block6;
                    }
                    case 2: {
                        if (!this.parser.getEndTag().equals(thisTagName)) continue block6;
                        this.processEndTag(tagId);
                        return;
                    }
                    case 1: 
                }
                this.tagName = this.parser.getTagName();
                if (this.tagName.startsWith("!--")) continue;
                this.attrList = this.parser.getAttributeList();
                if (this.processTag(tagId)) continue;
                return;
            }
        }
        catch (Exception e) {
            String msg = "error reading " + this.tagName + " section: " + e + "\n" + e.getStackTrace();
            Logger.error(msg);
            this.errorLog.append(msg + "\n");
        }
    }
}

