/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.IRemoteCacheServer;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.CacheEventQueueFactory;
import org.apache.commons.jcs3.engine.CacheListeners;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheEventQueue;
import org.apache.commons.jcs3.engine.behavior.ICacheListener;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.control.CompositeCacheManager;
import org.apache.commons.jcs3.engine.logging.CacheEvent;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEvent;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class RemoteCacheServer<K, V>
extends UnicastRemoteObject
implements IRemoteCacheServer<K, V>,
Unreferenced {
    public static final String DFEAULT_REMOTE_CONFIGURATION_FILE = "/remote.cache.ccf";
    private static final long serialVersionUID = -8072345435941473116L;
    private static final Log log = LogManager.getLog(RemoteCacheServer.class);
    private int puts;
    private final transient ConcurrentMap<String, CacheListeners<K, V>> cacheListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private final transient ConcurrentMap<String, CacheListeners<K, V>> clusterListenersMap = new ConcurrentHashMap<String, CacheListeners<K, V>>();
    private transient CompositeCacheManager cacheManager;
    private final ConcurrentMap<Long, RemoteType> idTypeMap = new ConcurrentHashMap<Long, RemoteType>();
    private final ConcurrentMap<Long, String> idIPMap = new ConcurrentHashMap<Long, String>();
    private final int[] listenerId = new int[1];
    final IRemoteCacheServerAttributes remoteCacheServerAttributes;
    private static final int logInterval = 100;
    private transient ICacheEventLogger cacheEventLogger;

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa, Properties config) throws RemoteException {
        super(rcsa.getServicePort());
        this.remoteCacheServerAttributes = rcsa;
        this.init(config);
    }

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa, Properties config, RMISocketFactory customRMISocketFactory) throws RemoteException {
        super(rcsa.getServicePort(), customRMISocketFactory, customRMISocketFactory);
        this.remoteCacheServerAttributes = rcsa;
        this.init(config);
    }

    private void init(Properties prop) throws RemoteException {
        try {
            this.cacheManager = RemoteCacheServer.createCacheManager(prop);
        }
        catch (CacheException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        this.cacheManager.getCacheNames().forEach(name -> {
            CompositeCache cache = this.cacheManager.getCache((String)name);
            this.cacheListenersMap.put((String)name, new CacheListeners(cache));
        });
    }

    private static CompositeCacheManager createCacheManager(Properties prop) throws CacheException {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        hub.configure(prop);
        return hub;
    }

    public void put(ICacheElement<K, V> item) throws IOException {
        this.update(item);
    }

    @Override
    public void update(ICacheElement<K, V> item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(ICacheElement<K, V> item, long requesterId) throws IOException {
        ICacheEvent<ICacheElement<K, V>> cacheEvent = this.createICacheEvent(item, requesterId, "update");
        try {
            this.processUpdate(item, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(ICacheElement<K, V> item, long requesterId) {
        ElapsedTimer timer = new ElapsedTimer();
        this.logUpdateInfo(item);
        try {
            CacheListeners<K, V> cacheDesc = this.getCacheListeners(item.getCacheName());
            boolean fromCluster = this.isRequestFromCluster(requesterId);
            log.debug("In update, requesterId = [{0}] fromCluster = {1}", requesterId, fromCluster);
            CacheListeners<K, V> cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                try {
                    CompositeCache c = (CompositeCache)cacheDesc.cache;
                    if (fromCluster) {
                        log.debug("Put FROM cluster, NOT updating other auxiliaries for region.  requesterId [{0}]", requesterId);
                        c.localUpdate(item);
                    } else {
                        log.debug("Put NOT from cluster, updating other auxiliaries for region.  requesterId [{0}]", requesterId);
                        c.update(item);
                    }
                }
                catch (IOException ce) {
                    log.info("Exception caught updating item. requesterId [{0}]: {1}", requesterId, ce.getMessage());
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist = this.getEventQList(cacheDesc, requesterId);
                    log.debug("qlist.length = {0}", qlist.length);
                    for (ICacheEventQueue<K, V> element : qlist) {
                        element.addPutEvent(item);
                    }
                }
            }
        }
        catch (IOException e) {
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RemoteCacheServer", "update", e.getMessage() + " REGION: " + item.getCacheName() + " ITEM: " + item);
            }
            log.error("Trouble in Update. requesterId [{0}]", requesterId, e);
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = timer::getElapsedTime;
        log.debug("put took {0} ms.", supplierArray);
    }

    private void logUpdateInfo(ICacheElement<K, V> item) {
        ++this.puts;
        if (log.isInfoEnabled() && this.puts % 100 == 0) {
            log.info("puts = {0}", this.puts);
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = item::getKey;
        supplierArray[1] = item::getCacheName;
        log.debug("In update, put [{0}] in [{1}]", supplierArray);
    }

    @Override
    public ICacheElement<K, V> get(String cacheName, K key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICacheElement<K, V> get(String cacheName, K key, long requesterId) throws IOException {
        ICacheElement<K, V> element = null;
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "get");
        try {
            element = this.processGet(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
        return element;
    }

    private ICacheElement<K, V> processGet(String cacheName, K key, long requesterId) {
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        log.debug("get [{0}] from cache [{1}] requesterId = [{2}] fromCluster = {3}", key, cacheName, requesterId, fromCluster);
        CacheListeners<K, V> cacheDesc = this.getCacheListeners(cacheName);
        return this.getFromCacheListeners(key, fromCluster, cacheDesc, null);
    }

    private ICacheElement<K, V> getFromCacheListeners(K key, boolean fromCluster, CacheListeners<K, V> cacheDesc, ICacheElement<K, V> element) {
        ICacheElement<K, V> returnElement = element;
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                log.debug("NonLocalGet. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                returnElement = c.get(key);
            } else {
                log.debug("LocalGet. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                returnElement = c.localGet(key);
            }
        }
        return returnElement;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, pattern, requesterId, "getMatching");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMatching(cacheName, pattern, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected Map<K, ICacheElement<K, V>> processGetMatching(String cacheName, String pattern, long requesterId) {
        CacheListeners<K, V> cacheDesc;
        boolean fromCluster;
        block2: {
            fromCluster = this.isRequestFromCluster(requesterId);
            log.debug("getMatching [{0}] from cache [{1}] requesterId = [{2}] fromCluster = {3}", pattern, cacheName, requesterId, fromCluster);
            cacheDesc = null;
            try {
                cacheDesc = this.getCacheListeners(cacheName);
            }
            catch (Exception e) {
                log.error("Problem getting listeners.", e);
                if (this.cacheEventLogger == null) break block2;
                this.cacheEventLogger.logError("RemoteCacheServer", "getMatching", e.getMessage() + cacheName + " pattern: " + pattern);
            }
        }
        return this.getMatchingFromCacheListeners(pattern, fromCluster, cacheDesc);
    }

    private Map<K, ICacheElement<K, V>> getMatchingFromCacheListeners(String pattern, boolean fromCluster, CacheListeners<K, V> cacheDesc) {
        Map elements = null;
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                log.debug("NonLocalGetMatching. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                elements = c.getMatching(pattern);
            } else {
                log.debug("LocalGetMatching. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                elements = c.localGetMatching(pattern);
            }
        }
        return elements;
    }

    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> getMultiple(String cacheName, Set<K> keys, long requesterId) throws IOException {
        ICacheEvent<Serializable> cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)keys), requesterId, "getMultiple");
        try {
            Map<K, ICacheElement<K, V>> map = this.processGetMultiple(cacheName, keys, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    private Map<K, ICacheElement<K, V>> processGetMultiple(String cacheName, Set<K> keys, long requesterId) {
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        log.debug("getMultiple [{0}] from cache [{1}] requesterId = [{2}] fromCluster = {3}", keys, cacheName, requesterId, fromCluster);
        CacheListeners<K, V> cacheDesc = this.getCacheListeners(cacheName);
        return this.getMultipleFromCacheListeners(keys, null, fromCluster, cacheDesc);
    }

    private boolean isRequestFromCluster(long requesterId) {
        RemoteType remoteTypeL = (RemoteType)((Object)this.idTypeMap.get(requesterId));
        return remoteTypeL == RemoteType.CLUSTER;
    }

    private Map<K, ICacheElement<K, V>> getMultipleFromCacheListeners(Set<K> keys, Map<K, ICacheElement<K, V>> elements, boolean fromCluster, CacheListeners<K, V> cacheDesc) {
        Map<K, ICacheElement<K, V>> returnElements = elements;
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.isAllowClusterGet()) {
                log.debug("NonLocalGetMultiple. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                returnElements = c.getMultiple(keys);
            } else {
                log.debug("LocalGetMultiple. fromCluster [{0}] AllowClusterGet [{1}]", fromCluster, this.remoteCacheServerAttributes.isAllowClusterGet());
                returnElements = c.localGetMultiple(keys);
            }
        }
        return returnElements;
    }

    @Override
    public Set<K> getKeySet(String cacheName) throws IOException {
        return this.processGetKeySet(cacheName);
    }

    protected Set<K> processGetKeySet(String cacheName) {
        CacheListeners<K, V> cacheDesc = this.getCacheListeners(cacheName);
        if (cacheDesc == null) {
            return Collections.emptySet();
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.getKeySet();
    }

    @Override
    public void remove(String cacheName, K key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String cacheName, K key, long requesterId) throws IOException {
        ICacheEvent<K> cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "remove");
        try {
            this.processRemove(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemove(String cacheName, K key, long requesterId) throws IOException {
        log.debug("remove [{0}] from cache [{1}]", key, cacheName);
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    log.debug("Remove FROM cluster, NOT updating other auxiliaries for region");
                    removeSuccess = c.localRemove(key);
                } else {
                    log.debug("Remove NOT from cluster, updating other auxiliaries for region");
                    removeSuccess = c.remove(key);
                }
                log.debug("remove [{0}] from cache [{1}] success (was it found) = {2}", key, cacheName, removeSuccess);
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist;
                    for (ICacheEventQueue<K, V> element : qlist = this.getEventQList(cacheDesc, requesterId)) {
                        element.addRemoveEvent(key);
                    }
                }
            }
        }
    }

    @Override
    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "all", requesterId, "removeAll");
        try {
            this.processRemoveAll(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveAll(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    log.debug("RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    c.localRemoveAll();
                } else {
                    log.debug("RemoveALL NOT from cluster, updating other auxiliaries for region");
                    c.removeAll();
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.isLocalClusterConsistency()) {
                    ICacheEventQueue<K, V>[] qlist;
                    for (ICacheEventQueue<K, V> q : qlist = this.getEventQList(cacheDesc, requesterId)) {
                        q.addRemoveAllEvent();
                    }
                }
            }
        }
    }

    int getPutCount() {
        return this.puts;
    }

    @Override
    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        ICacheEvent<String> cacheEvent = this.createICacheEvent(cacheName, "none", requesterId, "dispose");
        try {
            this.processDispose(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDispose(String cacheName, long requesterId) throws IOException {
        log.info("Dispose request received from listener [{0}]", requesterId);
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue<K, V>[] qlist;
                for (ICacheEventQueue<K, V> element : qlist = this.getEventQList(cacheDesc, requesterId)) {
                    element.addDisposeEvent();
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    @Override
    public void release() throws IOException {
        for (CacheListeners cacheDesc : this.cacheListenersMap.values()) {
            ICacheEventQueue<K, V>[] qlist;
            for (ICacheEventQueue<K, V> element : qlist = this.getEventQList(cacheDesc, 0L)) {
                element.addDisposeEvent();
            }
        }
        this.cacheManager.release();
    }

    protected CacheListeners<K, V> getCacheListeners(String cacheName) {
        return this.cacheListenersMap.computeIfAbsent(cacheName, key -> {
            CompositeCache cache = this.cacheManager.getCache((String)key);
            return new CacheListeners(cache);
        });
    }

    protected CacheListeners<K, V> getClusterListeners(String cacheName) {
        return this.clusterListenersMap.computeIfAbsent(cacheName, key -> {
            CompositeCache cache = this.cacheManager.getCache(cacheName);
            return new CacheListeners(cache);
        });
    }

    private ICacheEventQueue<K, V>[] getEventQList(CacheListeners<K, V> cacheListeners, long requesterId) {
        ICacheEventQueue[] list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        int count = 0;
        for (int i = 0; i < list.length; ++i) {
            ICacheEventQueue q = list[i];
            if (q.isWorking() && q.getListenerId() != requesterId) {
                ++count;
                continue;
            }
            list[i] = null;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        for (ICacheEventQueue element : list) {
            if (element == null) continue;
            qq[count++] = element;
        }
        return qq;
    }

    private static <KK, VV> void cleanupEventQMap(Map<Long, ICacheEventQueue<KK, VV>> eventQMap) {
        eventQMap.entrySet().removeIf(e -> !((ICacheEventQueue)e.getValue()).isWorking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK, VV> void addCacheListener(String cacheName, ICacheListener<KK, VV> listener) throws IOException {
        CacheListeners<K, V> cacheListeners;
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
        String listenerAddress = ircl.getLocalHostAddress();
        RemoteType remoteType = ircl.getRemoteType();
        if (remoteType == RemoteType.CLUSTER) {
            log.debug("adding cluster listener, listenerAddress [{0}]", listenerAddress);
            cacheListeners = this.getClusterListeners(cacheName);
        } else {
            log.debug("adding normal listener, listenerAddress [{0}]", listenerAddress);
            cacheListeners = this.getCacheListeners(cacheName);
        }
        ConcurrentMap<Long, ICacheEventQueue<KK, VV>> eventQMap = cacheListeners.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        Class<ICacheListener> clazz = ICacheListener.class;
        synchronized (ICacheListener.class) {
            long id;
            block11: {
                id = 0L;
                try {
                    id = listener.getListenerId();
                    if (id == 0L) {
                        long listenerIdB = this.nextListenerId();
                        log.debug("listener id={0} addded for cache [{1}], listenerAddress [{2}]", listenerIdB & 0xFFL, cacheName, listenerAddress);
                        listener.setListenerId(listenerIdB);
                        id = listenerIdB;
                        String message = "Adding vm listener under new id = [" + listenerIdB + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        log.info(message);
                    } else {
                        String message = "Adding listener under existing id = [" + id + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        log.info(message);
                    }
                    this.idTypeMap.put(id, remoteType);
                    if (listenerAddress != null) {
                        this.idIPMap.put(id, listenerAddress);
                    }
                }
                catch (IOException ioe) {
                    String message = "Problem setting listener id, listenerAddress [" + listenerAddress + "]";
                    log.error(message, ioe);
                    if (this.cacheEventLogger == null) break block11;
                    this.cacheEventLogger.logError("RemoteCacheServer", "addCacheListener", message + " - " + ioe.getMessage());
                }
            }
            CacheEventQueueFactory<KK, VV> fact = new CacheEventQueueFactory<KK, VV>();
            ICacheEventQueue q = fact.createCacheEventQueue(listener, id, cacheName, this.remoteCacheServerAttributes.getEventQueuePoolName(), this.remoteCacheServerAttributes.getEventQueueType());
            eventQMap.put(listener.getListenerId(), q);
            log.info(cacheListeners);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    public <KK, VV> void addCacheListener(ICacheListener<KK, VV> listener) throws IOException {
        for (String cacheName : this.cacheListenersMap.keySet()) {
            this.addCacheListener(cacheName, listener);
            log.debug("Adding listener for cache [{0}]", cacheName);
        }
    }

    public <KK, VV> void removeCacheListener(String cacheName, ICacheListener<KK, VV> listener) throws IOException {
        this.removeCacheListener(cacheName, listener.getListenerId());
    }

    public void removeCacheListener(String cacheName, long listenerId) {
        String message = "Removing listener for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]";
        this.logApplicationEvent("RemoteCacheServer", "removeCacheListener", message);
        log.info(message);
        boolean isClusterListener = this.isRequestFromCluster(listenerId);
        CacheListeners<K, V> cacheDesc = null;
        cacheDesc = isClusterListener ? this.getClusterListeners(cacheName) : this.getCacheListeners(cacheName);
        ConcurrentMap eventQMap = cacheDesc.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        ICacheEventQueue q = (ICacheEventQueue)eventQMap.remove(listenerId);
        if (q != null) {
            log.debug("Found queue for cache region = [{0}] and listenerId [{1}]", cacheName, listenerId);
            q.destroy();
            RemoteCacheServer.cleanupEventQMap(eventQMap);
        } else {
            log.debug("Did not find queue for cache region = [{0}] and listenerId [{1}]", cacheName, listenerId);
        }
        this.idTypeMap.remove(listenerId);
        this.idIPMap.remove(listenerId);
        log.info("After removing listener [{0}] cache region {1} listener size [{2}]", listenerId, cacheName, eventQMap.size());
    }

    public <KK, VV> void removeCacheListener(ICacheListener<KK, VV> listener) throws IOException {
        for (String cacheName : this.cacheListenersMap.keySet()) {
            this.removeCacheListener(cacheName, listener);
            log.info("Removing listener for cache [{0}]", cacheName);
        }
    }

    @Override
    public void shutdown() throws IOException {
        this.shutdown("", 1099);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(String host, int port) throws IOException {
        log.info("Received shutdown request. Shutting down server.");
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            for (String cacheName : this.cacheListenersMap.keySet()) {
                for (int i = 0; i <= this.listenerId[0]; ++i) {
                    this.removeCacheListener(cacheName, i);
                }
                log.info("Removing listener for cache [{0}]", cacheName);
            }
            this.cacheListenersMap.clear();
            this.clusterListenersMap.clear();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            RemoteCacheServerFactory.shutdownImpl(host, port);
            this.cacheManager.shutDown();
            return;
        }
    }

    @Override
    public void unreferenced() {
        log.info("*** Server now unreferenced and subject to GC. ***");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextListenerId() {
        long id = 0L;
        if (this.listenerId[0] == Integer.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (this.listenerId) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            this.listenerId[0] = this.listenerId[0] + 1;
            id = this.listenerId[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    @Override
    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    private ICacheEvent<ICacheElement<K, V>> createICacheEvent(ICacheElement<K, V> item, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent<ICacheElement<K, V>>();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", item.getCacheName(), eventName, ipAddress, item);
    }

    private <T> ICacheEvent<T> createICacheEvent(String cacheName, T key, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return new CacheEvent();
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", cacheName, eventName, ipAddress, key);
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected <T> void logICacheEvent(ICacheEvent<T> cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected String getExtraInfoForRequesterId(long requesterId) {
        return (String)this.idIPMap.get(requesterId);
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

