/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.relation;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.relation.AbstractRelationAction;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DuplicateRelationAction
extends AbstractRelationAction {
    public DuplicateRelationAction() {
        this.putValue("ShortDescription", I18n.tr("Create a copy of this relation and open it in another editor window", new Object[0]));
        new ImageProvider("duplicate").getResource().attachImageIcon(this, true);
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
    }

    public static void duplicateRelationAndLaunchEditor(Relation original) {
        if (!DuplicateRelationAction.confirmRelationDuplicate(original)) {
            return;
        }
        Relation copy = new Relation(original, true);
        copy.setModified(true);
        RelationEditor editor = RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), copy, null);
        editor.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled() || this.relations.isEmpty()) {
            return;
        }
        IRelation r = (IRelation)this.relations.iterator().next();
        if (r instanceof Relation) {
            DuplicateRelationAction.duplicateRelationAndLaunchEditor((Relation)r);
        }
    }

    private static boolean isEditableRelation(IRelation<?> r) {
        return r instanceof Relation && r.getDataSet() != null && !r.getDataSet().isLocked();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.relations.size() == 1 && DuplicateRelationAction.isEditableRelation((IRelation)this.relations.iterator().next()));
    }

    private static boolean confirmRelationDuplicate(Relation relation) {
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add(new JMultilineLabel("<html>" + I18n.tr("You are about to duplicate {0} relation: {1}<br/>This step is rarely necessary. Do you really want to duplicate?", 1, DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(relation)) + "</html>"));
        return ConditionalOptionPaneUtil.showConfirmationDialog("delete_relations", MainApplication.getMainFrame(), msg, I18n.tr("Duplicate relation?", new Object[0]), 0, 3, 0);
    }
}

