/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import org.openstreetmap.josm.data.coor.Coordinate;

public class EastNorth
extends Coordinate {
    private static final long serialVersionUID = 1L;
    public static final EastNorth ZERO = new EastNorth(0.0, 0.0);

    public EastNorth(double east, double north) {
        super(east, north);
    }

    public double east() {
        return this.x;
    }

    public double north() {
        return this.y;
    }

    public EastNorth add(double dEast, double dNorth) {
        return new EastNorth(this.east() + dEast, this.north() + dNorth);
    }

    public EastNorth add(EastNorth other) {
        return new EastNorth(this.x + other.x, this.y + other.y);
    }

    public EastNorth subtract(EastNorth other) {
        return new EastNorth(this.x - other.x, this.y - other.y);
    }

    public EastNorth scale(double s) {
        return new EastNorth(s * this.x, s * this.y);
    }

    public EastNorth interpolate(EastNorth en2, double proportion) {
        return new EastNorth((1.0 - proportion) * this.x + proportion * en2.x, (1.0 - proportion) * this.y + proportion * en2.y);
    }

    public EastNorth getCenter(EastNorth en2) {
        return this.interpolate(en2, 0.5);
    }

    public double distance(EastNorth en) {
        return super.distance(en);
    }

    public double distanceSq(EastNorth en) {
        return super.distanceSq(en);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double heading(EastNorth other) {
        double hd = Math.atan2(other.east() - this.east(), other.north() - this.north());
        if (hd < 0.0) {
            hd = Math.PI * 2 + hd;
        }
        return hd;
    }

    public double heading(EastNorth other, double refHeading) {
        double hd = this.heading(other);
        if ((hd -= refHeading) < 0.0) {
            hd = Math.PI * 2 + hd;
        }
        return hd;
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isInfinite(this.x) && !Double.isInfinite(this.y);
    }

    public EastNorth rotate(EastNorth pivot, double angle) {
        double cosPhi = Math.cos(angle);
        double sinPhi = Math.sin(angle);
        double x = this.east() - pivot.east();
        double y = this.north() - pivot.north();
        double nx = cosPhi * x + sinPhi * y + pivot.east();
        double ny = -sinPhi * x + cosPhi * y + pivot.north();
        return new EastNorth(nx, ny);
    }

    public String toString() {
        return "EastNorth[e=" + this.x + ", n=" + this.y + "]";
    }

    public boolean equalsEpsilon(EastNorth other, double e) {
        return Math.abs(this.x - other.x) < e && Math.abs(this.y - other.y) < e;
    }
}

