/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.Serializable;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import org.openstreetmap.josm.tools.Utils;

public final class AlphanumComparator
implements Comparator<String>,
Serializable {
    static boolean useFastASCIISort;
    static final String ASCII_SORT_ORDER = " \r\t\n\f\u000b-_,;:!?/.`^~'\"()[]{}@$*\\&#%+<=>|0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final long serialVersionUID = 1L;
    private static final AlphanumComparator INSTANCE;
    private static final byte[] ASCII_MAPPING;

    public static AlphanumComparator getInstance() {
        return INSTANCE;
    }

    private AlphanumComparator() {
    }

    private static int compareString(String string1, int len1, String string2, int len2) {
        int loc1 = 0;
        for (int loc2 = 0; loc1 < len1 && loc2 < len2; ++loc1, ++loc2) {
            char lower2;
            byte c2;
            while (loc1 < len1 - 1 && string1.charAt(loc1) <= ' ') {
                ++loc1;
            }
            while (loc2 < len2 - 1 && string2.charAt(loc2) <= ' ') {
                ++loc2;
            }
            if (loc1 >= len1 || loc2 >= len2) break;
            char lower1 = Character.toLowerCase(string1.charAt(loc1));
            byte c1 = ASCII_MAPPING[lower1];
            if (c1 == (c2 = ASCII_MAPPING[lower2 = Character.toLowerCase(string2.charAt(loc2))])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    private static String getChunk(String s, int slength, int marker) {
        int startMarker = marker;
        char c = s.charAt(marker);
        ++marker;
        if (Character.isDigit(c)) {
            while (marker < slength && Character.isDigit(c = s.charAt(marker))) {
                ++marker;
            }
        } else {
            while (marker < slength && !Character.isDigit(c = s.charAt(marker))) {
                ++marker;
            }
        }
        return s.substring(startMarker, marker);
    }

    private static boolean isAscii(String string, int stringLength) {
        for (int i = 0; i < stringLength; ++i) {
            char c = string.charAt(i);
            if (c <= ASCII_MAPPING.length) continue;
            return false;
        }
        return true;
    }

    private static int compareChunk(String thisChunk, int thisChunkLength, String thatChunk, int thatChunkLength) {
        int result;
        if (Character.isDigit(thisChunk.charAt(0)) && Character.isDigit(thatChunk.charAt(0))) {
            result = thisChunkLength - thatChunkLength;
            if (result == 0) {
                for (int i = 0; i < thisChunkLength; ++i) {
                    result = thisChunk.charAt(i) - thatChunk.charAt(i);
                    if (result == 0) continue;
                    return result;
                }
            }
        } else {
            if (useFastASCIISort && AlphanumComparator.isAscii(thisChunk, thisChunkLength) && AlphanumComparator.isAscii(thatChunk, thatChunkLength)) {
                return Utils.clamp(AlphanumComparator.compareString(thisChunk, thisChunkLength, thatChunk, thatChunkLength), -1, 1);
            }
            Collator compareOperator = Collator.getInstance();
            compareOperator.setStrength(1);
            result = compareOperator.compare(thisChunk, thatChunk);
        }
        return result;
    }

    @Override
    public int compare(String s1, String s2) {
        int thatChunkLength;
        int thisChunkLength;
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int thisMarker = 0;
        int s1Length = s1.length();
        int s2Length = s2.length();
        for (int thatMarker = 0; thisMarker < s1Length && thatMarker < s2Length; thisMarker += thisChunkLength, thatMarker += thatChunkLength) {
            String thisChunk = AlphanumComparator.getChunk(s1, s1Length, thisMarker);
            thisChunkLength = thisChunk.length();
            String thatChunk = AlphanumComparator.getChunk(s2, s2Length, thatMarker);
            thatChunkLength = thatChunk.length();
            int result = AlphanumComparator.compareChunk(thisChunk, thisChunkLength, thatChunk, thatChunkLength);
            if (result == 0) continue;
            return result;
        }
        return s1Length - s2Length;
    }

    static {
        int i;
        useFastASCIISort = true;
        INSTANCE = new AlphanumComparator();
        ASCII_MAPPING = new byte[128];
        for (i = 0; i < ASCII_MAPPING.length; ++i) {
            AlphanumComparator.ASCII_MAPPING[i] = (byte)i;
        }
        Arrays.fill(ASCII_MAPPING, 0, 32, (byte)0);
        AlphanumComparator.ASCII_MAPPING[127] = 0;
        for (i = 0; i < ASCII_SORT_ORDER.length(); ++i) {
            char c = ASCII_SORT_ORDER.charAt(i);
            AlphanumComparator.ASCII_MAPPING[c] = (byte)(i + 1);
        }
    }
}

