/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.tools.template_engine.SearchExpressionCondition;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;

public class Condition
implements TemplateEntry {
    private final List<TemplateEntry> entries;

    public Condition(Collection<TemplateEntry> entries) {
        this.entries = new ArrayList<TemplateEntry>(entries);
    }

    public Condition() {
        this.entries = new ArrayList<TemplateEntry>();
    }

    @Override
    public void appendText(StringBuilder result, TemplateEngineDataProvider dataProvider) {
        for (TemplateEntry entry : this.entries) {
            if (!entry.isValid(dataProvider)) continue;
            entry.appendText(result, dataProvider);
            return;
        }
        TemplateEntry entry = this.entries.get(this.entries.size() - 1);
        entry.appendText(result, dataProvider);
    }

    @Override
    public boolean isValid(TemplateEngineDataProvider dataProvider) {
        return this.entries.stream().anyMatch(entry -> entry.isValid(dataProvider));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("?{ ");
        for (TemplateEntry entry : this.entries) {
            if (entry instanceof SearchExpressionCondition) {
                sb.append(entry);
            } else {
                sb.append('\'').append(entry).append('\'');
            }
            sb.append(" | ");
        }
        sb.setLength(sb.length() - 3);
        sb.append(" }");
        return sb.toString();
    }

    public int hashCode() {
        return 31 + (this.entries == null ? 0 : this.entries.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }
}

