/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.util;

import java.io.Serializable;

public class Flags
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8481587558770237995L;
    private long flags;

    public Flags() {
    }

    public Flags(long flags) {
        this.flags = flags;
    }

    public void clear() {
        this.flags = 0L;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Couldn't clone Flags object.", e);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Flags)) {
            return false;
        }
        Flags other = (Flags)obj;
        return this.flags == other.flags;
    }

    public long getFlags() {
        return this.flags;
    }

    public int hashCode() {
        return (int)this.flags;
    }

    public boolean isOff(long flag) {
        return (this.flags & flag) == 0L;
    }

    public boolean isOn(long flag) {
        return (this.flags & flag) == flag;
    }

    public String toString() {
        StringBuilder bin = new StringBuilder(Long.toBinaryString(this.flags));
        for (int i = 64 - bin.length(); i > 0; --i) {
            bin.insert(0, "0");
        }
        return bin.toString();
    }

    public void turnOff(long flag) {
        this.flags &= flag ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void turnOffAll() {
        this.flags = 0L;
    }

    public void turnOn(long flag) {
        this.flags |= flag;
    }

    public void turnOnAll() {
        this.flags = -1L;
    }
}

