/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Map;
import org.apache.kafka.common.message.ExpireDelegationTokenResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class ExpireDelegationTokenResponse
extends AbstractResponse {
    private final ExpireDelegationTokenResponseData data;

    public ExpireDelegationTokenResponse(ExpireDelegationTokenResponseData data) {
        super(ApiKeys.EXPIRE_DELEGATION_TOKEN);
        this.data = data;
    }

    public static ExpireDelegationTokenResponse parse(Readable readable, short version) {
        return new ExpireDelegationTokenResponse(new ExpireDelegationTokenResponseData(readable, version));
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    public long expiryTimestamp() {
        return this.data.expiryTimestampMs();
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return ExpireDelegationTokenResponse.errorCounts(this.error());
    }

    @Override
    public ExpireDelegationTokenResponseData data() {
        return this.data;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public boolean hasError() {
        return this.error() != Errors.NONE;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

