/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractFetcherManager;
import kafka.server.BrokerBlockingSender;
import kafka.server.KafkaConfig;
import kafka.server.RemoteLeaderEndPoint;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.network.BrokerEndPoint;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\t\u0013\u0001]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tG\u0001\u0011)\u0019!C\tI!A\u0001\u0006\u0001B\u0001B\u0003%Q\u0005\u0003\u0005*\u0001\t\u0005\t\u0015!\u0003+\u0011!1\u0004A!A!\u0002\u00139\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011=\u0003!\u0011!Q\u0001\nAC\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\")!\r\u0001C\u0001G\")Q\u000e\u0001C!]\")A\u0010\u0001C\u0001{\u001eI\u00111\u0001\n\u0002\u0002#\u0005\u0011Q\u0001\u0004\t#I\t\t\u0011#\u0001\u0002\b!1!M\u0004C\u0001\u0003\u001fA\u0011\"!\u0005\u000f#\u0003%\t!a\u0005\u0003+I+\u0007\u000f\\5dC\u001a+Go\u00195fe6\u000bg.Y4fe*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003U\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00011A\u0019\u0011D\u0007\u000f\u000e\u0003II!a\u0007\n\u0003-\u0005\u00137\u000f\u001e:bGR4U\r^2iKJl\u0015M\\1hKJ\u0004\"!G\u000f\n\u0005y\u0011\"\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG-\u0001\u0007ce>\\WM]\"p]\u001aLw\r\u0005\u0002\u001aC%\u0011!E\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003\u0015\u0002\"!\u0007\u0014\n\u0005\u001d\u0012\"A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u00059Q.\u001a;sS\u000e\u001c\bCA\u00165\u001b\u0005a#BA\u0015.\u0015\tqs&\u0001\u0004d_6lwN\u001c\u0006\u0003+AR!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO&\u0011Q\u0007\f\u0002\b\u001b\u0016$(/[2t\u0003\u0011!\u0018.\\3\u0011\u0005aZT\"A\u001d\u000b\u0005ij\u0013!B;uS2\u001c\u0018B\u0001\u001f:\u0005\u0011!\u0016.\\3\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\bcA C\t6\t\u0001IC\u0001B\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0005I\u0001\u0004PaRLwN\u001c\t\u0003\u000b2s!A\u0012&\u0011\u0005\u001d\u0003U\"\u0001%\u000b\u0005%3\u0012A\u0002\u001fs_>$h(\u0003\u0002L\u0001\u00061\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY\u0005)\u0001\u0007rk>$\u0018-T1oC\u001e,'\u000f\u0005\u0002\u001a#&\u0011!K\u0005\u0002\u0018%\u0016\u0004H.[2bi&|g.U;pi\u0006l\u0015M\\1hKJ\fq#\\3uC\u0012\fG/\u0019,feNLwN\\*vaBd\u0017.\u001a:\u0011\u0007}*v+\u0003\u0002W\u0001\nIa)\u001e8di&|g\u000e\r\t\u00031nk\u0011!\u0017\u0006\u0003]iS!aE\u0018\n\u0005qK&aD'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8\u0002'\t\u0014xn[3s\u000bB|7\r[*vaBd\u0017.\u001a:\u0011\u0007}*v\f\u0005\u0002@A&\u0011\u0011\r\u0011\u0002\u0005\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\nI\u00164w\r[5kW2\u0004\"!\u0007\u0001\t\u000b}Q\u0001\u0019\u0001\u0011\t\u000b\rR\u0001\u0019A\u0013\t\u000b%R\u0001\u0019\u0001\u0016\t\u000bYR\u0001\u0019A\u001c\t\u000fuR\u0001\u0013!a\u0001}!)qJ\u0003a\u0001!\")1K\u0003a\u0001)\")QL\u0003a\u0001=\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR\u0019Ad\u001c;\t\u000bA\\\u0001\u0019A9\u0002\u0013\u0019,Go\u00195fe&#\u0007CA s\u0013\t\u0019\bIA\u0002J]RDQ!^\u0006A\u0002Y\fAb]8ve\u000e,'I]8lKJ\u0004\"a\u001e>\u000e\u0003aT!!\u001f.\u0002\u000f9,Go^8sW&\u00111\u0010\u001f\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0003!\u0019\b.\u001e;e_^tG#\u0001@\u0011\u0005}z\u0018bAA\u0001\u0001\n!QK\\5u\u0003U\u0011V\r\u001d7jG\u00064U\r^2iKJl\u0015M\\1hKJ\u0004\"!\u0007\b\u0014\u00079\tI\u0001E\u0002@\u0003\u0017I1!!\u0004A\u0005\u0019\te.\u001f*fMR\u0011\u0011QA\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005U!f\u0001 \u0002\u0018-\u0012\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003%)hn\u00195fG.,GMC\u0002\u0002$\u0001\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9#!\b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ReplicaFetcherManager
extends AbstractFetcherManager<ReplicaFetcherThread> {
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final Metrics metrics;
    private final Time time;
    private final Option<String> threadNamePrefix;
    private final ReplicationQuotaManager quotaManager;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Function0<Object> brokerEpochSupplier;

    public static Option<String> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Override
    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
        String threadName = (String)this.threadNamePrefix.map((Function1 & Serializable)tp -> tp + ":").getOrElse((Function0 & Serializable)() -> "") + "ReplicaFetcherThread-" + fetcherId + "-" + sourceBroker.id();
        LogContext logContext = new LogContext("[ReplicaFetcher replicaId=" + this.brokerConfig.brokerId() + ", leaderId=" + sourceBroker.id() + ", fetcherId=" + fetcherId + "] ");
        BrokerBlockingSender endpoint = new BrokerBlockingSender(sourceBroker, this.brokerConfig, this.metrics, this.time, fetcherId, "broker-" + this.brokerConfig.brokerId() + "-fetcher-" + fetcherId, logContext);
        FetchSessionHandler fetchSessionHandler = new FetchSessionHandler(logContext, sourceBroker.id());
        RemoteLeaderEndPoint leader = new RemoteLeaderEndPoint(logContext.logPrefix(), endpoint, fetchSessionHandler, this.brokerConfig, this.replicaManager(), this.quotaManager, this.metadataVersionSupplier, this.brokerEpochSupplier);
        return new ReplicaFetcherThread(threadName, leader, this.brokerConfig, this.failedPartitions(), this.replicaManager(), this.quotaManager, logContext.logPrefix());
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutting down");
        this.closeAllFetchers();
        this.info((Function0<String>)(Function0 & Serializable)() -> "shutdown completed");
    }

    public ReplicaFetcherManager(KafkaConfig brokerConfig, ReplicaManager replicaManager, Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager, Function0<MetadataVersion> metadataVersionSupplier, Function0<Object> brokerEpochSupplier) {
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaManager = quotaManager;
        this.metadataVersionSupplier = metadataVersionSupplier;
        this.brokerEpochSupplier = brokerEpochSupplier;
        super("ReplicaFetcherManager on broker " + brokerConfig.brokerId(), "Replica", brokerConfig.numReplicaFetchers());
    }
}

