/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;

public class WindowedChangelogTopicConfig
extends InternalTopicConfig {
    private static final Map<String, String> WINDOWED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES;
    private final long retentionMs;

    WindowedChangelogTopicConfig(String name, Map<String, String> topicConfigs, long retentionMs) {
        super(name, topicConfigs);
        this.retentionMs = retentionMs;
    }

    @Override
    public Map<String, String> properties(Map<String, String> defaultProperties, long additionalRetentionMs) {
        HashMap<String, String> topicConfig = new HashMap<String, String>(WINDOWED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES);
        topicConfig.putAll(defaultProperties);
        topicConfig.putAll(this.topicConfigs);
        if (!this.topicConfigs.containsKey("retention.ms")) {
            long retentionValue;
            try {
                retentionValue = Math.addExact(this.retentionMs, additionalRetentionMs);
            }
            catch (ArithmeticException swallow) {
                retentionValue = Long.MAX_VALUE;
            }
            topicConfig.put("retention.ms", String.valueOf(retentionValue));
        }
        return topicConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowedChangelogTopicConfig that = (WindowedChangelogTopicConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.topicConfigs, that.topicConfigs) && Objects.equals(this.retentionMs, that.retentionMs) && Objects.equals(this.enforceNumberOfPartitions, that.enforceNumberOfPartitions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.topicConfigs, this.retentionMs, this.enforceNumberOfPartitions);
    }

    @Override
    public String toString() {
        return "WindowedChangelogTopicConfig(name=" + this.name + ", topicConfigs=" + String.valueOf(this.topicConfigs) + ", retentionMs=" + this.retentionMs + ", enforceNumberOfPartitions=" + this.enforceNumberOfPartitions + ")";
    }

    static {
        HashMap<String, String> tempTopicDefaultOverrides = new HashMap<String, String>(INTERNAL_TOPIC_DEFAULT_OVERRIDES);
        tempTopicDefaultOverrides.put("cleanup.policy", "compact,delete");
        WINDOWED_STORE_CHANGELOG_TOPIC_DEFAULT_OVERRIDES = Collections.unmodifiableMap(tempTopicDefaultOverrides);
    }
}

