/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.crypto;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.common.crypto.UserIdentityExtractor;
import org.keycloak.common.util.PemUtils;

public abstract class UserIdentityExtractorProvider {
    private static final Logger logger = Logger.getLogger(UserIdentityExtractorProvider.class);

    public OrBuilder either(UserIdentityExtractor extractor) {
        return new OrBuilder(extractor);
    }

    public UserIdentityExtractor getCertificatePemIdentityExtractor() {
        return new UserIdentityExtractor(){

            @Override
            public Object extractUserIdentity(X509Certificate[] certs) {
                if (certs == null || certs.length == 0) {
                    throw new IllegalArgumentException();
                }
                String pem = PemUtils.encodeCertificate(certs[0]);
                logger.debugf("Using PEM certificate \"%s\" as user identity.", (Object)pem);
                return pem;
            }
        };
    }

    public UserIdentityExtractor getPatternIdentityExtractor(String pattern, Function<X509Certificate[], String> valueToMatch) {
        return new PatternMatcher(pattern, valueToMatch);
    }

    public abstract UserIdentityExtractor getX500NameExtractor(String var1, Function<X509Certificate[], Principal> var2);

    public abstract SubjectAltNameExtractor getSubjectAltNameExtractor(int var1);

    public class OrBuilder {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrBuilder(UserIdentityExtractor extractor) {
            this.extractor = extractor;
        }

        public UserIdentityExtractor or(UserIdentityExtractor other) {
            return new OrExtractor(this.extractor, other);
        }
    }

    public class PatternMatcher
    implements UserIdentityExtractor {
        private final String _pattern;
        private final Function<X509Certificate[], String> _f;

        PatternMatcher(String pattern, Function<X509Certificate[], String> valueToMatch) {
            this._pattern = pattern;
            this._f = valueToMatch;
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            String value = Optional.ofNullable(this._f.apply(certs)).orElseThrow(IllegalArgumentException::new);
            Pattern r = Pattern.compile(this._pattern, 2);
            Matcher m = r.matcher(value);
            if (!m.find()) {
                logger.debugf("[PatternMatcher:extract] No matches were found for input \"%s\", pattern=\"%s\"", (Object)value, (Object)this._pattern);
                return null;
            }
            if (m.groupCount() != 1) {
                logger.debugf("[PatternMatcher:extract] Match produced more than a single group for input \"%s\", pattern=\"%s\"", (Object)value, (Object)this._pattern);
                return null;
            }
            return m.group(1);
        }
    }

    protected class OrExtractor
    implements UserIdentityExtractor {
        UserIdentityExtractor extractor;
        UserIdentityExtractor other;

        OrExtractor(UserIdentityExtractor extractor, UserIdentityExtractor other) {
            this.extractor = extractor;
            this.other = other;
            if (this.extractor == null) {
                throw new IllegalArgumentException("extractor is null");
            }
            if (this.other == null) {
                throw new IllegalArgumentException("other is null");
            }
        }

        @Override
        public Object extractUserIdentity(X509Certificate[] certs) {
            Object result = this.extractor.extractUserIdentity(certs);
            if (result == null) {
                result = this.other.extractUserIdentity(certs);
            }
            return result;
        }
    }

    public abstract class X500NameRDNExtractor
    implements UserIdentityExtractor {
    }

    public abstract class SubjectAltNameExtractor
    implements UserIdentityExtractor {
    }
}

