/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.protocol.saml.util.ArtifactBindingUtils;

public class JpaUpdate14_0_0_MigrateSamlArtifactAttribute
extends CustomKeycloakTask {
    private static final String SAML_ARTIFACT_BINDING_IDENTIFIER = "saml.artifact.binding.identifier";
    private final Map<String, String> clientIds = new HashMap<String, String>();

    @Override
    protected void generateStatementsImpl() throws CustomChangeException {
        this.extractClientsData("SELECT C.ID, C.CLIENT_ID FROM " + this.getTableName("CLIENT") + " C LEFT JOIN " + this.getTableName("CLIENT_ATTRIBUTES") + " CA ON C.ID = CA.CLIENT_ID AND CA.NAME='saml.artifact.binding.identifier' WHERE C.PROTOCOL='saml' AND CA.NAME IS NULL");
        for (Map.Entry<String, String> clientPair : this.clientIds.entrySet()) {
            String id = clientPair.getKey();
            String clientId = clientPair.getValue();
            String samlIdentifier = ArtifactBindingUtils.computeArtifactBindingIdentifierString((String)clientId);
            this.statements.add(new InsertStatement(null, null, this.database.correctObjectName("CLIENT_ATTRIBUTES", Table.class)).addColumnValue("CLIENT_ID", (Object)id).addColumnValue("NAME", (Object)SAML_ARTIFACT_BINDING_IDENTIFIER).addColumnValue("VALUE", (Object)samlIdentifier));
        }
    }

    private void extractClientsData(String sql) throws CustomChangeException {
        try (PreparedStatement statement = this.jdbcConnection.prepareStatement(sql);
             ResultSet rs = statement.executeQuery();){
            while (rs.next()) {
                String id = rs.getString(1);
                String clientId = rs.getString(2);
                if (id == null || id.trim().isEmpty() || clientId == null || clientId.trim().isEmpty()) continue;
                this.clientIds.put(id, clientId);
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when extracting data from previous version", (Throwable)e);
        }
    }

    @Override
    protected String getTaskId() {
        return "Migrate Saml attributes (14.0.0)";
    }
}

