/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.TypeTarget;

public interface AnnotationTarget {
    public Kind kind();

    public boolean isDeclaration();

    public Declaration asDeclaration();

    public ClassInfo asClass();

    public FieldInfo asField();

    public MethodInfo asMethod();

    public MethodParameterInfo asMethodParameter();

    public TypeTarget asType();

    public RecordComponentInfo asRecordComponent();

    public boolean hasAnnotation(DotName var1);

    default public boolean hasAnnotation(String name) {
        return this.hasAnnotation(DotName.createSimple(name));
    }

    default public boolean hasAnnotation(Class<? extends Annotation> clazz) {
        return this.hasAnnotation(DotName.createSimple(clazz.getName()));
    }

    public AnnotationInstance annotation(DotName var1);

    default public AnnotationInstance annotation(String name) {
        return this.annotation(DotName.createSimple(name));
    }

    default public AnnotationInstance annotation(Class<? extends Annotation> clazz) {
        return this.annotation(DotName.createSimple(clazz.getName()));
    }

    public Collection<AnnotationInstance> annotations(DotName var1);

    default public Collection<AnnotationInstance> annotations(String name) {
        return this.annotations(DotName.createSimple(name));
    }

    default public Collection<AnnotationInstance> annotations(Class<? extends Annotation> clazz) {
        return this.annotations(DotName.createSimple(clazz.getName()));
    }

    public Collection<AnnotationInstance> annotationsWithRepeatable(DotName var1, IndexView var2);

    default public Collection<AnnotationInstance> annotationsWithRepeatable(String name, IndexView index) {
        return this.annotationsWithRepeatable(DotName.createSimple(name), index);
    }

    default public Collection<AnnotationInstance> annotationsWithRepeatable(Class<? extends Annotation> clazz, IndexView index) {
        return this.annotationsWithRepeatable(DotName.createSimple(clazz.getName()), index);
    }

    public Collection<AnnotationInstance> annotations();

    public boolean hasDeclaredAnnotation(DotName var1);

    default public boolean hasDeclaredAnnotation(String name) {
        return this.hasDeclaredAnnotation(DotName.createSimple(name));
    }

    default public boolean hasDeclaredAnnotation(Class<? extends Annotation> clazz) {
        return this.hasDeclaredAnnotation(DotName.createSimple(clazz.getName()));
    }

    public AnnotationInstance declaredAnnotation(DotName var1);

    default public AnnotationInstance declaredAnnotation(String name) {
        return this.declaredAnnotation(DotName.createSimple(name));
    }

    default public AnnotationInstance declaredAnnotation(Class<? extends Annotation> clazz) {
        return this.declaredAnnotation(DotName.createSimple(clazz.getName()));
    }

    public Collection<AnnotationInstance> declaredAnnotationsWithRepeatable(DotName var1, IndexView var2);

    default public Collection<AnnotationInstance> declaredAnnotationsWithRepeatable(String name, IndexView index) {
        return this.declaredAnnotationsWithRepeatable(DotName.createSimple(name), index);
    }

    default public Collection<AnnotationInstance> declaredAnnotationsWithRepeatable(Class<? extends Annotation> clazz, IndexView index) {
        return this.declaredAnnotationsWithRepeatable(DotName.createSimple(clazz.getName()), index);
    }

    public Collection<AnnotationInstance> declaredAnnotations();

    public static enum Kind {
        CLASS,
        FIELD,
        METHOD,
        METHOD_PARAMETER,
        TYPE,
        RECORD_COMPONENT;

    }
}

