/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.ClientInitialAccessModel;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.Provider;

public interface RealmProvider
extends Provider {
    public RealmModel createRealm(String var1);

    public RealmModel createRealm(String var1, String var2);

    public RealmModel getRealm(String var1);

    public RealmModel getRealmByName(String var1);

    public Stream<RealmModel> getRealmsStream();

    default public Stream<RealmModel> getRealmsStream(String search) {
        return this.getRealmsStream().filter(realm -> search.isEmpty() || realm.getName().toLowerCase().contains(search.trim().toLowerCase()));
    }

    public Stream<RealmModel> getRealmsWithProviderTypeStream(Class<?> var1);

    public boolean removeRealm(String var1);

    default public ClientInitialAccessModel createClientInitialAccessModel(RealmModel realm, int expiration, int count) {
        return realm.createClientInitialAccessModel(expiration, count);
    }

    default public ClientInitialAccessModel getClientInitialAccessModel(RealmModel realm, String id) {
        return realm.getClientInitialAccessModel(id);
    }

    default public void removeClientInitialAccessModel(RealmModel realm, String id) {
        realm.removeClientInitialAccessModel(id);
    }

    default public Stream<ClientInitialAccessModel> listClientInitialAccessStream(RealmModel realm) {
        return realm.getClientInitialAccesses();
    }

    public void removeExpiredClientInitialAccess();

    default public void decreaseRemainingCount(RealmModel realm, ClientInitialAccessModel clientInitialAccess) {
        realm.decreaseRemainingCount(clientInitialAccess);
    }

    public void saveLocalizationText(RealmModel var1, String var2, String var3, String var4);

    public void saveLocalizationTexts(RealmModel var1, String var2, Map<String, String> var3);

    public boolean updateLocalizationText(RealmModel var1, String var2, String var3, String var4);

    public boolean deleteLocalizationTextsByLocale(RealmModel var1, String var2);

    public boolean deleteLocalizationText(RealmModel var1, String var2, String var3);

    public String getLocalizationTextsById(RealmModel var1, String var2, String var3);
}

