/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.ipatuura_user_spi.authenticator;

import jakarta.ws.rs.core.HttpHeaders;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;

public class IpatuuraAuthenticator {
    private static final Logger logger = Logger.getLogger(IpatuuraAuthenticator.class);

    public String getToken(KeycloakSession session) {
        HttpHeaders headers = session.getContext().getHttpRequest().getHttpHeaders();
        String authHeader = (String)headers.getRequestHeaders().getFirst((Object)"Authorization");
        if (authHeader == null) {
            logger.debug((Object)"authHeader == NULL()!");
            return null;
        }
        String[] tokens = authHeader.split(" ");
        if (tokens.length == 0) {
            logger.debug((Object)("Invalid length of tokens: " + tokens.length));
            return null;
        }
        if (!"Negotiate".equalsIgnoreCase(tokens[0])) {
            logger.debug((Object)("Unknown scheme " + tokens[0]));
            return null;
        }
        if (tokens.length != 2) {
            logger.debug((Object)"Invalid credentials tokens.length != 2");
            return null;
        }
        String spnegoToken = tokens[1];
        return spnegoToken;
    }
}

